/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestSaslRPC;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenInfo;
import org.junit.Test;

public class TestDoAsEffectiveUser {
    private static final String REAL_USER_NAME = "realUser1@HADOOP.APACHE.ORG";
    private static final String REAL_USER_SHORT_NAME = "realUser1";
    private static final String PROXY_USER_NAME = "proxyUser";
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2"};
    private static final String ADDRESS = "0.0.0.0";
    private TestProtocol proxy;
    private static Configuration masterConf = new Configuration();
    public static final Log LOG = LogFactory.getLog(TestDoAsEffectiveUser.class);

    private void configureSuperUserIPAddresses(Configuration conf, String superUserShortName) throws IOException {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> netInterfaceList = NetworkInterface.getNetworkInterfaces();
        while (netInterfaceList.hasMoreElements()) {
            NetworkInterface inf = netInterfaceList.nextElement();
            Enumeration<InetAddress> addrList = inf.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                ipList.add(addr.getHostAddress());
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String ip : ipList) {
            builder.append(ip);
            builder.append(',');
        }
        builder.append("127.0.1.1,");
        builder.append(InetAddress.getLocalHost().getCanonicalHostName());
        LOG.info((Object)("Local Ip addresses: " + builder.toString()));
        conf.setStrings(ProxyUsers.getProxySuperuserIpConfKey((String)superUserShortName), new String[]{builder.toString()});
    }

    @Test
    public void testCreateProxyUser() throws Exception {
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUser((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi);
        UserGroupInformation curUGI = (UserGroupInformation)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<UserGroupInformation>(){

            @Override
            public UserGroupInformation run() throws IOException {
                return UserGroupInformation.getCurrentUser();
            }
        });
        Assert.assertTrue((boolean)curUGI.toString().equals("proxyUser via realUser1@HADOOP.APACHE.ORG"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserSetup() throws IOException {
        final Configuration conf = new Configuration();
        conf.setStrings(ProxyUsers.getProxySuperuserGroupConfKey((String)REAL_USER_SHORT_NAME), new String[]{GROUP1_NAME});
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        RPC.Server server = RPC.getServer((Object)new TestImpl(), (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)conf, null);
        this.refreshConf(conf);
        try {
            server.start();
            final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                    String ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return ret;
                }
            });
            Assert.assertEquals((String)"proxyUser via realUser1@HADOOP.APACHE.ORG", (String)retVal);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy((VersionedProtocol)this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserAuthorizationSuccess() throws IOException {
        final Configuration conf = new Configuration();
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        conf.setStrings(ProxyUsers.getProxySuperuserGroupConfKey((String)REAL_USER_SHORT_NAME), new String[]{GROUP1_NAME});
        RPC.Server server = RPC.getServer((Object)new TestImpl(), (String)ADDRESS, (int)0, (int)2, (boolean)false, (Configuration)conf, null);
        this.refreshConf(conf);
        try {
            server.start();
            final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                    String ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return ret;
                }
            });
            Assert.assertEquals((String)"proxyUser via realUser1@HADOOP.APACHE.ORG", (String)retVal);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy((VersionedProtocol)this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserIPAuthorizationFailure() throws IOException {
        final Configuration conf = new Configuration(masterConf);
        conf.setStrings(ProxyUsers.getProxySuperuserIpConfKey((String)REAL_USER_SHORT_NAME), new String[]{"20.20.20.20"});
        conf.setStrings(ProxyUsers.getProxySuperuserGroupConfKey((String)REAL_USER_SHORT_NAME), new String[]{GROUP1_NAME});
        RPC.Server server = RPC.getServer((Object)new TestImpl(), (String)ADDRESS, (int)0, (int)2, (boolean)false, (Configuration)conf, null);
        this.refreshConf(conf);
        try {
            server.start();
            final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                    String ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return ret;
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy((VersionedProtocol)this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserIPNotSpecified() throws IOException {
        final Configuration conf = new Configuration();
        conf.setStrings(ProxyUsers.getProxySuperuserGroupConfKey((String)REAL_USER_SHORT_NAME), new String[]{GROUP1_NAME});
        RPC.Server server = RPC.getServer((Object)new TestImpl(), (String)ADDRESS, (int)0, (int)2, (boolean)false, (Configuration)conf, null);
        this.refreshConf(conf);
        try {
            server.start();
            final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                    String ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return ret;
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy((VersionedProtocol)this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserGroupNotSpecified() throws IOException {
        final Configuration conf = new Configuration();
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        RPC.Server server = RPC.getServer((Object)new TestImpl(), (String)ADDRESS, (int)0, (int)2, (boolean)false, (Configuration)conf, null);
        this.refreshConf(conf);
        try {
            server.start();
            final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                    String ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return ret;
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy((VersionedProtocol)this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserGroupAuthorizationFailure() throws IOException {
        final Configuration conf = new Configuration();
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        conf.setStrings(ProxyUsers.getProxySuperuserGroupConfKey((String)REAL_USER_SHORT_NAME), new String[]{"group3"});
        RPC.Server server = RPC.getServer((Object)new TestImpl(), (String)ADDRESS, (int)0, (int)2, (boolean)false, (Configuration)conf, null);
        this.refreshConf(conf);
        try {
            server.start();
            final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                    String ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return ret;
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy((VersionedProtocol)this.proxy);
            }
        }
    }

    @Test
    public void testProxyWithToken() throws Exception {
        final Configuration conf = new Configuration(masterConf);
        TestSaslRPC.TestTokenSecretManager sm = new TestSaslRPC.TestTokenSecretManager();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        RPC.Server server = RPC.getServer((Object)new TestImpl(), (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)conf, (SecretManager)sm);
        server.start();
        UserGroupInformation current = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        TestSaslRPC.TestTokenIdentifier tokenId = new TestSaslRPC.TestTokenIdentifier(new Text(current.getUserName()), new Text("SomeSuperUser"));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        SecurityUtil.setTokenService((Token)token, (InetSocketAddress)addr);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)current, (String[])GROUP_NAMES);
        proxyUserUgi.addToken(token);
        this.refreshConf(conf);
        String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>((Server)server){
            final /* synthetic */ Server val$server;
            {
                this.val$server = server;
            }

            @Override
            public String run() throws Exception {
                try {
                    String ret;
                    TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                    String string = ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return string;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    this.val$server.stop();
                    if (TestDoAsEffectiveUser.this.proxy != null) {
                        RPC.stopProxy((VersionedProtocol)TestDoAsEffectiveUser.this.proxy);
                    }
                }
            }
        });
        Assert.assertEquals((String)"realUser1@HADOOP.APACHE.ORG via SomeSuperUser", (String)retVal);
    }

    @Test
    public void testTokenBySuperUser() throws Exception {
        TestSaslRPC.TestTokenSecretManager sm = new TestSaslRPC.TestTokenSecretManager();
        final Configuration newConf = new Configuration(masterConf);
        newConf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)newConf);
        RPC.Server server = RPC.getServer((Object)new TestImpl(), (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)newConf, (SecretManager)sm);
        server.start();
        UserGroupInformation current = UserGroupInformation.createUserForTesting((String)REAL_USER_NAME, (String[])GROUP_NAMES);
        this.refreshConf(newConf);
        final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        TestSaslRPC.TestTokenIdentifier tokenId = new TestSaslRPC.TestTokenIdentifier(new Text(current.getUserName()), new Text("SomeSuperUser"));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        SecurityUtil.setTokenService((Token)token, (InetSocketAddress)addr);
        current.addToken(token);
        String retVal = (String)current.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>((Server)server){
            final /* synthetic */ Server val$server;
            {
                this.val$server = server;
            }

            @Override
            public String run() throws Exception {
                try {
                    String ret;
                    TestDoAsEffectiveUser.this.proxy = (TestProtocol)RPC.getProxy(TestProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)newConf);
                    String string = ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return string;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    this.val$server.stop();
                    if (TestDoAsEffectiveUser.this.proxy != null) {
                        RPC.stopProxy((VersionedProtocol)TestDoAsEffectiveUser.this.proxy);
                    }
                }
            }
        });
        String expected = "realUser1@HADOOP.APACHE.ORG via SomeSuperUser";
        Assert.assertEquals((String)(retVal + "!=" + expected), (String)expected, (String)retVal);
    }

    private void refreshConf(Configuration conf) throws IOException {
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
    }

    static {
        masterConf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](.*@HADOOP.APACHE.ORG)s/@.*//RULE:[1:$1@$0](.*@HADOOP.APACHE.ORG)s/@.*//DEFAULT");
        UserGroupInformation.setConfiguration((Configuration)masterConf);
    }

    public class TestImpl
    implements TestProtocol {
        @Override
        public String aMethod() throws IOException {
            return UserGroupInformation.getCurrentUser().toString();
        }

        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 1L;
        }
    }

    @TokenInfo(value=TestSaslRPC.TestTokenSelector.class)
    public static interface TestProtocol
    extends VersionedProtocol {
        public static final long versionID = 1L;

        public String aMethod() throws IOException;
    }
}

