/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.PiEstimator;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TestMiniMRWithDFS;
import org.apache.log4j.Level;

public class TestTaskLimits
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestMiniMRWithDFS.class.getName());
    static final int NUM_MAPS = 5;
    static final int NUM_SAMPLES = 100;

    public TestTaskLimits() {
        ((Log4JLogger)JobInProgress.LOG).getLogger().setLevel(Level.ALL);
    }

    static void runPI(MiniMRCluster mr, JobConf jobconf) throws IOException {
        LOG.info((Object)"runPI");
        double estimate = PiEstimator.estimate((int)5, (long)100L, (JobConf)jobconf).doubleValue();
        double error = Math.abs(Math.PI - estimate);
        System.out.println("PI estimation " + error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runReduceLimitCheck() throws IOException {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fileSys = null;
        boolean success = false;
        try {
            int taskTrackers = 2;
            Configuration conf = new Configuration();
            conf.setInt("mapred.jobtracker.maxtasks.per.job", -1);
            dfs = new MiniDFSCluster(conf, 4, true, null);
            fileSys = dfs.getFileSystem();
            JobConf jconf = new JobConf(conf);
            mr = new MiniMRCluster(0, 0, 2, fileSys.getUri().toString(), 1, null, null, null, jconf);
            JobConf jc = mr.createJobConf();
            jc.setLong("mapreduce.reduce.input.limit", 10L);
            try {
                TestTaskLimits.runPI(mr, jc);
                success = false;
            }
            catch (IOException e) {
                success = true;
            }
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runOneTest(int maxTasks) throws IOException {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fileSys = null;
        boolean success = false;
        try {
            int taskTrackers = 2;
            Configuration conf = new Configuration();
            conf.setInt("mapred.jobtracker.maxtasks.per.job", maxTasks);
            dfs = new MiniDFSCluster(conf, 4, true, null);
            fileSys = dfs.getFileSystem();
            JobConf jconf = new JobConf(conf);
            mr = new MiniMRCluster(0, 0, 2, fileSys.getUri().toString(), 1, null, null, null, jconf);
            JobConf jc = mr.createJobConf();
            try {
                TestTaskLimits.runPI(mr, jc);
                success = true;
            }
            catch (IOException e) {
                success = false;
            }
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
        return success;
    }

    public void testTaskLimits() throws IOException {
        System.out.println("Job 1 running with max set to 2");
        boolean status = this.runOneTest(2);
        TestTaskLimits.assertTrue((!status ? 1 : 0) != 0);
        System.out.println("Job 1 failed as expected.");
        System.out.println("Job 2 running with max set to 7.");
        status = this.runOneTest(7);
        TestTaskLimits.assertTrue((status ? 1 : 0) != 0);
        System.out.println("Job 2 succeeded as expected.");
        System.out.println("Job 3 running with max disabled.");
        status = this.runOneTest(-1);
        TestTaskLimits.assertTrue((status ? 1 : 0) != 0);
        System.out.println("Job 3 succeeded as expected.");
        status = this.runReduceLimitCheck();
        TestTaskLimits.assertTrue((status ? 1 : 0) != 0);
        System.out.println("Success: Reduce limit as expected");
    }

    public static class TestResult {
        public String output;
        public RunningJob job;

        TestResult(RunningJob job, String output) {
            this.job = job;
            this.output = output;
        }
    }
}

