/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskLogServlet;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.TestMiniMRMapRedDebugScript;
import org.apache.hadoop.mapred.TestWebUIAuthorization;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class TestTaskFail
extends TestCase {
    private static String taskLog = "Task attempt log";
    static String cleanupLog = "cleanup attempt log";

    public RunningJob launchJob(JobConf conf, Path inDir, Path outDir, String input) throws IOException {
        FileSystem inFs = inDir.getFileSystem((Configuration)conf);
        FileSystem outFs = outDir.getFileSystem((Configuration)conf);
        outFs.delete(outDir, true);
        if (!inFs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = inFs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        conf.setMapperClass(MapperClass.class);
        conf.setReducerClass(IdentityReducer.class);
        conf.setNumReduceTasks(0);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setSpeculativeExecution(false);
        String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
        conf.set("test.build.data", TEST_ROOT_DIR);
        return new JobClient(conf).submitJob(conf);
    }

    private void validateAttempt(TaskInProgress tip, TaskAttemptID attemptId, TaskStatus ts, boolean isCleanup, JobTracker jt) throws IOException {
        TestTaskFail.assertEquals((boolean)isCleanup, (boolean)tip.isCleanupAttempt(attemptId));
        TestTaskFail.assertTrue((ts != null ? 1 : 0) != 0);
        TestTaskFail.assertEquals((Object)TaskStatus.State.FAILED, (Object)ts.getRunState());
        String log = TestMiniMRMapRedDebugScript.readTaskLog(TaskLog.LogName.STDERR, attemptId, false);
        TestTaskFail.assertTrue((boolean)log.contains(taskLog));
        TaskTrackerStatus ttStatus = jt.getTaskTracker(tip.machineWhereTaskRan(attemptId)).getStatus();
        String tasklogUrl = TaskLogServlet.getTaskLogUrl((String)"localhost", (String)String.valueOf(ttStatus.getHttpPort()), (String)attemptId.toString());
        TestTaskFail.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(tasklogUrl, tip.getUser(), "GET"));
        if (!isCleanup) {
            TestTaskFail.assertTrue((boolean)log.contains(cleanupLog));
        } else {
            log = TestMiniMRMapRedDebugScript.readTaskLog(TaskLog.LogName.STDERR, attemptId, true);
            TestTaskFail.assertTrue((boolean)log.contains(cleanupLog));
            ttStatus = jt.getTaskTracker(tip.machineWhereCleanupRan(attemptId)).getStatus();
            String cleanupTasklogUrl = TaskLogServlet.getTaskLogUrl((String)"localhost", (String)String.valueOf(ttStatus.getHttpPort()), (String)attemptId.toString()) + "&cleanup=true";
            TestTaskFail.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(cleanupTasklogUrl, tip.getUser(), "GET"));
        }
    }

    private void validateJob(RunningJob job, JobTracker jt) throws IOException {
        TestTaskFail.assertEquals((int)2, (int)job.getJobState());
        JobID jobId = job.getID();
        TaskAttemptID attemptId = new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, true, 0), 0);
        TaskInProgress tip = jt.getTip(attemptId.getTaskID());
        TaskStatus ts = jt.getTaskStatus(attemptId);
        this.validateAttempt(tip, attemptId, ts, false, jt);
        attemptId = new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, true, 0), 1);
        ts = jt.getTaskStatus(attemptId);
        this.validateAttempt(tip, attemptId, ts, true, jt);
        attemptId = new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, true, 0), 2);
        ts = jt.getTaskStatus(attemptId);
        this.validateAttempt(tip, attemptId, ts, true, jt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithDFS() throws IOException {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fileSys = null;
        try {
            int taskTrackers = 4;
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 4, true, null);
            fileSys = dfs.getFileSystem();
            mr = new MiniMRCluster(4, fileSys.getUri().toString(), 1);
            JobTracker jt = mr.getJobTrackerRunner().getJobTracker();
            Path inDir = new Path("./input");
            Path outDir = new Path("./output");
            String input = "The quick brown fox\nhas many silly\nred fox sox\n";
            JobConf jobConf = mr.createJobConf();
            jobConf.setOutputCommitter(CommitterWithLogs.class);
            RunningJob rJob = this.launchJob(jobConf, inDir, outDir, input);
            rJob.waitForCompletion();
            this.validateJob(rJob, jt);
            fileSys.delete(outDir, true);
            jobConf.setOutputCommitter(CommitterWithFailTaskCleanup.class);
            rJob = this.launchJob(jobConf, inDir, outDir, input);
            rJob.waitForCompletion();
            this.validateJob(rJob, jt);
            fileSys.delete(outDir, true);
            jobConf.setOutputCommitter(CommitterWithFailTaskCleanup2.class);
            rJob = this.launchJob(jobConf, inDir, outDir, input);
            rJob.waitForCompletion();
            this.validateJob(rJob, jt);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        TestTaskFail td = new TestTaskFail();
        td.testWithDFS();
    }

    static class CommitterWithFailTaskCleanup2
    extends FileOutputCommitter {
        CommitterWithFailTaskCleanup2() {
        }

        public void abortTask(TaskAttemptContext context) throws IOException {
            System.err.println(cleanupLog);
            throw new IOException();
        }
    }

    static class CommitterWithFailTaskCleanup
    extends FileOutputCommitter {
        CommitterWithFailTaskCleanup() {
        }

        public void abortTask(TaskAttemptContext context) throws IOException {
            System.err.println(cleanupLog);
            System.exit(-1);
        }
    }

    static class CommitterWithLogs
    extends FileOutputCommitter {
        CommitterWithLogs() {
        }

        public void abortTask(TaskAttemptContext context) throws IOException {
            System.err.println(cleanupLog);
            String attemptId = System.getProperty("hadoop.tasklog.taskid");
            Assert.assertNotNull((Object)attemptId);
            if (attemptId.endsWith("_0")) {
                Assert.assertFalse((boolean)Boolean.getBoolean(System.getProperty("hadoop.tasklog.iscleanup")));
            } else {
                Assert.assertTrue((boolean)Boolean.getBoolean(System.getProperty("hadoop.tasklog.iscleanup")));
            }
            super.abortTask(context);
        }
    }

    public static class MapperClass
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, IntWritable> {
        String taskid;

        public void configure(JobConf job) {
            this.taskid = job.get("mapred.task.id");
        }

        public void map(LongWritable key, Text value, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            System.err.println(taskLog);
            Assert.assertFalse((boolean)Boolean.getBoolean(System.getProperty("hadoop.tasklog.iscleanup")));
            if (this.taskid.endsWith("_0")) {
                throw new IOException();
            }
            if (this.taskid.endsWith("_1")) {
                System.exit(-1);
            } else if (this.taskid.endsWith("_2")) {
                throw new Error();
            }
        }
    }
}

