/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.TestQueueManager;
import org.apache.hadoop.security.UserGroupInformation;

public class TestQueueManagerForJobKillAndNonDefaultQueue
extends TestQueueManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDisabledACLForNonDefaultQueue() throws IOException, InterruptedException {
        try {
            JobConf conf = this.setupConf(QueueManager.toFullPropertyName((String)"default", (String)this.submitAcl), "*");
            conf.set("mapred.queue.names", "default,q1");
            conf.set(QueueManager.toFullPropertyName((String)"q1", (String)this.submitAcl), "dummy-user");
            this.verifyJobSubmission(conf, false, "user1,group1", "q1");
        }
        finally {
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnabledACLForNonDefaultQueue() throws IOException, LoginException, InterruptedException {
        try {
            UserGroupInformation ugi = this.createNecessaryUsers();
            String[] groups = ugi.getGroupNames();
            String userName = ugi.getShortUserName();
            JobConf conf = this.setupConf(QueueManager.toFullPropertyName((String)"default", (String)this.submitAcl), "*");
            conf.set("mapred.queue.names", "default,q2");
            conf.set(QueueManager.toFullPropertyName((String)"q2", (String)this.submitAcl), userName);
            this.verifyJobSubmission(conf, true, userName + "," + groups[groups.length - 1], "q2");
        }
        finally {
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllEnabledACLForJobKill() throws IOException, InterruptedException {
        try {
            UserGroupInformation ugi = this.createNecessaryUsers();
            final UserGroupInformation otherUGI = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"group1"});
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    JobConf conf = TestQueueManagerForJobKillAndNonDefaultQueue.this.setupConf(QueueManager.toFullPropertyName((String)"default", (String)TestQueueManagerForJobKillAndNonDefaultQueue.this.adminAcl), "*");
                    TestQueueManagerForJobKillAndNonDefaultQueue.this.verifyJobKill(otherUGI, conf, true);
                    return null;
                }
            });
        }
        finally {
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllDisabledACLForJobKill() throws IOException, InterruptedException {
        try {
            final UserGroupInformation ugi = this.createNecessaryUsers();
            final UserGroupInformation otherUGI1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"group1"});
            final UserGroupInformation otherUGI2 = UserGroupInformation.createUserForTesting((String)"user2", (String[])new String[]{"group2"});
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    JobConf conf = TestQueueManagerForJobKillAndNonDefaultQueue.this.setupConf(QueueManager.toFullPropertyName((String)"default", (String)TestQueueManagerForJobKillAndNonDefaultQueue.this.adminAcl), " ");
                    TestQueueManagerForJobKillAndNonDefaultQueue.this.verifyJobKill(otherUGI1, conf, false);
                    TestQueueManagerForJobKillAndNonDefaultQueue.this.verifyJobKill(otherUGI2, conf, false);
                    conf.set("mapreduce.cluster.administrators", "user1 group2");
                    TestQueueManagerForJobKillAndNonDefaultQueue.this.tearDownCluster();
                    TestQueueManagerForJobKillAndNonDefaultQueue.this.verifyJobKill(otherUGI1, conf, true);
                    TestQueueManagerForJobKillAndNonDefaultQueue.this.verifyJobKill(otherUGI2, conf, true);
                    TestQueueManagerForJobKillAndNonDefaultQueue.this.verifyJobKill(ugi, conf, true);
                    return null;
                }
            });
        }
        finally {
            this.tearDownCluster();
        }
    }
}

