/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.TimerTask;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.NodeHealthCheckerService;
import org.apache.hadoop.mapred.TaskTrackerStatus;

public class TestNodeHealthService
extends TestCase {
    private static volatile Log LOG = LogFactory.getLog(TestNodeHealthService.class);
    private static final String nodeHealthConfigPath = System.getProperty("test.build.extraconf", "build/test/extraconf");
    static final File nodeHealthConfigFile = new File(nodeHealthConfigPath, "mapred-site.xml");
    private String testRootDir = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    private File nodeHealthscriptFile = new File(this.testRootDir, "failingscript.sh");

    protected void tearDown() throws Exception {
        if (nodeHealthConfigFile.exists()) {
            nodeHealthConfigFile.delete();
        }
        if (this.nodeHealthscriptFile.exists()) {
            this.nodeHealthscriptFile.delete();
        }
        super.tearDown();
    }

    private Configuration getConfForNodeHealthScript() {
        Configuration conf = new Configuration();
        conf.set("mapred.healthChecker.script.path", this.nodeHealthscriptFile.getAbsolutePath());
        conf.setLong("mapred.healthChecker.interval", 500L);
        conf.setLong("mapred.healthChecker.script.timeout", 1000L);
        return conf;
    }

    private void writeNodeHealthScriptFile(String scriptStr, boolean setExecutable) throws IOException {
        PrintWriter pw = new PrintWriter(new FileOutputStream(this.nodeHealthscriptFile));
        pw.println(scriptStr);
        pw.flush();
        pw.close();
        this.nodeHealthscriptFile.setExecutable(setExecutable);
    }

    public void testNodeHealthScriptShouldRun() throws IOException {
        TestNodeHealthService.assertFalse((String)"Health checker should not have started", (boolean)NodeHealthCheckerService.shouldRun((Configuration)new Configuration()));
        Configuration conf = this.getConfForNodeHealthScript();
        TestNodeHealthService.assertFalse((String)"Node health script should start", (boolean)NodeHealthCheckerService.shouldRun((Configuration)conf));
        conf.writeXml((OutputStream)new FileOutputStream(nodeHealthConfigFile));
        this.writeNodeHealthScriptFile("", false);
        TestNodeHealthService.assertFalse((String)"Node health script should start", (boolean)NodeHealthCheckerService.shouldRun((Configuration)conf));
        this.writeNodeHealthScriptFile("", true);
        TestNodeHealthService.assertTrue((String)"Node health script should start", (boolean)NodeHealthCheckerService.shouldRun((Configuration)conf));
    }

    public void testNodeHealthScript() throws Exception {
        TaskTrackerStatus.TaskTrackerHealthStatus healthStatus = new TaskTrackerStatus.TaskTrackerHealthStatus();
        String errorScript = "echo ERROR\n echo \"Tracker not healthy\"";
        String normalScript = "echo \"I am all fine\"";
        String timeOutScript = "sleep 4\n echo\"I am fine\"";
        Configuration conf = this.getConfForNodeHealthScript();
        conf.writeXml((OutputStream)new FileOutputStream(nodeHealthConfigFile));
        NodeHealthCheckerService nodeHealthChecker = new NodeHealthCheckerService(conf);
        TimerTask timer = nodeHealthChecker.getTimer();
        this.writeNodeHealthScriptFile(normalScript, true);
        timer.run();
        nodeHealthChecker.setHealthStatus(healthStatus);
        LOG.info((Object)"Checking initial healthy condition");
        TestNodeHealthService.assertTrue((String)"Node health status reported unhealthy", (boolean)healthStatus.isNodeHealthy());
        TestNodeHealthService.assertTrue((String)"Node health status reported unhealthy", (boolean)healthStatus.getHealthReport().isEmpty());
        this.writeNodeHealthScriptFile(errorScript, true);
        timer.run();
        nodeHealthChecker.setHealthStatus(healthStatus);
        LOG.info((Object)"Checking Healthy--->Unhealthy");
        TestNodeHealthService.assertFalse((String)"Node health status reported healthy", (boolean)healthStatus.isNodeHealthy());
        TestNodeHealthService.assertFalse((String)"Node health status reported healthy", (boolean)healthStatus.getHealthReport().isEmpty());
        this.writeNodeHealthScriptFile(normalScript, true);
        timer.run();
        nodeHealthChecker.setHealthStatus(healthStatus);
        LOG.info((Object)"Checking UnHealthy--->healthy");
        TestNodeHealthService.assertTrue((String)"Node health status reported unhealthy", (boolean)healthStatus.isNodeHealthy());
        TestNodeHealthService.assertTrue((String)"Node health status reported unhealthy", (boolean)healthStatus.getHealthReport().isEmpty());
        this.writeNodeHealthScriptFile(timeOutScript, true);
        timer.run();
        nodeHealthChecker.setHealthStatus(healthStatus);
        LOG.info((Object)"Checking Healthy--->timeout");
        TestNodeHealthService.assertFalse((String)"Node health status reported healthy even after timeout", (boolean)healthStatus.isNodeHealthy());
        TestNodeHealthService.assertEquals((String)"Node time out message not propogated", (String)healthStatus.getHealthReport(), (String)"Node health script timed out");
    }
}

