/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.NullOutputFormat;

public class TestMapCollection
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestMapCollection.class.getName());

    private static void runTest(String name, int keylen, int vallen, int records, int ioSortMB, float recPer, float spillPer, boolean pedantic) throws Exception {
        JobConf conf = new JobConf(new Configuration(), SpillMapper.class);
        conf.setInt("io.sort.mb", ioSortMB);
        conf.set("io.sort.record.percent", Float.toString(recPer));
        conf.set("io.sort.spill.percent", Float.toString(spillPer));
        conf.setInt("test.keywritable.length", keylen);
        conf.setInt("test.valwritable.length", vallen);
        conf.setInt("test.spillmap.records", records);
        conf.setBoolean("test.pedantic.verification", pedantic);
        conf.setNumMapTasks(1);
        conf.setNumReduceTasks(1);
        conf.setInputFormat(FakeIF.class);
        conf.setOutputFormat(NullOutputFormat.class);
        conf.setMapperClass(SpillMapper.class);
        conf.setReducerClass(SpillReducer.class);
        conf.setMapOutputKeyClass(KeyWritable.class);
        conf.setMapOutputValueClass(ValWritable.class);
        LOG.info((Object)("Running " + name));
        JobClient.runJob((JobConf)conf);
    }

    private static void runTest(String name, int keylen, int vallen, int records, boolean pedantic) throws Exception {
        TestMapCollection.runTest(name, keylen, vallen, records, 1, 0.05f, 0.8f, pedantic);
    }

    public void testLastFill() throws Exception {
        TestMapCollection.runTest("vallastbyte", 128, 896, 1344, 1, 0.125f, 0.5f, true);
        TestMapCollection.runTest("keylastbyte", 512, 1024, 896, 1, 0.125f, 0.5f, true);
    }

    public void testLargeRecords() throws Exception {
        TestMapCollection.runTest("largerec", 100, 0x100000, 5, false);
        TestMapCollection.runTest("largekeyzeroval", 0x100000, 0, 5, false);
    }

    public void testSpillPer() throws Exception {
        TestMapCollection.runTest("fullspill2B", 1, 1, 10000, 1, 0.05f, 1.0f, true);
        TestMapCollection.runTest("fullspill200B", 100, 100, 10000, 1, 0.05f, 1.0f, true);
        TestMapCollection.runTest("fullspillbuf", 10240, 20480, 256, 1, 0.3f, 1.0f, true);
        TestMapCollection.runTest("lt50perspill", 100, 100, 10000, 1, 0.05f, 0.3f, true);
    }

    public void testZeroLength() throws Exception {
        TestMapCollection.runTest("zeroval", 1, 0, 10000, true);
        TestMapCollection.runTest("zerokey", 0, 1, 10000, true);
        TestMapCollection.runTest("zerokeyval", 0, 0, 10000, false);
        TestMapCollection.runTest("zerokeyvalfull", 0, 0, 10000, 1, 0.05f, 1.0f, false);
    }

    public static class FakeIF
    implements InputFormat<NullWritable, NullWritable> {
        public InputSplit[] getSplits(JobConf conf, int numSplits) {
            InputSplit[] splits = new InputSplit[numSplits];
            for (int i = 0; i < splits.length; ++i) {
                splits[i] = new FakeSplit();
            }
            return splits;
        }

        public RecordReader<NullWritable, NullWritable> getRecordReader(InputSplit ignored, JobConf conf, Reporter reporter) {
            return new RecordReader<NullWritable, NullWritable>(){
                private boolean done = false;

                public boolean next(NullWritable key, NullWritable value) throws IOException {
                    if (this.done) {
                        return false;
                    }
                    this.done = true;
                    return true;
                }

                public NullWritable createKey() {
                    return NullWritable.get();
                }

                public NullWritable createValue() {
                    return NullWritable.get();
                }

                public long getPos() throws IOException {
                    return 0L;
                }

                public void close() throws IOException {
                }

                public float getProgress() throws IOException {
                    return 0.0f;
                }
            };
        }
    }

    public static class FakeSplit
    implements InputSplit {
        public void write(DataOutput out) throws IOException {
        }

        public void readFields(DataInput in) throws IOException {
        }

        public long getLength() {
            return 0L;
        }

        public String[] getLocations() {
            return new String[0];
        }
    }

    public static class SpillReducer
    implements Reducer<KeyWritable, ValWritable, NullWritable, NullWritable> {
        private int numrecs = 100;

        public void configure(JobConf job) {
            this.numrecs = job.getInt("test.spillmap.records", 100);
        }

        public void reduce(KeyWritable k, Iterator<ValWritable> values, OutputCollector<NullWritable, NullWritable> out, Reporter reporter) {
            int i = 0;
            while (values.hasNext()) {
                values.next();
                ++i;
            }
            Assert.assertEquals((String)("Unexpected record count (" + i + "/" + this.numrecs + ")"), (int)this.numrecs, (int)i);
        }

        public void close() {
        }
    }

    public static class SpillMapper
    implements Mapper<NullWritable, NullWritable, KeyWritable, ValWritable> {
        private int keylen = 1;
        private int vallen = 1;
        private int numrecs = 100;

        public void configure(JobConf job) {
            this.keylen = job.getInt("test.keywritable.length", 1);
            this.vallen = job.getInt("test.valwritable.length", 1);
            this.numrecs = job.getInt("test.spillmap.records", 100);
        }

        public void map(NullWritable key, NullWritable value, OutputCollector<KeyWritable, ValWritable> out, Reporter reporter) throws IOException {
            KeyWritable k = new KeyWritable(this.keylen);
            ValWritable v = new ValWritable(this.vallen);
            for (int i = 0; i < this.numrecs; ++i) {
                if (i % 1000 == 0) {
                    reporter.progress();
                }
                out.collect((Object)k, (Object)v);
            }
        }

        public void close() {
        }
    }

    public static class ValWritable
    extends KeyWritable {
        private final byte c = (byte)86;

        public ValWritable() {
        }

        public ValWritable(int len) {
            this();
            this.expectedlen = len;
        }

        @Override
        public void configure(JobConf conf) {
            this.expectedlen = conf.getInt("test.valwritable.length", 1);
        }
    }

    public static class KeyWritable
    implements WritableComparable<KeyWritable>,
    JobConfigurable {
        private final byte c = (byte)75;
        private static boolean pedantic = false;
        protected int expectedlen;

        public void configure(JobConf conf) {
            this.expectedlen = conf.getInt("test.keywritable.length", 1);
            pedantic = conf.getBoolean("test.pedantic.verification", false);
        }

        public KeyWritable() {
        }

        public KeyWritable(int len) {
            this();
            this.expectedlen = len;
        }

        public int getLength() {
            return this.expectedlen;
        }

        public int compareTo(KeyWritable o) {
            if (o == this) {
                return 0;
            }
            return this.expectedlen - o.getLength();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyWritable)) {
                return false;
            }
            return 0 == this.compareTo((KeyWritable)o);
        }

        public int hashCode() {
            return 37 * this.expectedlen;
        }

        public void readFields(DataInput in) throws IOException {
            if (this.expectedlen != 0) {
                int bytesread;
                if (pedantic) {
                    for (int i = 0; i < this.expectedlen; ++i) {
                        Assert.assertEquals((String)("Invalid byte at " + i), (byte)75, (byte)in.readByte());
                    }
                    bytesread = this.expectedlen;
                } else {
                    bytesread = in.skipBytes(this.expectedlen);
                }
                Assert.assertEquals((String)"Too few bytes in record", (int)this.expectedlen, (int)bytesread);
            }
        }

        public void write(DataOutput out) throws IOException {
            if (this.expectedlen != 0) {
                if (this.expectedlen > 1024) {
                    byte[] b = new byte[this.expectedlen];
                    Arrays.fill(b, (byte)75);
                    out.write(b);
                } else {
                    for (int i = 0; i < this.expectedlen; ++i) {
                        out.write(75);
                    }
                }
            }
        }

        static {
            WritableComparator.define(KeyWritable.class, (WritableComparator)new Comparator());
        }

        public static class Comparator
        extends WritableComparator {
            public Comparator() {
                super(KeyWritable.class);
            }

            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
                if (pedantic) {
                    int i;
                    for (i = s1; i < l1; ++i) {
                        Assert.assertEquals((String)("Invalid key at " + s1), (byte)b1[i], (byte)75);
                    }
                    for (i = s2; i < l2; ++i) {
                        Assert.assertEquals((String)("Invalid key at " + s2), (byte)b2[i], (byte)75);
                    }
                }
                return l1 - l2;
            }
        }
    }
}

