/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.jmx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.http.HttpServer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestJMXJsonServlet {
    private static final Log LOG = LogFactory.getLog(TestJMXJsonServlet.class);
    private static HttpServer server;
    private static URL baseUrl;

    private String readOutput(URL url) throws IOException {
        StringBuilder out = new StringBuilder();
        InputStream in = url.openConnection().getInputStream();
        byte[] buffer = new byte[65536];
        int len = in.read(buffer);
        while (len > 0) {
            out.append(new String(buffer, 0, len));
            len = in.read(buffer);
        }
        return out.toString();
    }

    @BeforeClass
    public static void setup() throws Exception {
        new File(System.getProperty("build.webapps", "build/webapps") + "/test").mkdirs();
        server = new HttpServer("test", "0.0.0.0", 0, true);
        server.start();
        int port = server.getPort();
        baseUrl = new URL("http://localhost:" + port + "/");
    }

    @AfterClass
    public static void cleanup() throws Exception {
        server.stop();
    }

    public static void assertReFind(String re, String value) {
        Pattern p = Pattern.compile(re);
        Matcher m = p.matcher(value);
        Assert.assertTrue((String)("'" + p + "' does not match " + value), (boolean)m.find());
    }

    @Test
    public void testQury() throws Exception {
        String result = this.readOutput(new URL(baseUrl, "/jmx?qry=java.lang:type=Runtime"));
        LOG.info((Object)("/jmx?qry=java.lang:type=Runtime RESULT: " + result));
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Runtime\"", result);
        TestJMXJsonServlet.assertReFind("\"modelerType\"", result);
        result = this.readOutput(new URL(baseUrl, "/jmx?qry=java.lang:type=Memory"));
        LOG.info((Object)("/jmx?qry=java.lang:type=Memory RESULT: " + result));
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        TestJMXJsonServlet.assertReFind("\"modelerType\"", result);
        result = this.readOutput(new URL(baseUrl, "/jmx"));
        LOG.info((Object)("/jmx RESULT: " + result));
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
    }
}

