/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BloomMapFile;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class TestBloomMapFile
extends TestCase {
    private static Configuration conf = new Configuration();

    public void testMembershipTest() throws Exception {
        Path dirName = new Path(System.getProperty("test.build.data", ".") + this.getName() + ".bloommapfile");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path qualifiedDirName = fs.makeQualified(dirName);
        conf.setInt("io.mapfile.bloom.size", 2048);
        BloomMapFile.Writer writer = new BloomMapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), IntWritable.class, Text.class);
        IntWritable key = new IntWritable();
        Text value = new Text();
        for (int i = 0; i < 2000; i += 2) {
            key.set(i);
            value.set("00" + i);
            writer.append((WritableComparable)key, (Writable)value);
        }
        writer.close();
        BloomMapFile.Reader reader = new BloomMapFile.Reader((FileSystem)fs, qualifiedDirName.toString(), conf);
        int falsePos = 0;
        int falseNeg = 0;
        for (int i = 0; i < 2000; ++i) {
            key.set(i);
            boolean exists = reader.probablyHasKey((WritableComparable)key);
            if (i % 2 == 0) {
                if (exists) continue;
                ++falseNeg;
                continue;
            }
            if (!exists) continue;
            ++falsePos;
        }
        reader.close();
        fs.delete(qualifiedDirName, true);
        System.out.println("False negatives: " + falseNeg);
        TestBloomMapFile.assertEquals((int)0, (int)falseNeg);
        System.out.println("False positives: " + falsePos);
        TestBloomMapFile.assertTrue((falsePos < 2 ? 1 : 0) != 0);
    }

    private void checkMembershipVaryingSizedKeys(String name, List<Text> keys) throws Exception {
        Path dirName = new Path(System.getProperty("test.build.data", ".") + name + ".bloommapfile");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path qualifiedDirName = fs.makeQualified(dirName);
        BloomMapFile.Writer writer = new BloomMapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), Text.class, NullWritable.class);
        for (Text key : keys) {
            writer.append((WritableComparable)key, (Writable)NullWritable.get());
        }
        writer.close();
        BloomMapFile.Reader reader = new BloomMapFile.Reader((FileSystem)fs, qualifiedDirName.toString(), conf);
        Collections.reverse(keys);
        for (Text key : keys) {
            TestBloomMapFile.assertTrue((String)("False negative for existing key " + key), (boolean)reader.probablyHasKey((WritableComparable)key));
        }
        reader.close();
        fs.delete(qualifiedDirName, true);
    }

    public void testMembershipVaryingSizedKeysTest1() throws Exception {
        ArrayList<Text> list = new ArrayList<Text>();
        list.add(new Text("A"));
        list.add(new Text("BB"));
        this.checkMembershipVaryingSizedKeys(this.getName(), list);
    }

    public void testMembershipVaryingSizedKeysTest2() throws Exception {
        ArrayList<Text> list = new ArrayList<Text>();
        list.add(new Text("AA"));
        list.add(new Text("B"));
        this.checkMembershipVaryingSizedKeys(this.getName(), list);
    }
}

