/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSClusterWithNodeGroup;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.balancer.Balancer;
import org.apache.hadoop.net.NetworkTopology;
import org.junit.Assert;
import org.junit.Test;

public class TestBalancerWithNodeGroup {
    private static final long CAPACITY = 500L;
    private static final String RACK0 = "/rack0";
    private static final String RACK1 = "/rack1";
    private static final String NODEGROUP0 = "/nodegroup0";
    private static final String NODEGROUP1 = "/nodegroup1";
    private static final String NODEGROUP2 = "/nodegroup2";
    private static final String fileName = "/tmp.txt";
    private static final Path filePath = new Path("/tmp.txt");
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestBalancerWithNodeGroup");
    MiniDFSClusterWithNodeGroup cluster;
    ClientProtocol client;
    private Balancer balancer;
    static final long TIMEOUT = 20000L;
    static final double CAPACITY_ALLOWED_VARIANCE = 0.005;
    static final double BALANCE_ALLOWED_VARIANCE = 0.11;
    static final int DEFAULT_BLOCK_SIZE = 5;
    private static final Random r = new Random();

    private void initConf(Configuration conf) {
        conf.setLong("dfs.block.size", 5L);
        conf.setInt("io.bytes.per.checksum", 5);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        conf.setLong("dfs.balancer.movedWinWidth", 2000L);
        conf.set("net.topology.impl", "org.apache.hadoop.net.NetworkTopologyWithNodeGroup");
        conf.set("dfs.block.replicator.classname", "org.apache.hadoop.hdfs.server.namenode.BlockPlacementPolicyWithNodeGroup");
    }

    private void createFile(long fileLen, short replicationFactor) throws IOException {
        FileSystem fs = this.cluster.getFileSystem();
        DFSTestUtil.createFile(fs, filePath, fileLen, replicationFactor, r.nextLong());
        DFSTestUtil.waitReplication(fs, filePath, replicationFactor);
    }

    private Configuration createConf() {
        Configuration conf = new Configuration();
        this.initConf(conf);
        return conf;
    }

    private void waitForHeartBeat(long expectedUsedSpace, long expectedTotalSpace) throws IOException, TimeoutException {
        long timeout = 20000L;
        long failtime = timeout <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeout;
        while (true) {
            long[] status = this.client.getStats();
            double totalSpaceVariance = Math.abs((double)status[0] - (double)expectedTotalSpace) / (double)expectedTotalSpace;
            double usedSpaceVariance = Math.abs((double)status[1] - (double)expectedUsedSpace) / (double)expectedUsedSpace;
            if (totalSpaceVariance < 0.005 && usedSpaceVariance < 0.005) break;
            if (System.currentTimeMillis() > failtime) {
                throw new TimeoutException("Cluster failed to reached expected values of totalSpace (current: " + status[0] + ", expected: " + expectedTotalSpace + "), or usedSpace (current: " + status[1] + ", expected: " + expectedUsedSpace + "), in more than " + timeout + " msec.");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignored) {}
        }
    }

    private void waitForBalancer(long totalUsedSpace, long totalCapacity) throws IOException, TimeoutException {
        boolean balanced;
        long timeout = 20000L;
        long failtime = timeout <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeout;
        double avgUtilization = (double)totalUsedSpace / (double)totalCapacity;
        block2: do {
            DatanodeInfo[] datanodeReport = this.client.getDatanodeReport(FSConstants.DatanodeReportType.ALL);
            Assert.assertEquals((long)datanodeReport.length, (long)this.cluster.getDataNodes().size());
            balanced = true;
            for (DatanodeInfo datanode : datanodeReport) {
                double nodeUtilization = (double)datanode.getDfsUsed() / (double)datanode.getCapacity();
                if (!(Math.abs(avgUtilization - nodeUtilization) > 0.11)) continue;
                balanced = false;
                if (System.currentTimeMillis() > failtime) {
                    throw new TimeoutException("Rebalancing expected avg utilization to become " + avgUtilization + ", but on datanode " + datanode + " it remains at " + nodeUtilization + " after more than " + 20000L + " msec.");
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignored) {}
                continue block2;
            }
        } while (!balanced);
    }

    private void runBalancer(Configuration conf, long totalUsedSpace, long totalCapacity) throws Exception {
        this.waitForHeartBeat(totalUsedSpace, totalCapacity);
        this.balancer = new Balancer(conf);
        int r = this.balancer.run(new String[0]);
        Assert.assertEquals((long)1L, (long)r);
        this.waitForHeartBeat(totalUsedSpace, totalCapacity);
        LOG.info((Object)"Rebalancing with default factor.");
        this.waitForBalancer(totalUsedSpace, totalCapacity);
    }

    private void runBalancerCanFinish(Configuration conf, long totalUsedSpace, long totalCapacity) throws Exception {
        this.waitForHeartBeat(totalUsedSpace, totalCapacity);
        this.balancer = new Balancer(conf);
        int r = this.balancer.run(new String[0]);
        Assert.assertTrue((r == 1 || r == -3 ? 1 : 0) != 0);
        this.waitForHeartBeat(totalUsedSpace, totalCapacity);
        LOG.info((Object)"Rebalancing ends successful.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testBalancerEndInNoMoveProgress() throws Exception {
        Configuration conf = this.createConf();
        long[] capacities = new long[]{500L, 500L, 500L, 500L};
        String[] racks = new String[]{RACK0, RACK0, RACK1, RACK1};
        String[] nodeGroups = new String[]{NODEGROUP0, NODEGROUP0, NODEGROUP1, NODEGROUP2};
        int numOfDatanodes = capacities.length;
        Assert.assertEquals((long)numOfDatanodes, (long)racks.length);
        Assert.assertEquals((long)numOfDatanodes, (long)nodeGroups.length);
        MiniDFSClusterWithNodeGroup.setNodeGroups(nodeGroups);
        this.cluster = new MiniDFSClusterWithNodeGroup(0, conf, capacities.length, true, true, null, racks, capacities);
        try {
            this.cluster.waitActive();
            this.client = DFSClient.createNamenode((Configuration)conf);
            long totalCapacity = 0L;
            for (long capacity : capacities) {
                totalCapacity += capacity;
            }
            long totalUsedSpace = totalCapacity * 6L / 10L;
            this.createFile(totalUsedSpace / 3L, (short)3);
            this.runBalancerCanFinish(conf, totalUsedSpace, totalCapacity);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testBalancerWithRackLocality() throws Exception {
        Configuration conf = this.createConf();
        long[] capacities = new long[]{500L, 500L};
        String[] racks = new String[]{RACK0, RACK1};
        String[] nodeGroups = new String[]{NODEGROUP0, NODEGROUP1};
        int numOfDatanodes = capacities.length;
        Assert.assertEquals((long)numOfDatanodes, (long)racks.length);
        MiniDFSClusterWithNodeGroup.setNodeGroups(nodeGroups);
        MiniDFSClusterWithNodeGroup.setNodeGroups(nodeGroups);
        this.cluster = new MiniDFSClusterWithNodeGroup(0, conf, capacities.length, true, true, null, racks, capacities);
        try {
            this.cluster.waitActive();
            this.client = DFSClient.createNamenode((Configuration)conf);
            long totalCapacity = 0L;
            for (long capacity : capacities) {
                totalCapacity += capacity;
            }
            long totalUsedSpace = totalCapacity * 3L / 10L;
            this.createFile(totalUsedSpace / (long)numOfDatanodes, (short)numOfDatanodes);
            long newCapacity = 500L;
            String newRack = RACK1;
            String newNodeGroup = NODEGROUP2;
            this.cluster.startDataNodes(conf, 1, true, null, new String[]{newRack}, new String[]{newNodeGroup}, new long[]{newCapacity});
            this.runBalancerCanFinish(conf, totalUsedSpace, totalCapacity += newCapacity);
            DatanodeInfo[] datanodeReport = this.client.getDatanodeReport(FSConstants.DatanodeReportType.ALL);
            HashMap<String, Integer> rackToUsedCapacity = new HashMap<String, Integer>();
            for (DatanodeInfo datanode : datanodeReport) {
                String rack = NetworkTopology.getFirstHalf((String)datanode.getNetworkLocation());
                int usedCapacity = (int)datanode.getDfsUsed();
                if (rackToUsedCapacity.get(rack) != null) {
                    rackToUsedCapacity.put(rack, usedCapacity + (Integer)rackToUsedCapacity.get(rack));
                    continue;
                }
                rackToUsedCapacity.put(rack, usedCapacity);
            }
            Assert.assertEquals((long)rackToUsedCapacity.size(), (long)2L);
            Assert.assertEquals(rackToUsedCapacity.get(RACK0), rackToUsedCapacity.get(RACK1));
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testBalancerWithNodeGroup() throws Exception {
        Configuration conf = this.createConf();
        long[] capacities = new long[]{500L, 500L};
        String[] racks = new String[]{RACK0, RACK1};
        String[] nodeGroups = new String[]{NODEGROUP0, NODEGROUP1};
        int numOfDatanodes = capacities.length;
        Assert.assertEquals((long)numOfDatanodes, (long)racks.length);
        MiniDFSClusterWithNodeGroup.setNodeGroups(nodeGroups);
        this.cluster = new MiniDFSClusterWithNodeGroup(0, conf, capacities.length, true, true, null, racks, capacities);
        try {
            this.cluster.waitActive();
            this.client = DFSClient.createNamenode((Configuration)conf);
            long totalCapacity = 0L;
            for (long capacity : capacities) {
                totalCapacity += capacity;
            }
            long totalUsedSpace = totalCapacity * 3L / 10L;
            this.createFile(totalUsedSpace / (long)numOfDatanodes, (short)numOfDatanodes);
            long newCapacity = 500L;
            String newRack = RACK1;
            String newNodeGroup = NODEGROUP2;
            this.cluster.startDataNodes(conf, 1, true, null, new String[]{newRack}, new String[]{newNodeGroup}, new long[]{newCapacity});
            this.runBalancer(conf, totalUsedSpace, totalCapacity += newCapacity);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    static {
        Balancer.setBlockMoveWaitTime((long)1000L);
    }
}

