/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3native.NativeFileSystemStore;
import org.apache.hadoop.fs.s3native.NativeS3FileSystem;

public abstract class NativeS3FileSystemContractBaseTest
extends FileSystemContractBaseTest {
    private NativeFileSystemStore store;

    abstract NativeFileSystemStore getNativeFileSystemStore() throws IOException;

    protected void setUp() throws Exception {
        Configuration conf = new Configuration();
        this.store = this.getNativeFileSystemStore();
        this.fs = new NativeS3FileSystem(this.store);
        this.fs.initialize(URI.create(conf.get("test.fs.s3n.name")), conf);
    }

    @Override
    protected void tearDown() throws Exception {
        this.store.purge("test");
        super.tearDown();
    }

    public void testListStatusForRoot() throws Exception {
        Path testDir = this.path("/test");
        NativeS3FileSystemContractBaseTest.assertTrue((boolean)this.fs.mkdirs(testDir));
        FileStatus[] paths = this.fs.listStatus(this.path("/"));
        NativeS3FileSystemContractBaseTest.assertEquals((int)1, (int)paths.length);
        NativeS3FileSystemContractBaseTest.assertEquals((Object)this.path("/test"), (Object)paths[0].getPath());
    }

    private void createTestFiles(String base) throws IOException {
        this.store.storeEmptyFile(base + "/file1");
        this.store.storeEmptyFile(base + "/dir/file2");
        this.store.storeEmptyFile(base + "/dir/file3");
    }

    public void testDirWithDifferentMarkersWorks() throws Exception {
        for (int i = 0; i < 3; ++i) {
            String base = "test/hadoop" + i;
            Path path = this.path("/" + base);
            this.createTestFiles(base);
            if (i != 0) {
                if (i == 1) {
                    this.store.storeEmptyFile(base + "_$folder$");
                    this.store.storeEmptyFile(base + "/dir_$folder$");
                } else if (i == 2) {
                    this.store.storeEmptyFile(base + "/");
                    this.store.storeEmptyFile(base + "/dir/");
                } else if (i == 3) {
                    this.store.storeEmptyFile(base + "_$folder$");
                    this.store.storeEmptyFile(base + "/dir_$folder$");
                    this.store.storeEmptyFile(base + "/");
                    this.store.storeEmptyFile(base + "/dir/");
                }
            }
            NativeS3FileSystemContractBaseTest.assertTrue((boolean)this.fs.getFileStatus(path).isDir());
            NativeS3FileSystemContractBaseTest.assertEquals((int)2, (int)this.fs.listStatus(path).length);
        }
    }

    public void testDeleteWithNoMarker() throws Exception {
        String base = "test/hadoop";
        Path path = this.path("/" + base);
        this.createTestFiles(base);
        this.fs.delete(path, true);
        path = this.path("/test");
    }

    public void testRenameWithNoMarker() throws Exception {
        String base = "test/hadoop";
        Path dest = this.path("/test/hadoop2");
        this.createTestFiles(base);
        this.fs.rename(this.path("/" + base), dest);
        Path path = this.path("/test");
        NativeS3FileSystemContractBaseTest.assertTrue((boolean)this.fs.getFileStatus(path).isDir());
        NativeS3FileSystemContractBaseTest.assertEquals((int)1, (int)this.fs.listStatus(path).length);
        NativeS3FileSystemContractBaseTest.assertTrue((boolean)this.fs.getFileStatus(dest).isDir());
        NativeS3FileSystemContractBaseTest.assertEquals((int)2, (int)this.fs.listStatus(dest).length);
    }

    public void testEmptyFile() throws Exception {
        this.store.storeEmptyFile("test/hadoop/file1");
        this.fs.open(this.path("/test/hadoop/file1")).close();
    }
}

