/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.cli;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.cli.util.CLITestData;
import org.apache.hadoop.cli.util.CommandExecutor;
import org.apache.hadoop.cli.util.ComparatorBase;
import org.apache.hadoop.cli.util.ComparatorData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.security.authorize.HadoopPolicyProvider;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestCLI
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestCLI.class.getName());
    public static final String TESTMODE_TEST = "test";
    public static final String TESTMODE_NOCOMPARE = "nocompare";
    public static final String TEST_CACHE_DATA_DIR = System.getProperty("test.cache.data", "build/test/cache");
    public static String testMode = "test";
    static ArrayList<CLITestData> testsFromConfigFile = null;
    static ArrayList<ComparatorData> testComparators = null;
    static String testConfigFile = "testConf.xml";
    String thisTestCaseName = null;
    static ComparatorData comparatorData = null;
    private static Configuration conf = null;
    private static MiniDFSCluster dfsCluster = null;
    private static DistributedFileSystem dfs = null;
    private static MiniMRCluster mrCluster = null;
    private static String namenode = null;
    private static String jobtracker = null;
    private static String clitestDataDir = null;
    private static String username = null;

    private void readTestConfigFile() {
        if (testsFromConfigFile == null) {
            boolean success = false;
            testConfigFile = TEST_CACHE_DATA_DIR + File.separator + testConfigFile;
            try {
                SAXParser p = SAXParserFactory.newInstance().newSAXParser();
                p.parse(testConfigFile, (DefaultHandler)new TestConfigFileParser());
                success = true;
            }
            catch (Exception e) {
                LOG.info((Object)("File: " + testConfigFile + " not found"));
                success = false;
            }
            TestCLI.assertTrue((String)"Error reading test config file", (boolean)success);
        }
    }

    public void setUp() throws Exception {
        this.readTestConfigFile();
        boolean success = false;
        conf = new Configuration();
        conf.setClass("hadoop.security.authorization.policyprovider", HadoopPolicyProvider.class, PolicyProvider.class);
        conf.setBoolean("hadoop.security.authorization", true);
        dfsCluster = new MiniDFSCluster(conf, 1, true, null);
        namenode = conf.get("fs.default.name", "file:///");
        clitestDataDir = new File(TEST_CACHE_DATA_DIR).toURI().toString().replace(' ', '+');
        username = System.getProperty("user.name");
        FileSystem fs = dfsCluster.getFileSystem();
        TestCLI.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        dfs = (DistributedFileSystem)fs;
        JobConf mrConf = new JobConf(conf);
        mrCluster = new MiniMRCluster(1, dfsCluster.getFileSystem().getUri().toString(), 1, null, null, mrConf);
        jobtracker = mrCluster.createJobConf().get("mapred.job.tracker", "local");
        success = true;
        TestCLI.assertTrue((String)"Error setting up Mini DFS & MR clusters", (boolean)success);
    }

    public void tearDown() throws Exception {
        boolean success = false;
        mrCluster.shutdown();
        dfs.close();
        dfsCluster.shutdown();
        success = true;
        Thread.sleep(2000L);
        TestCLI.assertTrue((String)"Error tearing down Mini DFS & MR clusters", (boolean)success);
        this.displayResults();
    }

    private String expandCommand(String cmd) {
        String expCmd = cmd;
        expCmd = expCmd.replaceAll("NAMENODE", namenode);
        expCmd = expCmd.replaceAll("JOBTRACKER", jobtracker);
        expCmd = expCmd.replaceAll("CLITEST_DATA", clitestDataDir);
        expCmd = expCmd.replaceAll("USERNAME", username);
        return expCmd;
    }

    private void displayResults() {
        int i;
        LOG.info((Object)"Detailed results:");
        LOG.info((Object)"----------------------------------\n");
        for (int i2 = 0; i2 < testsFromConfigFile.size(); ++i2) {
            CLITestData td = testsFromConfigFile.get(i2);
            boolean testResult = td.getTestResult();
            if (testResult) continue;
            LOG.info((Object)"-------------------------------------------");
            LOG.info((Object)("                    Test ID: [" + (i2 + 1) + "]"));
            LOG.info((Object)("           Test Description: [" + td.getTestDesc() + "]"));
            LOG.info((Object)"");
            ArrayList<CLITestData.TestCmd> testCommands = td.getTestCommands();
            for (CLITestData.TestCmd cmd : testCommands) {
                LOG.info((Object)("              Test Commands: [" + this.expandCommand(cmd.getCmd()) + "]"));
            }
            LOG.info((Object)"");
            ArrayList<CLITestData.TestCmd> cleanupCommands = td.getCleanupCommands();
            for (CLITestData.TestCmd cmd : cleanupCommands) {
                LOG.info((Object)("           Cleanup Commands: [" + this.expandCommand(cmd.getCmd()) + "]"));
            }
            LOG.info((Object)"");
            ArrayList<ComparatorData> compdata = td.getComparatorData();
            for (ComparatorData cd : compdata) {
                boolean resultBoolean = cd.getTestResult();
                LOG.info((Object)("                 Comparator: [" + cd.getComparatorType() + "]"));
                LOG.info((Object)("         Comparision result:   [" + (resultBoolean ? "pass" : "fail") + "]"));
                LOG.info((Object)("            Expected output:   [" + cd.getExpectedOutput() + "]"));
                LOG.info((Object)("              Actual output:   [" + cd.getActualOutput() + "]"));
            }
            LOG.info((Object)"");
        }
        LOG.info((Object)"Summary results:");
        LOG.info((Object)"----------------------------------\n");
        boolean overallResults = true;
        int totalPass = 0;
        int totalFail = 0;
        int totalComparators = 0;
        for (i = 0; i < testsFromConfigFile.size(); ++i) {
            CLITestData td = testsFromConfigFile.get(i);
            totalComparators += testsFromConfigFile.get(i).getComparatorData().size();
            boolean resultBoolean = td.getTestResult();
            if (resultBoolean) {
                ++totalPass;
            } else {
                ++totalFail;
            }
            overallResults &= resultBoolean;
        }
        LOG.info((Object)("               Testing mode: " + testMode));
        LOG.info((Object)"");
        LOG.info((Object)("             Overall result: " + (overallResults ? "+++ PASS +++" : "--- FAIL ---")));
        LOG.info((Object)("               # Tests pass: " + totalPass + " (" + 100 * totalPass / (totalPass + totalFail) + "%)"));
        LOG.info((Object)("               # Tests fail: " + totalFail + " (" + 100 * totalFail / (totalPass + totalFail) + "%)"));
        LOG.info((Object)("         # Validations done: " + totalComparators + " (each test may do multiple validations)"));
        LOG.info((Object)"");
        LOG.info((Object)"Failing tests:");
        LOG.info((Object)"--------------");
        i = 0;
        boolean foundTests = false;
        for (i = 0; i < testsFromConfigFile.size(); ++i) {
            boolean resultBoolean = testsFromConfigFile.get(i).getTestResult();
            if (resultBoolean) continue;
            LOG.info((Object)(i + 1 + ": " + testsFromConfigFile.get(i).getTestDesc()));
            foundTests = true;
        }
        if (!foundTests) {
            LOG.info((Object)"NONE");
        }
        foundTests = false;
        LOG.info((Object)"");
        LOG.info((Object)"Passing tests:");
        LOG.info((Object)"--------------");
        for (i = 0; i < testsFromConfigFile.size(); ++i) {
            boolean resultBoolean = testsFromConfigFile.get(i).getTestResult();
            if (!resultBoolean) continue;
            LOG.info((Object)(i + 1 + ": " + testsFromConfigFile.get(i).getTestDesc()));
            foundTests = true;
        }
        if (!foundTests) {
            LOG.info((Object)"NONE");
        }
        TestCLI.assertTrue((String)"One of the tests failed. See the Detailed results to identify the command that failed", (boolean)overallResults);
    }

    private boolean compareTestOutput(ComparatorData compdata) {
        String comparatorType = compdata.getComparatorType();
        Class<?> comparatorClass = null;
        boolean compareOutput = false;
        if (testMode.equals(TESTMODE_TEST)) {
            try {
                comparatorClass = Class.forName("org.apache.hadoop.cli.util." + comparatorType);
                ComparatorBase comp = (ComparatorBase)comparatorClass.newInstance();
                compareOutput = comp.compare(CommandExecutor.getLastCommandOutput(), compdata.getExpectedOutput());
            }
            catch (Exception e) {
                LOG.info((Object)("Error in instantiating the comparator" + e));
            }
        }
        return compareOutput;
    }

    public void testAll() {
        LOG.info((Object)"TestAll");
        for (int index = 0; index < testsFromConfigFile.size(); ++index) {
            CLITestData testdata = testsFromConfigFile.get(index);
            ArrayList<CLITestData.TestCmd> testCommands = testdata.getTestCommands();
            for (CLITestData.TestCmd cmd : testCommands) {
                try {
                    CommandExecutor.executeCommand(cmd, namenode, jobtracker);
                }
                catch (Exception e) {
                    TestCLI.fail((String)StringUtils.stringifyException((Throwable)e));
                }
            }
            boolean overallTCResult = true;
            ArrayList<ComparatorData> compdata = testdata.getComparatorData();
            for (ComparatorData cd : compdata) {
                String comptype = cd.getComparatorType();
                boolean compareOutput = false;
                if (!comptype.equalsIgnoreCase("none")) {
                    compareOutput = this.compareTestOutput(cd);
                    overallTCResult &= compareOutput;
                }
                cd.setExitCode(CommandExecutor.getLastExitCode());
                cd.setActualOutput(CommandExecutor.getLastCommandOutput());
                cd.setTestResult(compareOutput);
            }
            testdata.setTestResult(overallTCResult);
            ArrayList<CLITestData.TestCmd> cleanupCommands = testdata.getCleanupCommands();
            for (CLITestData.TestCmd cmd : cleanupCommands) {
                try {
                    CommandExecutor.executeCommand(cmd, namenode, jobtracker);
                }
                catch (Exception e) {
                    TestCLI.fail((String)StringUtils.stringifyException((Throwable)e));
                }
            }
        }
    }

    static class TestConfigFileParser
    extends DefaultHandler {
        String charString = null;
        CLITestData td = null;
        ArrayList<CLITestData.TestCmd> testCommands = null;
        ArrayList<CLITestData.TestCmd> cleanupCommands = null;

        TestConfigFileParser() {
        }

        @Override
        public void startDocument() throws SAXException {
            testsFromConfigFile = new ArrayList();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(TestCLI.TESTMODE_TEST)) {
                this.td = new CLITestData();
            } else if (qName.equals("test-commands")) {
                this.testCommands = new ArrayList();
            } else if (qName.equals("cleanup-commands")) {
                this.cleanupCommands = new ArrayList();
            } else if (qName.equals("comparators")) {
                testComparators = new ArrayList();
            } else if (qName.equals("comparator")) {
                comparatorData = new ComparatorData();
            }
            this.charString = "";
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("description")) {
                this.td.setTestDesc(this.charString);
            } else if (qName.equals("test-commands")) {
                this.td.setTestCommands(this.testCommands);
                this.testCommands = null;
            } else if (qName.equals("cleanup-commands")) {
                this.td.setCleanupCommands(this.cleanupCommands);
                this.cleanupCommands = null;
            } else if (qName.equals("command")) {
                if (this.testCommands != null) {
                    this.testCommands.add(new CLITestData.TestCmd(this.charString, CLITestData.TestCmd.CommandType.FS));
                } else if (this.cleanupCommands != null) {
                    this.cleanupCommands.add(new CLITestData.TestCmd(this.charString, CLITestData.TestCmd.CommandType.FS));
                }
            } else if (qName.equals("dfs-admin-command")) {
                if (this.testCommands != null) {
                    this.testCommands.add(new CLITestData.TestCmd(this.charString, CLITestData.TestCmd.CommandType.DFSADMIN));
                } else if (this.cleanupCommands != null) {
                    this.cleanupCommands.add(new CLITestData.TestCmd(this.charString, CLITestData.TestCmd.CommandType.DFSADMIN));
                }
            } else if (qName.equals("mr-admin-command")) {
                if (this.testCommands != null) {
                    this.testCommands.add(new CLITestData.TestCmd(this.charString, CLITestData.TestCmd.CommandType.MRADMIN));
                } else if (this.cleanupCommands != null) {
                    this.cleanupCommands.add(new CLITestData.TestCmd(this.charString, CLITestData.TestCmd.CommandType.MRADMIN));
                }
            } else if (qName.equals("comparators")) {
                this.td.setComparatorData(testComparators);
            } else if (qName.equals("comparator")) {
                testComparators.add(comparatorData);
            } else if (qName.equals("type")) {
                comparatorData.setComparatorType(this.charString);
            } else if (qName.equals("expected-output")) {
                comparatorData.setExpectedOutput(this.charString);
            } else if (qName.equals(TestCLI.TESTMODE_TEST)) {
                testsFromConfigFile.add(this.td);
                this.td = null;
            } else if (qName.equals("mode") && !(testMode = this.charString).equals(TestCLI.TESTMODE_NOCOMPARE) && !testMode.equals(TestCLI.TESTMODE_TEST)) {
                testMode = TestCLI.TESTMODE_TEST;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String s = new String(ch, start, length);
            this.charString = this.charString + s;
        }
    }
}

