/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.mapred.CapacitySchedulerConf;
import org.apache.hadoop.mapred.CapacitySchedulerQueue;
import org.apache.hadoop.mapred.CapacitySchedulerServlet;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobInProgressListener;
import org.apache.hadoop.mapred.JobInitializationPoller;
import org.apache.hadoop.mapred.JobQueuesManager;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MemoryMatcher;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.server.jobtracker.TaskTracker;

class CapacityTaskScheduler
extends TaskScheduler {
    Map<String, CapacitySchedulerQueue> queueInfoMap = new HashMap<String, CapacitySchedulerQueue>();
    protected TaskSchedulingMgr mapScheduler = new MapSchedulingMgr(this);
    protected TaskSchedulingMgr reduceScheduler = new ReduceSchedulingMgr(this);
    MemoryMatcher memoryMatcher = new MemoryMatcher(this);
    static final Log LOG = LogFactory.getLog(CapacityTaskScheduler.class);
    protected JobQueuesManager jobQueuesManager = new JobQueuesManager(this);
    protected CapacitySchedulerConf schedConf;
    private boolean started = false;
    private Clock clock;
    private JobInitializationPoller initializationPoller;
    private long memSizeForMapSlotOnJT;
    private long memSizeForReduceSlotOnJT;
    private long limitMaxMemForMapTasks;
    private long limitMaxMemForReduceTasks;
    private volatile int maxTasksPerHeartbeat;
    private volatile int maxTasksToAssignAfterOffSwitch;
    private static final int JOBQUEUE_SCHEDULINGINFO_INITIAL_LENGTH = 175;

    public CapacityTaskScheduler() {
        this(new Clock());
    }

    public CapacityTaskScheduler(Clock clock) {
        this.clock = clock;
    }

    public void setResourceManagerConf(CapacitySchedulerConf conf) {
        this.schedConf = conf;
    }

    public synchronized void refresh() throws IOException {
        Configuration conf = new Configuration();
        CapacitySchedulerConf schedConf = new CapacitySchedulerConf();
        QueueManager queueManager = this.taskTrackerManager.getQueueManager();
        Set queueNames = queueManager.getQueues();
        Map<String, CapacitySchedulerQueue> newQueues = this.parseQueues(queueManager.getQueues(), schedConf);
        this.checkForQueueDeletion(this.queueInfoMap, newQueues);
        this.initialize(queueManager, newQueues, conf, schedConf);
        this.initializationPoller.reinit(queueNames);
        this.setConf(conf);
        this.schedConf = schedConf;
    }

    private void checkForQueueDeletion(Map<String, CapacitySchedulerQueue> currentQueues, Map<String, CapacitySchedulerQueue> newQueues) throws IOException {
        for (String queueName : currentQueues.keySet()) {
            if (newQueues.containsKey(queueName)) continue;
            throw new IOException("Couldn't find queue '" + queueName + "' during refresh!");
        }
    }

    private void initializeMemoryRelatedConf(Configuration conf) {
        if (conf.get(CapacitySchedulerConf.DEFAULT_PERCENTAGE_OF_PMEM_IN_VMEM_PROPERTY) != null) {
            LOG.warn((Object)JobConf.deprecatedString((String)CapacitySchedulerConf.DEFAULT_PERCENTAGE_OF_PMEM_IN_VMEM_PROPERTY));
        }
        if (conf.get("mapred.capacity-scheduler.task.limit.maxpmem") != null) {
            LOG.warn((Object)JobConf.deprecatedString((String)"mapred.capacity-scheduler.task.limit.maxpmem"));
        }
        if (conf.get("mapred.task.default.maxvmem") != null) {
            LOG.warn((Object)JobConf.deprecatedString((String)"mapred.task.default.maxvmem"));
        }
        this.memSizeForMapSlotOnJT = JobConf.normalizeMemoryConfigValue((long)conf.getLong("mapred.cluster.map.memory.mb", -1L));
        this.memSizeForReduceSlotOnJT = JobConf.normalizeMemoryConfigValue((long)conf.getLong("mapred.cluster.reduce.memory.mb", -1L));
        if (conf.get("mapred.task.limit.maxvmem") != null) {
            LOG.warn((Object)(JobConf.deprecatedString((String)"mapred.task.limit.maxvmem") + " instead use " + "mapred.cluster.max.map.memory.mb" + " and " + "mapred.cluster.max.reduce.memory.mb"));
            this.limitMaxMemForMapTasks = this.limitMaxMemForReduceTasks = JobConf.normalizeMemoryConfigValue((long)conf.getLong("mapred.task.limit.maxvmem", -1L));
            if (this.limitMaxMemForMapTasks != -1L && this.limitMaxMemForMapTasks >= 0L) {
                this.limitMaxMemForMapTasks = this.limitMaxMemForReduceTasks = this.limitMaxMemForMapTasks / 0x100000L;
            }
        } else {
            this.limitMaxMemForMapTasks = JobConf.normalizeMemoryConfigValue((long)conf.getLong("mapred.cluster.max.map.memory.mb", -1L));
            this.limitMaxMemForReduceTasks = JobConf.normalizeMemoryConfigValue((long)conf.getLong("mapred.cluster.max.reduce.memory.mb", -1L));
        }
        LOG.info((Object)String.format("Scheduler configured with (memSizeForMapSlotOnJT, memSizeForReduceSlotOnJT, limitMaxMemForMapTasks, limitMaxMemForReduceTasks) (%d,%d,%d,%d)", this.memSizeForMapSlotOnJT, this.memSizeForReduceSlotOnJT, this.limitMaxMemForMapTasks, this.limitMaxMemForReduceTasks));
    }

    long getMemSizeForMapSlot() {
        return this.memSizeForMapSlotOnJT;
    }

    long getMemSizeForReduceSlot() {
        return this.memSizeForReduceSlotOnJT;
    }

    long getLimitMaxMemForMapSlot() {
        return this.limitMaxMemForMapTasks;
    }

    long getLimitMaxMemForReduceSlot() {
        return this.limitMaxMemForReduceTasks;
    }

    String[] getOrderedQueues(TaskType type) {
        if (type == TaskType.MAP) {
            return this.mapScheduler.getOrderedQueues();
        }
        if (type == TaskType.REDUCE) {
            return this.reduceScheduler.getOrderedQueues();
        }
        return null;
    }

    public synchronized void start() throws IOException {
        if (this.started) {
            return;
        }
        super.start();
        if (null == this.schedConf) {
            this.schedConf = new CapacitySchedulerConf();
        }
        QueueManager queueManager = this.taskTrackerManager.getQueueManager();
        Set queueNames = queueManager.getQueues();
        this.initialize(queueManager, this.parseQueues(queueNames, this.schedConf), this.getConf(), this.schedConf);
        this.taskTrackerManager.addJobInProgressListener((JobInProgressListener)this.jobQueuesManager);
        if (this.initializationPoller == null) {
            this.initializationPoller = new JobInitializationPoller(this.jobQueuesManager, this.schedConf, queueNames, this.taskTrackerManager);
        }
        this.initializationPoller.init(queueNames.size(), this.schedConf);
        this.initializationPoller.setDaemon(true);
        this.initializationPoller.start();
        if (this.taskTrackerManager instanceof JobTracker) {
            JobTracker jobTracker = (JobTracker)this.taskTrackerManager;
            HttpServer infoServer = jobTracker.infoServer;
            infoServer.setAttribute("scheduler", (Object)this);
            infoServer.addServlet("scheduler", "/scheduler", CapacitySchedulerServlet.class);
        }
        this.started = true;
        LOG.info((Object)("Capacity scheduler initialized " + queueNames.size() + " queues"));
    }

    void initialize(QueueManager queueManager, Map<String, CapacitySchedulerQueue> newQueues, Configuration conf, CapacitySchedulerConf schedConf) {
        this.initializeMemoryRelatedConf(conf);
        for (Map.Entry<String, CapacitySchedulerQueue> e : newQueues.entrySet()) {
            String newQueueName = e.getKey();
            CapacitySchedulerQueue newQueue = e.getValue();
            CapacitySchedulerQueue currentQueue = this.queueInfoMap.get(newQueueName);
            if (currentQueue != null) {
                currentQueue.initializeQueue(newQueue);
                LOG.info((Object)("Updated queue configs for " + newQueueName));
                continue;
            }
            this.queueInfoMap.put(newQueueName, newQueue);
            LOG.info((Object)("Added new queue: " + newQueueName));
        }
        for (String queueName : this.queueInfoMap.keySet()) {
            SchedulingDisplayInfo schedulingInfo = new SchedulingDisplayInfo(queueName, this);
            queueManager.setSchedulerInfo(queueName, (Object)schedulingInfo);
        }
        this.jobQueuesManager.setQueues(this.queueInfoMap);
        this.mapScheduler.initialize(this.queueInfoMap);
        this.reduceScheduler.initialize(this.queueInfoMap);
        this.maxTasksPerHeartbeat = schedConf.getMaxTasksPerHeartbeat();
        this.maxTasksToAssignAfterOffSwitch = schedConf.getMaxTasksToAssignAfterOffSwitch();
    }

    Map<String, CapacitySchedulerQueue> parseQueues(Collection<String> queueNames, CapacitySchedulerConf schedConf) throws IOException {
        HashMap<String, CapacitySchedulerQueue> queueInfoMap = new HashMap<String, CapacitySchedulerQueue>();
        if (0 == queueNames.size()) {
            throw new IllegalStateException("System has no queue configured");
        }
        float totalCapacityPercent = 0.0f;
        for (String queueName : queueNames) {
            float capacityPercent = schedConf.getCapacity(queueName);
            if ((double)capacityPercent == -1.0) {
                throw new IOException("Queue '" + queueName + "' doesn't have configured capacity!");
            }
            totalCapacityPercent += capacityPercent;
            CapacitySchedulerQueue queue = new CapacitySchedulerQueue(queueName, schedConf);
            queueInfoMap.put(queueName, queue);
        }
        if (Math.floor(totalCapacityPercent) != 100.0) {
            throw new IllegalArgumentException("Sum of queue capacities not 100% at " + totalCapacityPercent);
        }
        return queueInfoMap;
    }

    void setInitializationPoller(JobInitializationPoller p) {
        this.initializationPoller = p;
    }

    public synchronized void terminate() throws IOException {
        if (!this.started) {
            return;
        }
        if (this.jobQueuesManager != null) {
            this.taskTrackerManager.removeJobInProgressListener((JobInProgressListener)this.jobQueuesManager);
        }
        this.started = false;
        this.initializationPoller.terminate();
        super.terminate();
    }

    public synchronized void setConf(Configuration conf) {
        super.setConf(conf);
    }

    void updateQueueUsageForTests() {
        ClusterStatus c = this.taskTrackerManager.getClusterStatus();
        int mapClusterCapacity = c.getMaxMapTasks();
        int reduceClusterCapacity = c.getMaxReduceTasks();
        this.updateAllQueues(mapClusterCapacity, reduceClusterCapacity);
        this.mapScheduler.sortQueues();
        this.reduceScheduler.sortQueues();
        this.mapScheduler.printQueues();
        this.reduceScheduler.printQueues();
    }

    private synchronized void updateAllQueues(int mapClusterCapacity, int reduceClusterCapacity) {
        for (CapacitySchedulerQueue queue : this.queueInfoMap.values()) {
            queue.updateAll(mapClusterCapacity, reduceClusterCapacity, this.mapScheduler, this.reduceScheduler);
        }
    }

    static String getJobQueueSchedInfo(int numMapsRunningForThisJob, int numRunningMapSlots, int numReservedMapSlotsForThisJob, int numReducesRunningForThisJob, int numRunningReduceSlots, int numReservedReduceSlotsForThisJob) {
        StringBuilder sb = new StringBuilder(175);
        sb.append(numMapsRunningForThisJob).append(" running map tasks using ").append(numRunningMapSlots).append(" map slots. ").append(numReservedMapSlotsForThisJob).append(" additional slots reserved. ").append(numReducesRunningForThisJob).append(" running reduce tasks using ").append(numRunningReduceSlots).append(" reduce slots. ").append(numReservedReduceSlotsForThisJob).append(" additional slots reserved.");
        return sb.toString();
    }

    public synchronized List<Task> assignTasks(TaskTracker taskTracker) throws IOException {
        TaskTrackerStatus taskTrackerStatus = taskTracker.getStatus();
        ClusterStatus c = this.taskTrackerManager.getClusterStatus();
        int mapClusterCapacity = c.getMaxMapTasks();
        int reduceClusterCapacity = c.getMaxReduceTasks();
        int maxMapSlots = taskTrackerStatus.getMaxMapSlots();
        int currentMapSlots = taskTrackerStatus.countOccupiedMapSlots();
        int maxReduceSlots = taskTrackerStatus.getMaxReduceSlots();
        int currentReduceSlots = taskTrackerStatus.countOccupiedReduceSlots();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("TT asking for task, max maps=" + taskTrackerStatus.getMaxMapSlots() + ", run maps=" + taskTrackerStatus.countMapTasks() + ", max reds=" + taskTrackerStatus.getMaxReduceSlots() + ", run reds=" + taskTrackerStatus.countReduceTasks() + ", map cap=" + mapClusterCapacity + ", red cap = " + reduceClusterCapacity));
        }
        this.updateAllQueues(mapClusterCapacity, reduceClusterCapacity);
        ArrayList<Task> result = new ArrayList<Task>();
        if (this.taskTrackerManager.isInSafeMode()) {
            LOG.info((Object)"JobTracker is in safe-mode, not scheduling any tasks.");
        } else {
            this.addMapTasks(taskTracker, result, maxMapSlots, currentMapSlots);
            this.addReduceTask(taskTracker, result, maxReduceSlots, currentReduceSlots);
        }
        return result;
    }

    private void addReduceTask(TaskTracker taskTracker, List<Task> tasks, int maxReduceSlots, int currentReduceSlots) throws IOException {
        int availableSlots = maxReduceSlots - currentReduceSlots;
        if (availableSlots > 0) {
            this.reduceScheduler.sortQueues();
            TaskLookupResult tlr = this.reduceScheduler.assignTasks(taskTracker, availableSlots, true);
            if (TaskLookupResult.LookUpStatus.LOCAL_TASK_FOUND == tlr.getLookUpStatus()) {
                tasks.add(tlr.getTask());
            }
        }
    }

    private void addMapTasks(TaskTracker taskTracker, List<Task> tasks, int maxMapSlots, int currentMapSlots) throws IOException {
        Task t;
        boolean assignOffSwitch = true;
        int tasksToAssignAfterOffSwitch = this.maxTasksToAssignAfterOffSwitch;
        for (int availableSlots = maxMapSlots - currentMapSlots; availableSlots > 0; availableSlots -= t.getNumSlotsRequired()) {
            this.mapScheduler.sortQueues();
            TaskLookupResult tlr = this.mapScheduler.assignTasks(taskTracker, availableSlots, assignOffSwitch);
            if (TaskLookupResult.LookUpStatus.NO_TASK_FOUND == tlr.getLookUpStatus() || TaskLookupResult.LookUpStatus.TASK_FAILING_MEMORY_REQUIREMENT == tlr.getLookUpStatus()) break;
            t = tlr.getTask();
            JobInProgress job = tlr.getJob();
            tasks.add(t);
            if (tasks.size() >= this.maxTasksPerHeartbeat) {
                return;
            }
            if (TaskLookupResult.LookUpStatus.OFF_SWITCH_TASK_FOUND == tlr.getLookUpStatus()) {
                assignOffSwitch = false;
            }
            if (!assignOffSwitch) {
                if (tasksToAssignAfterOffSwitch == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Hit limit of max tasks after off-switch: " + this.maxTasksToAssignAfterOffSwitch + " after " + tasks.size() + " maps."));
                    }
                    return;
                }
                --tasksToAssignAfterOffSwitch;
            }
            CapacitySchedulerQueue queue = this.queueInfoMap.get(job.getProfile().getQueueName());
            queue.update(TaskType.MAP, job, job.getProfile().getUser(), 1, t.getNumSlotsRequired());
        }
    }

    synchronized void jobAdded(JobInProgress job) throws IOException {
        CapacitySchedulerQueue queue = this.queueInfoMap.get(job.getProfile().getQueueName());
        queue.jobAdded(job);
        this.preInitializeJob(job);
        if (LOG.isDebugEnabled()) {
            String user = job.getProfile().getUser();
            LOG.debug((Object)("Job " + job.getJobID() + " is added under user " + user + ", user now has " + queue.getNumJobsByUser(user) + " jobs"));
        }
    }

    void preInitializeJob(JobInProgress job) {
        JobConf jobConf = job.getJobConf();
        int slotsPerMap = 1;
        int slotsPerReduce = 1;
        if (this.memoryMatcher.isSchedulingBasedOnMemEnabled()) {
            slotsPerMap = jobConf.computeNumSlotsPerMap(this.getMemSizeForMapSlot());
            slotsPerReduce = jobConf.computeNumSlotsPerReduce(this.getMemSizeForReduceSlot());
        }
        job.setNumSlotsPerMap(slotsPerMap);
        job.setNumSlotsPerReduce(slotsPerReduce);
    }

    synchronized void jobCompleted(JobInProgress job) {
        CapacitySchedulerQueue queue = this.queueInfoMap.get(job.getProfile().getQueueName());
        queue.jobCompleted(job);
    }

    public synchronized Collection<JobInProgress> getJobs(String queueName) {
        ArrayList<JobInProgress> jobCollection = new ArrayList<JobInProgress>();
        CapacitySchedulerQueue queue = this.queueInfoMap.get(queueName);
        Collection<JobInProgress> runningJobs = queue.getRunningJobs();
        jobCollection.addAll(queue.getInitializingJobs());
        if (runningJobs != null) {
            jobCollection.addAll(runningJobs);
        }
        Collection<JobInProgress> waitingJobs = queue.getWaitingJobs();
        ArrayList<JobInProgress> tempCollection = new ArrayList<JobInProgress>();
        if (waitingJobs != null) {
            tempCollection.addAll(waitingJobs);
        }
        tempCollection.removeAll(runningJobs);
        if (!tempCollection.isEmpty()) {
            jobCollection.addAll(tempCollection);
        }
        return jobCollection;
    }

    JobInitializationPoller getInitializationPoller() {
        return this.initializationPoller;
    }

    JobQueuesManager getJobQueuesManager() {
        return this.jobQueuesManager;
    }

    Map<String, CapacitySchedulerQueue> getQueueInfoMap() {
        return this.queueInfoMap;
    }

    TaskSchedulingMgr getMapScheduler() {
        return this.mapScheduler;
    }

    TaskSchedulingMgr getReduceScheduler() {
        return this.reduceScheduler;
    }

    synchronized String getDisplayInfo(String queueName) {
        CapacitySchedulerQueue queue = this.queueInfoMap.get(queueName);
        if (null == queue) {
            return null;
        }
        return queue.toString();
    }

    private static int getTTMaxSlotsForType(TaskTrackerStatus status, TaskType type) {
        return type == TaskType.MAP ? status.getMaxMapSlots() : status.getMaxReduceSlots();
    }

    static class Clock {
        Clock() {
        }

        long getTime() {
            return System.currentTimeMillis();
        }
    }

    private static class ReduceSchedulingMgr
    extends TaskSchedulingMgr {
        ReduceSchedulingMgr(CapacityTaskScheduler schedulr) {
            super(schedulr);
            this.type = TaskType.REDUCE;
            this.queueComparator = reduceComparator;
        }

        @Override
        TaskLookupResult obtainNewTask(TaskTrackerStatus taskTracker, JobInProgress job, boolean unused, ClusterStatus clusterStatus) throws IOException {
            int numTaskTrackers = clusterStatus.getTaskTrackers();
            Task t = job.obtainNewReduceTask(taskTracker, numTaskTrackers, this.scheduler.taskTrackerManager.getNumberOfUniqueHosts());
            return t != null ? TaskLookupResult.getTaskFoundResult(t, job) : TaskLookupResult.getNoTaskFoundResult();
        }

        @Override
        int getClusterCapacity() {
            return this.scheduler.taskTrackerManager.getClusterStatus().getMaxReduceTasks();
        }

        @Override
        int getRunningTasks(JobInProgress job) {
            return job.runningReduces();
        }

        @Override
        int getPendingTasks(JobInProgress job) {
            return job.pendingReduces();
        }

        @Override
        int getSlotsPerTask(JobInProgress job) {
            return job.getNumSlotsPerTask(TaskType.REDUCE);
        }

        @Override
        int getNumReservedTaskTrackers(JobInProgress job) {
            return job.getNumReservedTaskTrackersForReduces();
        }

        @Override
        boolean hasSpeculativeTask(JobInProgress job, TaskTrackerStatus tts) {
            return job.getReduceSpeculativeExecution() && this.hasSpeculativeTask(job.getTasks(TaskType.REDUCE), job.getStatus().reduceProgress(), tts);
        }
    }

    private static class MapSchedulingMgr
    extends TaskSchedulingMgr {
        MapSchedulingMgr(CapacityTaskScheduler schedulr) {
            super(schedulr);
            this.type = TaskType.MAP;
            this.queueComparator = mapComparator;
        }

        @Override
        TaskLookupResult obtainNewTask(TaskTrackerStatus taskTracker, JobInProgress job, boolean assignOffSwitch, ClusterStatus clusterStatus) throws IOException {
            int numTaskTrackers = clusterStatus.getTaskTrackers();
            int numUniqueHosts = this.scheduler.taskTrackerManager.getNumberOfUniqueHosts();
            job.schedulingOpportunity();
            Task t = job.obtainNewNodeOrRackLocalMapTask(taskTracker, numTaskTrackers, numUniqueHosts);
            if (t != null) {
                return TaskLookupResult.getTaskFoundResult(t, job);
            }
            if (job.getNumSlotsPerMap() > 1 || assignOffSwitch && job.scheduleOffSwitch(numTaskTrackers)) {
                t = job.obtainNewNonLocalMapTask(taskTracker, numTaskTrackers, numUniqueHosts);
            }
            return t != null ? TaskLookupResult.getOffSwitchTaskFoundResult(t, job) : TaskLookupResult.getNoTaskFoundResult();
        }

        @Override
        int getClusterCapacity() {
            return this.scheduler.taskTrackerManager.getClusterStatus().getMaxMapTasks();
        }

        @Override
        int getRunningTasks(JobInProgress job) {
            return job.runningMaps();
        }

        @Override
        int getPendingTasks(JobInProgress job) {
            return job.pendingMaps();
        }

        @Override
        int getSlotsPerTask(JobInProgress job) {
            return job.getNumSlotsPerTask(TaskType.MAP);
        }

        @Override
        int getNumReservedTaskTrackers(JobInProgress job) {
            return job.getNumReservedTaskTrackersForMaps();
        }

        @Override
        boolean hasSpeculativeTask(JobInProgress job, TaskTrackerStatus tts) {
            return job.getMapSpeculativeExecution() && this.hasSpeculativeTask(job.getTasks(TaskType.MAP), job.getStatus().mapProgress(), tts);
        }
    }

    static abstract class TaskSchedulingMgr {
        protected CapacityTaskScheduler scheduler;
        protected TaskType type = null;
        private List<CapacitySchedulerQueue> queuesForAssigningTasks = new ArrayList<CapacitySchedulerQueue>();
        protected static final MapQueueComparator mapComparator = new MapQueueComparator();
        protected static final ReduceQueueComparator reduceComparator = new ReduceQueueComparator();
        protected QueueComparator queueComparator;

        abstract TaskLookupResult obtainNewTask(TaskTrackerStatus var1, JobInProgress var2, boolean var3, ClusterStatus var4) throws IOException;

        int getSlotsOccupied(JobInProgress job) {
            return (this.getNumReservedTaskTrackers(job) + this.getRunningTasks(job)) * this.getSlotsPerTask(job);
        }

        abstract int getClusterCapacity();

        abstract int getSlotsPerTask(JobInProgress var1);

        abstract int getRunningTasks(JobInProgress var1);

        abstract int getPendingTasks(JobInProgress var1);

        abstract int getNumReservedTaskTrackers(JobInProgress var1);

        abstract boolean hasSpeculativeTask(JobInProgress var1, TaskTrackerStatus var2);

        boolean hasSufficientReservedTaskTrackers(JobInProgress job) {
            return this.getNumReservedTaskTrackers(job) >= this.getPendingTasks(job);
        }

        String[] getOrderedQueues() {
            ArrayList<String> queues = new ArrayList<String>(this.queuesForAssigningTasks.size());
            for (CapacitySchedulerQueue queue : this.queuesForAssigningTasks) {
                queues.add(queue.queueName);
            }
            return queues.toArray(new String[queues.size()]);
        }

        TaskSchedulingMgr(CapacityTaskScheduler sched) {
            this.scheduler = sched;
        }

        void initialize(Map<String, CapacitySchedulerQueue> queues) {
            this.queuesForAssigningTasks.clear();
            this.queuesForAssigningTasks.addAll(queues.values());
            Collections.sort(this.queuesForAssigningTasks, this.queueComparator);
        }

        private synchronized void sortQueues() {
            Collections.sort(this.queuesForAssigningTasks, this.queueComparator);
        }

        private int divideAndCeil(int a, int b) {
            if (b == 0) {
                LOG.info((Object)("divideAndCeil called with a=" + a + " b=" + b));
                return 0;
            }
            return (a + (b - 1)) / b;
        }

        private TaskLookupResult getTaskFromQueue(TaskTracker taskTracker, int availableSlots, CapacitySchedulerQueue queue, boolean assignOffSwitch, ClusterStatus clusterStatus) throws IOException {
            TaskTrackerStatus taskTrackerStatus = taskTracker.getStatus();
            for (JobInProgress j : queue.getRunningJobs()) {
                if (j.getStatus().getRunState() != 1 || !queue.assignSlotsToJob(this.type, j, j.getProfile().getUser())) continue;
                if (this.scheduler.memoryMatcher.matchesMemoryRequirements(j, this.type, taskTrackerStatus, availableSlots)) {
                    TaskLookupResult tlr = this.obtainNewTask(taskTrackerStatus, j, assignOffSwitch, clusterStatus);
                    if (tlr.getLookUpStatus() == TaskLookupResult.LookUpStatus.LOCAL_TASK_FOUND || tlr.getLookUpStatus() == TaskLookupResult.LookUpStatus.OFF_SWITCH_TASK_FOUND) {
                        return tlr;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Job " + j.getJobID().toString() + " returned no tasks of type " + this.type));
                    continue;
                }
                if (this.getPendingTasks(j) == 0 || this.hasSufficientReservedTaskTrackers(j) || j.getNumSlotsPerTask(this.type) > CapacityTaskScheduler.getTTMaxSlotsForType(taskTrackerStatus, this.type)) continue;
                LOG.info((Object)(j.getJobID() + ": Reserving " + taskTracker.getTrackerName() + " since memory-requirements don't match"));
                taskTracker.reserveSlots(this.type, j, taskTracker.getAvailableSlots(this.type));
                return TaskLookupResult.getMemFailedResult();
            }
            if (LOG.isDebugEnabled()) {
                String msg = "Found no task from the queue " + queue.queueName;
                LOG.debug((Object)msg);
            }
            return TaskLookupResult.getNoTaskFoundResult();
        }

        private TaskLookupResult assignTasks(TaskTracker taskTracker, int availableSlots, boolean assignOffSwitch) throws IOException {
            TaskTrackerStatus taskTrackerStatus = taskTracker.getStatus();
            this.printQueues();
            ClusterStatus clusterStatus = this.scheduler.taskTrackerManager.getClusterStatus();
            JobInProgress job = taskTracker.getJobForFallowSlot(this.type);
            if (job != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(job.getJobID() + ": Checking 'reserved' tasktracker " + taskTracker.getTrackerName() + " with " + availableSlots + " '" + this.type + "' slots"));
                }
                if (availableSlots >= job.getNumSlotsPerTask(this.type)) {
                    taskTracker.unreserveSlots(this.type, job);
                    if (this.type == TaskType.MAP) {
                        job.overrideSchedulingOpportunities();
                    }
                    return this.obtainNewTask(taskTrackerStatus, job, true, clusterStatus);
                }
                taskTracker.reserveSlots(this.type, job, availableSlots);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(job.getJobID() + ": Re-reserving " + taskTracker.getTrackerName()));
                }
                return TaskLookupResult.getMemFailedResult();
            }
            for (CapacitySchedulerQueue queue : this.queuesForAssigningTasks) {
                TaskLookupResult tlr;
                TaskLookupResult.LookUpStatus lookUpStatus;
                if (!queue.assignSlotsToQueue(this.type, 1) || (lookUpStatus = (tlr = this.getTaskFromQueue(taskTracker, availableSlots, queue, assignOffSwitch, clusterStatus)).getLookUpStatus()) == TaskLookupResult.LookUpStatus.NO_TASK_FOUND) continue;
                if (lookUpStatus == TaskLookupResult.LookUpStatus.LOCAL_TASK_FOUND || lookUpStatus == TaskLookupResult.LookUpStatus.OFF_SWITCH_TASK_FOUND) {
                    return tlr;
                }
                if (lookUpStatus != TaskLookupResult.LookUpStatus.TASK_FAILING_MEMORY_REQUIREMENT) continue;
                return tlr;
            }
            return TaskLookupResult.getNoTaskFoundResult();
        }

        private void printQueues() {
            if (LOG.isDebugEnabled()) {
                StringBuffer s = new StringBuffer();
                for (CapacitySchedulerQueue queue : this.queuesForAssigningTasks) {
                    Collection<JobInProgress> runJobs = queue.getRunningJobs();
                    s.append(String.format(" Queue '%s'(%s): runningTasks=%d, occupiedSlots=%d, capacity=%d, runJobs=%d  maxCapacity=%d ", queue.queueName, this.type, queue.getNumRunningTasks(this.type), queue.getNumSlotsOccupied(this.type), queue.getCapacity(this.type), runJobs.size(), queue.getMaxCapacity(this.type)));
                }
                LOG.debug((Object)s);
            }
        }

        boolean hasSpeculativeTask(TaskInProgress[] tips, float progress, TaskTrackerStatus tts) {
            long currentTime = System.currentTimeMillis();
            for (TaskInProgress tip : tips) {
                if (!tip.isRunning() || tip.hasRunOnMachine(tts.getHost(), tts.getTrackerName()) || !tip.hasSpeculativeTask(currentTime, (double)progress)) continue;
                return true;
            }
            return false;
        }

        private static final class ReduceQueueComparator
        extends QueueComparator {
            private ReduceQueueComparator() {
            }

            @Override
            TaskType getTaskType() {
                return TaskType.REDUCE;
            }
        }

        private static final class MapQueueComparator
        extends QueueComparator {
            private MapQueueComparator() {
            }

            @Override
            TaskType getTaskType() {
                return TaskType.MAP;
            }
        }

        private static abstract class QueueComparator
        implements Comparator<CapacitySchedulerQueue> {
            private QueueComparator() {
            }

            abstract TaskType getTaskType();

            @Override
            public int compare(CapacitySchedulerQueue q1, CapacitySchedulerQueue q2) {
                double r2;
                TaskType taskType = this.getTaskType();
                double r1 = 0 == q1.getCapacity(taskType) ? 1.0 : (double)q1.getNumSlotsOccupied(taskType) / (double)q1.getCapacity(taskType);
                double d = r2 = 0 == q2.getCapacity(taskType) ? 1.0 : (double)q2.getNumSlotsOccupied(taskType) / (double)q2.getCapacity(taskType);
                if (r1 < r2) {
                    return -1;
                }
                if (r1 > r2) {
                    return 1;
                }
                return 0;
            }
        }
    }

    private static class TaskLookupResult {
        private static final TaskLookupResult NoTaskLookupResult = new TaskLookupResult(null, null, LookUpStatus.NO_TASK_FOUND);
        private static final TaskLookupResult MemFailedLookupResult = new TaskLookupResult(null, null, LookUpStatus.TASK_FAILING_MEMORY_REQUIREMENT);
        private LookUpStatus lookUpStatus;
        private Task task;
        private JobInProgress job;

        private TaskLookupResult(Task t, JobInProgress job, LookUpStatus lUStatus) {
            this.task = t;
            this.job = job;
            this.lookUpStatus = lUStatus;
        }

        static TaskLookupResult getTaskFoundResult(Task t, JobInProgress job) {
            return new TaskLookupResult(t, job, LookUpStatus.LOCAL_TASK_FOUND);
        }

        static TaskLookupResult getNoTaskFoundResult() {
            return NoTaskLookupResult;
        }

        static TaskLookupResult getMemFailedResult() {
            return MemFailedLookupResult;
        }

        static TaskLookupResult getOffSwitchTaskFoundResult(Task t, JobInProgress job) {
            return new TaskLookupResult(t, job, LookUpStatus.OFF_SWITCH_TASK_FOUND);
        }

        Task getTask() {
            return this.task;
        }

        JobInProgress getJob() {
            return this.job;
        }

        LookUpStatus getLookUpStatus() {
            return this.lookUpStatus;
        }

        static enum LookUpStatus {
            LOCAL_TASK_FOUND,
            NO_TASK_FOUND,
            TASK_FAILING_MEMORY_REQUIREMENT,
            OFF_SWITCH_TASK_FOUND;

        }
    }

    private static class SchedulingDisplayInfo {
        private String queueName;
        CapacityTaskScheduler scheduler;

        SchedulingDisplayInfo(String queueName, CapacityTaskScheduler scheduler) {
            this.queueName = queueName;
            this.scheduler = scheduler;
        }

        public String toString() {
            return this.scheduler.getDisplayInfo(this.queueName);
        }
    }
}

