/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.FairScheduler;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobSchedulable;
import org.apache.hadoop.mapred.LoadManager;
import org.apache.hadoop.mapred.LocalityLevel;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskTrackerManager;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.TaskType;

public class JobSchedulableWithNodeGroup
extends JobSchedulable {
    public JobSchedulableWithNodeGroup(FairScheduler scheduler, JobInProgress job, TaskType taskType) {
        super(scheduler, job, taskType);
    }

    public JobSchedulableWithNodeGroup() {
    }

    @Override
    public Task assignTask(TaskTrackerStatus tts, long currentTime, Collection<JobInProgress> visited) throws IOException {
        if (this.isRunnable()) {
            visited.add(this.job);
            TaskTrackerManager ttm = this.scheduler.taskTrackerManager;
            ClusterStatus clusterStatus = ttm.getClusterStatus();
            int numTaskTrackers = clusterStatus.getTaskTrackers();
            LoadManager loadMgr = this.scheduler.getLoadManager();
            if (!loadMgr.canLaunchTask(tts, this.job, this.taskType)) {
                return null;
            }
            if (this.taskType == TaskType.MAP) {
                LocalityLevel localityLevel = this.scheduler.getAllowedLocalityLevel(this.job, currentTime);
                this.scheduler.getEventLog().log("ALLOWED_LOC_LEVEL", new Object[]{this.job.getJobID(), localityLevel});
                switch (localityLevel) {
                    case NODE: {
                        return this.job.obtainNewNodeLocalMapTask(tts, numTaskTrackers, ttm.getNumberOfUniqueHosts());
                    }
                    case NODEGROUP: {
                        return this.job.obtainNewMapTaskCommon(tts, numTaskTrackers, ttm.getNumberOfUniqueHosts(), 2);
                    }
                    case RACK: {
                        return this.job.obtainNewNodeOrRackLocalMapTask(tts, numTaskTrackers, ttm.getNumberOfUniqueHosts());
                    }
                }
                return this.job.obtainNewMapTask(tts, numTaskTrackers, ttm.getNumberOfUniqueHosts());
            }
            return this.job.obtainNewReduceTask(tts, numTaskTrackers, ttm.getNumberOfUniqueHosts());
        }
        return null;
    }
}

