/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.mapred.FairScheduler;
import org.apache.hadoop.mapred.JSPUtil;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.Pool;
import org.apache.hadoop.mapred.PoolManager;
import org.apache.hadoop.mapred.SchedulingMode;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.util.StringUtils;

public class FairSchedulerServlet
extends HttpServlet {
    private static final long serialVersionUID = 9104070533067306659L;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd, HH:mm");
    private FairScheduler scheduler;
    private JobTracker jobTracker;
    private static long lastId = 0L;

    public void init() throws ServletException {
        super.init();
        ServletContext servletContext = this.getServletContext();
        this.scheduler = (FairScheduler)((Object)servletContext.getAttribute("scheduler"));
        this.jobTracker = (JobTracker)this.scheduler.taskTrackerManager;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean advancedView;
        boolean bl = advancedView = request.getParameter("advanced") != null;
        if (JSPUtil.privateActionsAllowed((JobConf)this.jobTracker.conf) && request.getParameter("setPool") != null) {
            Collection<JobInProgress> runningJobs = this.getInitedJobs();
            PoolManager poolMgr = null;
            FairScheduler fairScheduler = this.scheduler;
            synchronized (fairScheduler) {
                poolMgr = this.scheduler.getPoolManager();
            }
            String pool = request.getParameter("setPool");
            String jobId = request.getParameter("jobid");
            for (JobInProgress job : runningJobs) {
                if (!job.getProfile().getJobID().toString().equals(jobId)) continue;
                FairScheduler fairScheduler2 = this.scheduler;
                synchronized (fairScheduler2) {
                    poolMgr.setPool(job, pool);
                }
                this.scheduler.update();
                break;
            }
            response.sendRedirect("/scheduler" + (advancedView ? "?advanced" : ""));
            return;
        }
        if (JSPUtil.privateActionsAllowed((JobConf)this.jobTracker.conf) && request.getParameter("setPriority") != null) {
            Collection<JobInProgress> runningJobs = this.getInitedJobs();
            JobPriority priority = JobPriority.valueOf((String)request.getParameter("setPriority"));
            String jobId = request.getParameter("jobid");
            for (JobInProgress job : runningJobs) {
                if (!job.getProfile().getJobID().toString().equals(jobId)) continue;
                job.setPriority(priority);
                this.scheduler.update();
                break;
            }
            response.sendRedirect("/scheduler" + (advancedView ? "?advanced" : ""));
            return;
        }
        response.setContentType("text/html");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos);
        String hostname = StringUtils.simpleHostname((String)this.jobTracker.getJobTrackerMachine());
        out.print("<html><head>");
        out.printf("<title>%s Fair Scheduler Administration</title>\n", hostname);
        out.print("<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n");
        out.print("</head><body>\n");
        out.printf("<h1><a href=\"/jobtracker.jsp\">%s</a> Fair Scheduler Administration</h1>\n", hostname);
        this.showPools(out, advancedView);
        this.showJobs(out, advancedView);
        out.print("</body></html>\n");
        out.close();
        ServletOutputStream servletOut = response.getOutputStream();
        baos.writeTo((OutputStream)servletOut);
        servletOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPools(PrintWriter out, boolean advancedView) {
        FairScheduler fairScheduler = this.scheduler;
        synchronized (fairScheduler) {
            boolean warnInverted = false;
            PoolManager poolManager = this.scheduler.getPoolManager();
            out.print("<h2>Pools</h2>\n");
            out.print("<table border=\"2\" cellpadding=\"5\" cellspacing=\"2\">\n");
            out.print("<tr><th rowspan=2>Pool</th><th rowspan=2>Running Jobs</th><th colspan=4>Map Tasks</th><th colspan=4>Reduce Tasks</th><th rowspan=2>Scheduling Mode</th></tr>\n<tr><th>Min Share</th><th>Max Share</th><th>Running</th><th>Fair Share</th><th>Min Share</th><th>Max Share</th><th>Running</th><th>Fair Share</th></tr>\n");
            ArrayList<Pool> pools = new ArrayList<Pool>(poolManager.getPools());
            Collections.sort(pools, new Comparator<Pool>(){

                @Override
                public int compare(Pool p1, Pool p2) {
                    if (p1.isDefaultPool()) {
                        return 1;
                    }
                    if (p2.isDefaultPool()) {
                        return -1;
                    }
                    return p1.getName().compareTo(p2.getName());
                }
            });
            for (Pool pool : pools) {
                String name = pool.getName();
                int runningMaps = pool.getMapSchedulable().getRunningTasks();
                int runningReduces = pool.getReduceSchedulable().getRunningTasks();
                int maxMaps = poolManager.getMaxSlots(name, TaskType.MAP);
                int maxReduces = poolManager.getMaxSlots(name, TaskType.REDUCE);
                boolean invertedMaps = poolManager.invertedMinMax(TaskType.MAP, name);
                boolean invertedReduces = poolManager.invertedMinMax(TaskType.REDUCE, name);
                warnInverted = warnInverted || invertedMaps || invertedReduces;
                out.print("<tr>");
                out.printf("<td>%s</td>", name);
                out.printf("<td>%d</td>", pool.getJobs().size());
                out.printf("<td>%d</td>", poolManager.getAllocation(name, TaskType.MAP));
                out.print("<td>");
                if (maxMaps == Integer.MAX_VALUE) {
                    out.print("-");
                } else {
                    out.print(maxMaps);
                }
                if (invertedMaps) {
                    out.print("*");
                }
                out.print("</td>");
                out.printf("<td>%d</td>", runningMaps);
                out.printf("<td>%.1f</td>", pool.getMapSchedulable().getFairShare());
                out.printf("<td>%d</td>", poolManager.getAllocation(name, TaskType.REDUCE));
                out.print("<td>");
                if (maxReduces == Integer.MAX_VALUE) {
                    out.print("-");
                } else {
                    out.print(maxReduces);
                }
                if (invertedReduces) {
                    out.print("*");
                }
                out.print("</td>");
                out.printf("<td>%d</td>", runningReduces);
                out.printf("<td>%.1f</td>", pool.getReduceSchedulable().getFairShare());
                out.printf("<td>%s</td>", new Object[]{pool.getSchedulingMode()});
                out.print("</tr>\n");
            }
            out.print("</table>\n");
            if (warnInverted) {
                out.print("<p>* One or more pools have max share set lower than min share. Max share will be used and minimum will be treated as if set equal to max.</p>");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showJobs(PrintWriter out, boolean advancedView) {
        out.print("<h2>Running Jobs</h2>\n");
        out.print("<table border=\"2\" cellpadding=\"5\" cellspacing=\"2\">\n");
        int colsPerTaskType = advancedView ? 4 : 3;
        out.printf("<tr><th rowspan=2>Submitted</th><th rowspan=2>JobID</th><th rowspan=2>User</th><th rowspan=2>Name</th><th rowspan=2>Pool</th><th rowspan=2>Priority</th><th colspan=%d>Map Tasks</th><th colspan=%d>Reduce Tasks</th>", colsPerTaskType, colsPerTaskType);
        out.print("</tr><tr>\n");
        out.print("<th>Finished</th><th>Running</th><th>Fair Share</th>" + (advancedView ? "<th>Weight</th>" : ""));
        out.print("<th>Finished</th><th>Running</th><th>Fair Share</th>" + (advancedView ? "<th>Weight</th>" : ""));
        out.print("</tr>\n");
        JobTracker jobTracker = this.jobTracker;
        synchronized (jobTracker) {
            Collection<JobInProgress> runningJobs = this.getInitedJobs();
            FairScheduler fairScheduler = this.scheduler;
            synchronized (fairScheduler) {
                for (JobInProgress job : runningJobs) {
                    JobProfile profile = job.getProfile();
                    FairScheduler.JobInfo info = this.scheduler.infos.get(job);
                    if (info == null) {
                        info = new FairScheduler.JobInfo(null, null);
                    }
                    out.print("<tr>\n");
                    out.printf("<td>%s</td>\n", DATE_FORMAT.format(new Date(job.getStartTime())));
                    out.printf("<td><a href=\"jobdetails.jsp?jobid=%s\">%s</a></td>", profile.getJobID(), profile.getJobID());
                    out.printf("<td>%s</td>\n", profile.getUser());
                    out.printf("<td>%s</td>\n", profile.getJobName());
                    if (JSPUtil.privateActionsAllowed((JobConf)this.jobTracker.conf)) {
                        out.printf("<td>%s</td>\n", this.generateSelect(this.scheduler.getPoolManager().getPoolNames(), this.scheduler.getPoolManager().getPoolName(job), "/scheduler?setPool=<CHOICE>&jobid=" + profile.getJobID() + (advancedView ? "&advanced" : "")));
                        out.printf("<td>%s</td>\n", this.generateSelect(Arrays.asList("VERY_LOW", "LOW", "NORMAL", "HIGH", "VERY_HIGH"), job.getPriority().toString(), "/scheduler?setPriority=<CHOICE>&jobid=" + profile.getJobID() + (advancedView ? "&advanced" : "")));
                    } else {
                        out.printf("<td>%s</td>\n", this.scheduler.getPoolManager().getPoolName(job));
                        out.printf("<td>%s</td>\n", job.getPriority().toString());
                    }
                    Pool pool = this.scheduler.getPoolManager().getPool(job);
                    String mapShare = pool.getSchedulingMode() == SchedulingMode.FAIR ? String.format("%.1f", info.mapSchedulable.getFairShare()) : "NA";
                    out.printf("<td>%d / %d</td><td>%d</td><td>%s</td>\n", job.finishedMaps(), job.desiredMaps(), info.mapSchedulable.getRunningTasks(), mapShare);
                    if (advancedView) {
                        out.printf("<td>%.1f</td>\n", info.mapSchedulable.getWeight());
                    }
                    String reduceShare = pool.getSchedulingMode() == SchedulingMode.FAIR ? String.format("%.1f", info.reduceSchedulable.getFairShare()) : "NA";
                    out.printf("<td>%d / %d</td><td>%d</td><td>%s</td>\n", job.finishedReduces(), job.desiredReduces(), info.reduceSchedulable.getRunningTasks(), reduceShare);
                    if (advancedView) {
                        out.printf("<td>%.1f</td>\n", info.reduceSchedulable.getWeight());
                    }
                    out.print("</tr>\n");
                }
            }
        }
        out.print("</table>\n");
    }

    private String generateSelect(Iterable<String> choices, String selectedChoice, String submitUrl) {
        StringBuilder html = new StringBuilder();
        String id = "select" + lastId++;
        html.append("<select id=\"" + id + "\" name=\"" + id + "\" " + "onchange=\"window.location = '" + submitUrl + "'.replace('<CHOICE>', document.getElementById('" + id + "').value);\">\n");
        for (String choice : choices) {
            html.append(String.format("<option value=\"%s\"%s>%s</option>\n", choice, choice.equals(selectedChoice) ? " selected" : "", choice));
        }
        html.append("</select>\n");
        return html.toString();
    }

    private Collection<JobInProgress> getInitedJobs() {
        List runningJobs = this.jobTracker.getRunningJobs();
        Iterator it = runningJobs.iterator();
        while (it.hasNext()) {
            JobInProgress job = (JobInProgress)it.next();
            if (job.inited()) continue;
            it.remove();
        }
        return runningJobs;
    }
}

