/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by  The HDF Group and                                           *
 * The Board of Trustees of the University of Illinois.                      *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,      *
 * including terms governing use, modification, and redistribution, is       *
 * contained in the files COPYING and Copyright.html.  COPYING can be found  *
 * at the root of the source code distribution tree; Copyright.html can be   *
 * found at the root level of an installed copy of the electronic H4H5TOOLS  *
 * document set, is linked from the top-level documents page, and can be     *
 * found at http://www.hdfgroup.org/h4toh5/Copyright.html.  If you do not    *
 * have access to either file, you may request a copy from help@hdfgroup.org.*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "h4toh5.h"
/* There are 12 test cases for h4toh5 library.*/
/* h4h5apitestdefault,
     h4h5apitestname,
     h4h5apitestimage,
     h4h5apitestimageattr,
     h4h5apitestsds,
     h4h5apitestsdsattr,
     h4h5apitestvdata,
     h4h5apitestvdataattr,
     h4h5apitestadvgroup,
     h4h5apitestbasvgroup,
     h4h5apitestloneimage,
     h4h5apitestlonesds,
     h4h5apitestlonevdata
     
     This file is h4h5apitestbasvgroup.c.

     Basic procedure:
     test H4toH5basvgroup,H4toH5vgroupattrindex, H4toH5vgroupattrname 
*/

/*-------------------------------------------------------------------------
 * Function:     main()
 *
 * Purpose:     test basic vgroup conversion 
 *-------------------------------------------------------------------------
 */      

int main() {
    
    hid_t                   h4toh5id; /*h4toh5 id*/
    int32                   file_id;    /*HDF4 file id */
    int32                   vgroup_id;/*HDF4 vgroup id */
    int32                   vgroup_ref; /* vgroup reference number */
    int32                   status;     /*temporary variable to check status of HDF4 APIs */
    int                     h4toh5status; /*temporary variable to check status of H4toH5 APIs */

    /** open H interface **/
    file_id = Hopen("vg_bas_test.hdf",DFACC_READ,0);
    if(file_id == FAIL) {
        printf("cannot open H interface.\n");
        return FAIL;
    }

     /** open V interface **/
    status  = Vstart(file_id);
    if(status == FAIL) {
        printf("cannot start V interface.\n");
        Hclose(file_id);
        return FAIL;
    }

    if((h4toh5id= H4toH5open("vg_bas_test.hdf","vg_bas_test.h5",H425_CLOBBER)) < 0) {
        printf("cannot open H4toH5 library\n");
        Vend(file_id);
        Hclose(file_id);
        return FAIL;
    }

    /** obtaining a vgroup id. **/
    vgroup_ref = Vgetid(file_id,-1);
    if(vgroup_ref == FAIL) {
        printf("cannot obtain vgroup reference number.\n");
        Vend(file_id);
        Hclose(file_id);
        H4toH5close(h4toh5id);
        return FAIL;
    }

    vgroup_id = Vattach(file_id,vgroup_ref,"r");

    /* converting vgroup with an image object. */
    if(H4toH5bas_vgroup(h4toh5id,vgroup_id,"/gpartial",NULL,1,0)<0){
        printf("fail to convert vgroup with an image object\n");
        H4toH5error_get(h4toh5id);
        Vend(file_id);
        Hclose(file_id);
        H4toH5close(h4toh5id);
        return FAIL;
    }        

    /* converting vgroup attribute with index 0 */
    if(H4toH5vgroup_attr_index(h4toh5id,vgroup_id,"/gpartial",NULL,0)<0){
        printf("fail to convert vgroup attribute by index\n");
        H4toH5error_get(h4toh5id);
        Vend(file_id);
        Hclose(file_id);
        H4toH5close(h4toh5id);
        return FAIL;
    }
     status = Vdetach(vgroup_id);
     if(status == FAIL) {
         printf("fail to detach vgroup.\n");
         H4toH5error_get(h4toh5id);
         Vend(file_id);
         Hclose(file_id);
         H4toH5close(h4toh5id);
         return FAIL;
     }

     /* using hdp to find a vgroup reference number(4) and convert
            this vgroup and the non-vgroup number to HDF5 vgroup */
    vgroup_id = Vattach(file_id,4,"r");

    /* converting vgroup with an image object. */
    if(H4toH5bas_vgroup(h4toh5id,vgroup_id,"/gpartial2",NULL,1,0)<0){
        printf("fail to convert vgroup with an image object \n");
         H4toH5error_get(h4toh5id);
         Vend(file_id);
         Hclose(file_id);
         H4toH5close(h4toh5id);
        return FAIL;
    }        

    /* convert vgroup attribute with the name "vgroup attribute 1". */
    if(H4toH5vgroup_attr_name(h4toh5id,vgroup_id,"/gpartial2",NULL,"Vgroup attribute 1")<0){
        printf("fail to convert vgroup attribute by name\n");
        H4toH5error_get(h4toh5id);
        Vend(file_id);
        Hclose(file_id);
        H4toH5close(h4toh5id);
        return FAIL;
    }

    /* close all interfaces. */
     status = Vdetach(vgroup_id);
     if(status == FAIL) {
         printf("fail to detach vgroup.\n");
         H4toH5error_get(h4toh5id);
         Vend(file_id);
         Hclose(file_id);
         H4toH5close(h4toh5id);
         return FAIL;
     }

     status = Vend(file_id);
     if(status == FAIL) {
         printf("fail to end V interface.\n");
            Hclose(file_id);
         H4toH5close(h4toh5id);
         return FAIL;
     }
     status = Hclose(file_id);
     if(status == FAIL) {
         printf("fail to end H interface. \n");
            Hclose(file_id);
         H4toH5close(h4toh5id);
         return FAIL;
     }
     h4toh5status = H4toH5close(h4toh5id);
     if(h4toh5status == FAIL){
         printf("fail to close H4toH5 interface.\n");
         return FAIL;
     }
     return SUCCEED;
}
     



