include (CMakePackageConfigHelpers)

#-----------------------------------------------------------------------------
# Check for Installation Utilities
#-----------------------------------------------------------------------------
if (WIN32)
  set (PF_ENV_EXT "(x86)")
  find_program (NSIS_EXECUTABLE NSIS.exe PATHS "$ENV{ProgramFiles}\\NSIS" "$ENV{ProgramFiles${PF_ENV_EXT}}\\NSIS")
  if(NOT CPACK_WIX_ROOT)
    file(TO_CMAKE_PATH "$ENV{WIX}" CPACK_WIX_ROOT)
  endif()
  find_program (WIX_EXECUTABLE candle  PATHS "${CPACK_WIX_ROOT}/bin")
endif ()

#-----------------------------------------------------------------------------
# Add file(s) to CMake Install
#-----------------------------------------------------------------------------
if (NOT H4H5_INSTALL_NO_DEVELOPMENT)
  install (
      FILES ${EXTERNAL_HEADER_LIST}
      DESTINATION ${H4H5_INSTALL_INCLUDE_DIR}
      COMPONENT headers
  )
endif ()

#-----------------------------------------------------------------------------
# Add Target(s) to CMake Install for import into other projects
#-----------------------------------------------------------------------------
if (NOT H4H5_EXTERNALLY_CONFIGURED)
  install (
      EXPORT ${H4H5_EXPORTED_TARGETS}
      DESTINATION ${H4H5_INSTALL_CMAKE_DIR}
      FILE ${H4H5_PACKAGE}${HDF_PACKAGE_EXT}-targets.cmake
      NAMESPACE ${H4H5_PACKAGE}::
      COMPONENT configinstall
  )
endif ()

#-----------------------------------------------------------------------------
# Export all exported targets to the build tree for use by parent project
#-----------------------------------------------------------------------------
if (NOT H4H5_EXTERNALLY_CONFIGURED)
  export (
      TARGETS ${H4H5_LIBRARIES_TO_EXPORT} ${H4H5_APPS_TO_EXPORT} ${H4H5_LIB_DEPENDENCIES}
      FILE ${H4H5_PACKAGE}${HDF_PACKAGE_EXT}-targets.cmake
      NAMESPACE ${H4H5_PACKAGE}::
  )
endif ()

#-----------------------------------------------------------------------------
# Set includes needed for build
#-----------------------------------------------------------------------------
set (H4H5_INCLUDES_BUILD_TIME
    ${H4H5_SRC_DIR}
    ${H4H5_BINARY_DIR}
)

#-----------------------------------------------------------------------------
# Set variables needed for installation
#-----------------------------------------------------------------------------
set (H4H5_VERSION_STRING ${H4H5_PACKAGE_VERSION})
set (H4H5_VERSION_MAJOR  ${H4H5_PACKAGE_VERSION_MAJOR})
set (H4H5_VERSION_MINOR  ${H4H5_PACKAGE_VERSION_MINOR})

#-----------------------------------------------------------------------------
# Configure the h4h5-config.cmake file for the build directory
#-----------------------------------------------------------------------------
set (INCLUDE_INSTALL_DIR ${H4H5_INSTALL_INCLUDE_DIR})
set (SHARE_INSTALL_DIR "${CMAKE_CURRENT_BINARY_DIR}/${H4H5_INSTALL_CMAKE_DIR}" )
set (CURRENT_BUILD_DIR "${CMAKE_CURRENT_BINARY_DIR}" )
configure_package_config_file (
    ${HDF_RESOURCES_DIR}/h4h5-config.cmake.in
    "${H4H5_BINARY_DIR}/${H4H5_PACKAGE}${HDF_PACKAGE_EXT}-config.cmake"
    INSTALL_DESTINATION "${H4H5_INSTALL_CMAKE_DIR}"
    PATH_VARS INCLUDE_INSTALL_DIR SHARE_INSTALL_DIR CURRENT_BUILD_DIR
    INSTALL_PREFIX "${CMAKE_CURRENT_BINARY_DIR}"
)

#-----------------------------------------------------------------------------
# Configure the h4h5-config.cmake file for the install directory
#-----------------------------------------------------------------------------
set (INCLUDE_INSTALL_DIR ${H4H5_INSTALL_INCLUDE_DIR})
set (SHARE_INSTALL_DIR "${CMAKE_INSTALL_PREFIX}/${H4H5_INSTALL_CMAKE_DIR}" )
set (CURRENT_BUILD_DIR "${CMAKE_INSTALL_PREFIX}" )
configure_package_config_file (
    ${HDF_RESOURCES_DIR}/h4h5-config.cmake.in
    "${H4H5_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/${H4H5_PACKAGE}${HDF_PACKAGE_EXT}-config.cmake"
    INSTALL_DESTINATION "${H4H5_INSTALL_CMAKE_DIR}"
    PATH_VARS INCLUDE_INSTALL_DIR SHARE_INSTALL_DIR CURRENT_BUILD_DIR
)
if (NOT HDF4_EXTERNALLY_CONFIGURED)
  install (
      FILES ${H4H5_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/${H4H5_PACKAGE}${HDF_PACKAGE_EXT}-config.cmake
      DESTINATION ${H4H5_INSTALL_CMAKE_DIR}
      COMPONENT configinstall
  )
endif ()

#-----------------------------------------------------------------------------
# Configure the h4h5-config-version.cmake file for the install directory
#-----------------------------------------------------------------------------
if (NOT H4H5_EXTERNALLY_CONFIGURED)
  configure_file (
      ${HDF_RESOURCES_DIR}/h4h5-config-version.cmake.in
      ${H4H5_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/${H4H5_PACKAGE}${HDF_PACKAGE_EXT}-config-version.cmake @ONLY
  )
  install (
      FILES ${H4H5_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/${H4H5_PACKAGE}${HDF_PACKAGE_EXT}-config-version.cmake
      DESTINATION ${H4H5_INSTALL_CMAKE_DIR}
      COMPONENT configinstall
  )
endif ()

#-----------------------------------------------------------------------------
# Configure the H4H5_Examples.cmake file and the examples
#-----------------------------------------------------------------------------
option (H4H5_PACK_EXAMPLES  "Package the H4H5 Library Examples Compressed File" OFF)
if (H4H5_PACK_EXAMPLES)
  configure_file (
      ${HDF_RESOURCES_DIR}/H4H5_Examples.cmake.in
      ${H4H5_BINARY_DIR}/H4H5_Examples.cmake @ONLY
  )
  install (
      FILES ${H4H5_BINARY_DIR}/H4H5_Examples.cmake
      DESTINATION ${H4H5_INSTALL_DATA_DIR}
      COMPONENT hdfdocuments
  )
#  if (EXISTS "${H4H5_EXAMPLES_COMPRESSED_DIR}/${H4H5_EXAMPLES_COMPRESSED}")
#    execute_process(
#        COMMAND ${CMAKE_COMMAND} -E tar xzf ${H4H5_EXAMPLES_COMPRESSED_DIR}/${H4H5_EXAMPLES_COMPRESSED}
#    )
    install (
      DIRECTORY ${HDF_RESOURCES_DIR}/scripts/H4H5Examples
      DESTINATION ${H4H5_INSTALL_DATA_DIR}
      USE_SOURCE_PERMISSIONS
      COMPONENT hdfdocuments
    )
#  endif ()
  install (
      FILES
          ${H4H5_SOURCE_DIR}/release_docs/USING_CMake_Examples.txt
      DESTINATION ${H4H5_INSTALL_DATA_DIR}
      COMPONENT hdfdocuments
  )
  install (
      FILES
          ${HDF_RESOURCES_DIR}/CTestScript.cmake
      DESTINATION ${H4H5_INSTALL_DATA_DIR}
      COMPONENT hdfdocuments
  )
  install (
      FILES
          ${HDF_RESOURCES_DIR}/H4H5_Examples_options.cmake
      DESTINATION ${H4H5_INSTALL_DATA_DIR}
      COMPONENT hdfdocuments
  )
endif ()

#-----------------------------------------------------------------------------
# Configure the README.txt file for the binary package
#-----------------------------------------------------------------------------
HDF_README_PROPERTIES(FALSE)

#-----------------------------------------------------------------------------
# Configure the COPYING.txt file for the windows binary package
#-----------------------------------------------------------------------------
if (WIN32)
  configure_file (${H4H5_SOURCE_DIR}/COPYING ${H4H5_BINARY_DIR}/COPYING.txt @ONLY)
endif ()

#-----------------------------------------------------------------------------
# Add Document File(s) to CMake Install
#-----------------------------------------------------------------------------
if (NOT H4H5_EXTERNALLY_CONFIGURED)
  install (
      FILES
          ${H4H5_SOURCE_DIR}/COPYING
      DESTINATION ${H4H5_INSTALL_DATA_DIR}
      COMPONENT hdfdocuments
  )
  if (EXISTS "${H4H5_SOURCE_DIR}/release_docs" AND IS_DIRECTORY "${H4H5_SOURCE_DIR}/release_docs")
    set (release_files
        ${H4H5_SOURCE_DIR}/release_docs/USING_H4H5_CMake.txt
    )
    if (WIN32)
      set (release_files
          ${release_files}
          ${H4H5_SOURCE_DIR}/release_docs/USING_H4H5_VS.txt
      )
    endif ()
    if (HDF_PACK_INSTALL_DOCS)
      set (release_files
          ${release_files}
          ${H4H5_SOURCE_DIR}/release_docs/INSTALL_CMake.txt
          ${H4H5_SOURCE_DIR}/release_docs/HISTORY.txt
          ${H4H5_SOURCE_DIR}/release_docs/RELEASE.txt
      )
      if (WIN32)
        set (release_files
            ${release_files}
            ${H4H5_SOURCE_DIR}/release_docs/INSTALL_Windows.txt
        )
      else ()
        set (release_files
            ${release_files}
            ${H4H5_SOURCE_DIR}/release_docs/INSTALL_Unix.txt
        )
      endif ()
    endif ()
    install (
        FILES ${release_files}
        DESTINATION ${H4H5_INSTALL_DATA_DIR}
        COMPONENT hdfdocuments
    )
  endif ()
endif ()

if (CMAKE_INSTALL_PREFIX_INITIALIZED_TO_DEFAULT)
  if (CMAKE_HOST_UNIX)
    set (CMAKE_INSTALL_PREFIX "${CMAKE_INSTALL_PREFIX}/HDF_Group/${H4H5_PACKAGE_NAME}/${H4H5_PACKAGE_VERSION}"
      CACHE PATH "Install path prefix, prepended onto install directories." FORCE)
  else ()
    GetDefaultWindowsPrefixBase(CMAKE_GENERIC_PROGRAM_FILES)
    set (CMAKE_INSTALL_PREFIX
      "${CMAKE_GENERIC_PROGRAM_FILES}/HDF_Group/${H4H5_PACKAGE_NAME}/${H4H5_PACKAGE_VERSION}"
      CACHE PATH "Install path prefix, prepended onto install directories." FORCE)
    set (CMAKE_GENERIC_PROGRAM_FILES)
  endif ()
endif ()

#-----------------------------------------------------------------------------
# Set the cpack variables
#-----------------------------------------------------------------------------
set (CPACK_PACKAGE_VENDOR "HDF_Group")
set (CPACK_PACKAGE_NAME "${H4H5_PACKAGE_NAME}")
set (CPACK_PACKAGE_DESCRIPTION_SUMMARY "HDF4 to HDF5 Utility Installation")
set (CPACK_PACKAGE_DESCRIPTION_FILE "${CMAKE_CURRENT_SOURCE_DIR}/release_docs/RELEASE.txt")
if (CDASH_LOCAL)
  set (CPACK_PACKAGE_VERSION "${H4H5_PACKAGE_VERSION}")
else ()
  set (CPACK_PACKAGE_VERSION "${H4H5_PACKAGE_VERSION_STRING}")
endif ()
set (CPACK_PACKAGE_VERSION_MAJOR "${H4H5_PACKAGE_VERSION_MAJOR}")
set (CPACK_PACKAGE_VERSION_MINOR "${H4H5_PACKAGE_VERSION_MINOR}")
set (CPACK_PACKAGE_VERSION_PATCH "")
set (CPACK_RESOURCE_FILE_LICENSE "${CMAKE_CURRENT_SOURCE_DIR}/COPYING")
set (CPACK_RESOURCE_FILE_README "${CMAKE_CURRENT_SOURCE_DIR}/release_docs/RELEASE.txt")
set (CPACK_PACKAGE_INSTALL_DIRECTORY "${CPACK_PACKAGE_VENDOR}/${CPACK_PACKAGE_NAME}/${CPACK_PACKAGE_VERSION}")
set (CPACK_PACKAGE_RELOCATABLE TRUE)
set (CPACK_PACKAGE_ICON "${H4H5_RESOURCES_DIR}/hdf.bmp")

set (CPACK_GENERATOR "TGZ")
if (WIN32)
  set (CPACK_GENERATOR "ZIP")

  if (NSIS_EXECUTABLE)
    list (APPEND CPACK_GENERATOR "NSIS")
  endif ()
  # Installers for 32- vs. 64-bit CMake:
  #  - Root install directory (displayed to end user at installer-run time)
  #  - "NSIS package/display name" (text used in the installer GUI)
  #  - Registry key used to store info about the installation
  set (CPACK_NSIS_PACKAGE_NAME "${H4H5_PACKAGE_STRING}")
  if (CMAKE_CL_64)
    set (CPACK_NSIS_INSTALL_ROOT "$PROGRAMFILES64")
    set (CPACK_PACKAGE_INSTALL_REGISTRY_KEY "${CPACK_PACKAGE_NAME}-${CPACK_PACKAGE_VERSION} (Win64)")
  else ()
    set (CPACK_NSIS_INSTALL_ROOT "$PROGRAMFILES")
    set (CPACK_PACKAGE_INSTALL_REGISTRY_KEY "${CPACK_PACKAGE_NAME}-${CPACK_PACKAGE_VERSION}")
  endif ()
  # set the install/unistall icon used for the installer itself
  # There is a bug in NSI that does not handle full unix paths properly.
  set (CPACK_NSIS_MUI_ICON "${HDF_RESOURCES_EXT_DIR}\\\\hdf.ico")
  set (CPACK_NSIS_MUI_UNIICON "${HDF_RESOURCES_EXT_DIR}\\\\hdf.ico")
  # set the package header icon for MUI
  set (CPACK_PACKAGE_ICON "${HDF_RESOURCES_EXT_DIR}\\\\hdf.bmp")
  set (CPACK_NSIS_DISPLAY_NAME "${CPACK_NSIS_PACKAGE_NAME}")#, is a conversion library for converting between individual HDF4 and HDF5 objects")
  set (CPACK_PACKAGE_INSTALL_DIRECTORY "${CPACK_PACKAGE_VENDOR}\\\\${CPACK_PACKAGE_NAME}\\\\${CPACK_PACKAGE_VERSION}")
  #set (CPACK_MONOLITHIC_INSTALL ON)
  set (CPACK_NSIS_CONTACT "${H4H5_PACKAGE_BUGREPORT}")
  set (CPACK_NSIS_MODIFY_PATH ON)

  if (WIX_EXECUTABLE)
    list (APPEND CPACK_GENERATOR "WIX")
  endif ()
#WiX variables
  set (CPACK_WIX_UNINSTALL "1")
# .. variable:: CPACK_WIX_LICENSE_RTF
#  RTF License File
#
#  If CPACK_RESOURCE_FILE_LICENSE has an .rtf extension it is used as-is.
#
#  If CPACK_RESOURCE_FILE_LICENSE has an .txt extension it is implicitly
#  converted to RTF by the WiX Generator.
#  The expected encoding of the .txt file is UTF-8.
#
#  With CPACK_WIX_LICENSE_RTF you can override the license file used by the
#  WiX Generator in case CPACK_RESOURCE_FILE_LICENSE is in an unsupported
#  format or the .txt -> .rtf conversion does not work as expected.
  set (CPACK_RESOURCE_FILE_LICENSE "${H4H5_BINARY_DIR}/COPYING.txt")
# .. variable:: CPACK_WIX_PRODUCT_ICON
#  The Icon shown next to the program name in Add/Remove programs.
  set(CPACK_WIX_PRODUCT_ICON "${HDF_RESOURCES_EXT_DIR}\\\\hdf.ico")
#
# .. variable:: CPACK_WIX_UI_BANNER
#
#  The bitmap will appear at the top of all installer pages other than the
#  welcome and completion dialogs.
#
#  If set, this image will replace the default banner image.
#
#  This image must be 493 by 58 pixels.
#
# .. variable:: CPACK_WIX_UI_DIALOG
#
#  Background bitmap used on the welcome and completion dialogs.
#
#  If this variable is set, the installer will replace the default dialog
#  image.
#
#  This image must be 493 by 312 pixels.
#
  set(CPACK_WIX_PROPERTY_ARPCOMMENTS "Hierarchical Data Format (HDF) Conversion Software Library and Utilities")
  set(CPACK_WIX_PROPERTY_ARPURLINFOABOUT "${H4H5_PACKAGE_URL}")
  set(CPACK_WIX_PROPERTY_ARPHELPLINK "${H4H5_PACKAGE_BUGREPORT}")
  if (BUILD_SHARED_LIBS)
    set(CPACK_WIX_PATCH_FILE "${HDF_RESOURCES_DIR}/patch.xml")
  endif ()
elseif (APPLE)
  list (APPEND CPACK_GENERATOR "STGZ")
  list (APPEND CPACK_GENERATOR "DragNDrop")
  set (CPACK_COMPONENTS_ALL_IN_ONE_PACKAGE ON)
  set (CPACK_PACKAGING_INSTALL_PREFIX "/${CPACK_PACKAGE_INSTALL_DIRECTORY}")
  set (CPACK_PACKAGE_ICON "${HDF_RESOURCES_EXT_DIR}/hdf.icns")

  option (H4H5_PACK_MACOSX_FRAMEWORK  "Package the HDF Conversion Library in a Framework" OFF)
  if (H4H5_PACK_MACOSX_FRAMEWORK AND H4H5_BUILD_FRAMEWORKS)
    list (APPEND CPACK_GENERATOR "Bundle")
    set (CPACK_BUNDLE_NAME "${H4H5_PACKAGE_STRING}")
    set (CPACK_BUNDLE_LOCATION "/")    # make sure CMAKE_INSTALL_PREFIX ends in /
    set (CMAKE_INSTALL_PREFIX "/${CPACK_BUNDLE_NAME}.framework/Versions/${CPACK_PACKAGE_VERSION}/${CPACK_PACKAGE_NAME}/")
    set (CPACK_BUNDLE_ICON "${HDF_RESOURCES_EXT_DIR}/hdf.icns")
    set (CPACK_BUNDLE_PLIST "${H4H5_BINARY_DIR}/CMakeFiles/Info.plist")
    set (CPACK_APPLE_GUI_INFO_STRING "H4H5 (H4toH5 conversion) Software Library and Utilities")
    set (CPACK_APPLE_GUI_COPYRIGHT "Copyright © 2006-2014 by The HDF Group. All rights reserved.")
    set (CPACK_SHORT_VERSION_STRING "${CPACK_PACKAGE_VERSION}")
    set (CPACK_APPLE_GUI_BUNDLE_NAME "${H4H5_PACKAGE_STRING}")
    set (CPACK_APPLE_GUI_VERSION_STRING "${CPACK_PACKAGE_VERSION_STRING}")
    set (CPACK_APPLE_GUI_SHORT_VERSION_STRING "${CPACK_PACKAGE_VERSION}")
    #-----------------------------------------------------------------------------
    # Configure the Info.plist file for the install bundle
    #-----------------------------------------------------------------------------
    configure_file (
        ${HDF_RESOURCES_EXT_DIR}/CPack.Info.plist.in
        ${H4H5_BINARY_DIR}/CMakeFiles/Info.plist @ONLY
    )
    configure_file (
        ${HDF_RESOURCES_DIR}/PkgInfo.in
        ${H4H5_BINARY_DIR}/CMakeFiles/PkgInfo @ONLY
    )
    configure_file (
        ${HDF_RESOURCES_EXT_DIR}/version.plist.in
        ${H4H5_BINARY_DIR}/CMakeFiles/version.plist @ONLY
    )
    install (
        FILES ${H4H5_BINARY_DIR}/CMakeFiles/PkgInfo
              ${H4H5_BINARY_DIR}/CMakeFiles/version.plist
        DESTINATION ..
    )
  endif ()
else ()
  list (APPEND CPACK_GENERATOR "STGZ")
  set (CPACK_PACKAGING_INSTALL_PREFIX "/${CPACK_PACKAGE_INSTALL_DIRECTORY}")
  set (CPACK_COMPONENTS_ALL_IN_ONE_PACKAGE ON)

  set (CPACK_DEBIAN_PACKAGE_SECTION "Libraries")
  set (CPACK_DEBIAN_PACKAGE_MAINTAINER "${H4H5_PACKAGE_BUGREPORT}")

#    list (APPEND CPACK_GENERATOR "RPM")
  set (CPACK_RPM_PACKAGE_RELEASE "1")
  set (CPACK_RPM_COMPONENT_INSTALL ON)
  set (CPACK_RPM_PACKAGE_RELOCATABLE ON)
  set (CPACK_RPM_PACKAGE_GROUP "Development/Tools")
  set (CPACK_RPM_PACKAGE_LICENSE "BSD-style")
  set (CPACK_RPM_PACKAGE_URL "${H4H5_PACKAGE_URL}")
  set (CPACK_RPM_PRE_INSTALL_SCRIPT_FILE "/sbin/ldconfig")
  set (CPACK_RPM_PRE_UNINSTALL_SCRIPT_FILE "/sbin/ldconfig")
  set (CPACK_RPM_POST_INSTALL_SCRIPT_FILE "/sbin/ldconfig")
  set (CPACK_RPM_POST_UNINSTALL_SCRIPT_FILE "/sbin/ldconfig")
  set (CPACK_STRIP_FILES "${H4H5_LIBRARIES_TO_EXPORT};${H4H5_APPS_TO_EXPORT};${EXTERNAL_LIBRARY_LIST}")
endif ()

# By default, do not warn when built on machines using only VS Express:
if (NOT DEFINED CMAKE_INSTALL_SYSTEM_RUNTIME_LIBS_NO_WARNINGS)
  set (CMAKE_INSTALL_SYSTEM_RUNTIME_LIBS_NO_WARNINGS ON)
endif ()
include (InstallRequiredSystemLibraries)

set (CPACK_INSTALL_CMAKE_PROJECTS "${H4H5_BINARY_DIR};H4H5;ALL;/")

if (HDF_PACKAGE_EXTLIBS)
  if (HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
    if (HDF4_FOUND AND HDF4_USE_EXTERNAL)
      set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${HDF4_INCLUDE_DIR_GEN};HDF4;libraries;/")
      set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${HDF4_INCLUDE_DIR_GEN};HDF4;headers;/")
      set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${HDF4_INCLUDE_DIR_GEN};HDF4;configinstall;/")
      if (JPEG_USE_EXTERNAL)
        set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${JPEG_INCLUDE_DIR_GEN};jpeg;libraries;/")
        set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${JPEG_INCLUDE_DIR_GEN};jpeg;headers;/")
        set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${JPEG_INCLUDE_DIR_GEN};jpeg;configinstall;/")
      endif ()
      if (ZLIB_USE_EXTERNAL)
        set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${ZLIB_INCLUDE_DIR_GEN};zlib;libraries;/")
        set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${ZLIB_INCLUDE_DIR_GEN};zlib;headers;/")
        set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${ZLIB_INCLUDE_DIR_GEN};zlib;configinstall;/")
      endif ()
      if (SZIP_USE_EXTERNAL)
        set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${SZIP_INCLUDE_DIR_GEN};szip;libraries;/")
        set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${SZIP_INCLUDE_DIR_GEN};szip;headers;/")
        set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${SZIP_INCLUDE_DIR_GEN};szip;configinstall;/")
      endif ()
    endif ()
    if (HDF5_FOUND AND HDF5_USE_EXTERNAL)
      set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${HDF5_INCLUDE_DIR_GEN};HDF5;libraries;/")
      set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${HDF5_INCLUDE_DIR_GEN};HDF5;headers;/")
      set (CPACK_INSTALL_CMAKE_PROJECTS "${CPACK_INSTALL_CMAKE_PROJECTS};${HDF5_INCLUDE_DIR_GEN};HDF5;configinstall;/")
    endif ()
  endif ()
endif ()

include (CPack)

  cpack_add_install_type(Full DISPLAY_NAME "Everything")
  cpack_add_install_type(Developer)

  cpack_add_component_group(Runtime)

  cpack_add_component_group(Documents
      EXPANDED
      DESCRIPTION "Release notes for developing HDF applications"
  )

  cpack_add_component_group(Development
      EXPANDED
      DESCRIPTION "All of the tools you'll need to develop HDF applications"
  )

  cpack_add_component_group(Applications
      EXPANDED
      DESCRIPTION "Tools for HDF4 files"
  )

#-----------------------------------------------------------------------------
# Now list the cpack commands
#-----------------------------------------------------------------------------
cpack_add_component (applications
    DISPLAY_NAME "H4H5 Applications"
    DEPENDS libraries
    GROUP Applications
)
cpack_add_component (libraries
    DISPLAY_NAME "H4H5 Libraries"
    GROUP Runtime
)
cpack_add_component (headers
    DISPLAY_NAME "H4H5 Headers"
    DEPENDS libraries
    GROUP Development
)
cpack_add_component (hdfdocuments
    DISPLAY_NAME "H4H5 Documents"
    GROUP Documents
)
cpack_add_component (configinstall
    DISPLAY_NAME "H4H5 CMake files"
    DEPENDS libraries
    GROUP Development
)

if (HDF_BUILD_TOOLS)
  cpack_add_component (toolsapplications
      DISPLAY_NAME "H4H5 Tools Applications"
      DEPENDS libraries
      GROUP Applications
  )
endif ()
