
#-----------------------------------------------------------------------------
# Options for HDF Filters
#-----------------------------------------------------------------------------
set (HDF_ALLOW_EXTERNAL_SUPPORT "NO" CACHE STRING "Allow External Library Building (NO GIT TGZ)")
set_property (CACHE HDF_ALLOW_EXTERNAL_SUPPORT PROPERTY STRINGS NO GIT TGZ)
option (HDF4_USE_EXTERNAL "Use External Library Building for HDF4" 0)
option (HDF5_USE_EXTERNAL "Use External Library Building for HDF5" 0)
if (HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
  set (HDF4_USE_EXTERNAL 1 CACHE BOOL "Use External Library Building for HDF4" FORCE)
  set (HDF5_USE_EXTERNAL 1 CACHE BOOL "Use External Library Building for HDF5" FORCE)
  if (HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT")
    set (HDF4_URL ${HDF4_GIT_URL})
    set (HDF4_BRANCHL ${HDF4_GIT_BRANCH})
    set (HDF5_URL ${HDF5_GIT_URL})
    set (HDF5_BRANCH ${HDF5_GIT_BRANCH})
  elseif (HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
    if (NOT TGZPATH)
      set (TGZPATH ${H4H5_SOURCE_DIR})
    endif ()
    set (HDF4_URL ${TGZPATH}/${HDF4_TGZ_NAME})
    set (HDF5_URL ${TGZPATH}/${HDF5_TGZ_NAME})
  endif ()
endif ()

set (HDF4_LINK_LIBS ${LINK_LIBS})
set (HDF4_LINK_SHLIBS ${LINK_LIBS})
set (HDF5_LINK_LIBS ${LINK_LIBS})
set (HDF5_LINK_SHLIBS ${LINK_LIBS})

#-----------------------------------------------------------------------------
# HDF4 support
#-----------------------------------------------------------------------------
if (NOT BUILD_SHARED_LIBS)
  set (HDF4_USE_STATIC_LIBRARIES 1)
endif ()

HDF4_SUPPORT(true)

#-----------------------------------------------------------------------------
# HDF5 support
#-----------------------------------------------------------------------------
if (NOT BUILD_SHARED_LIBS)
  set (HDF5_USE_STATIC_LIBRARIES 1)
endif ()

HDF5_SUPPORT(true)

if (HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
  if (JPEG_FOUND)
    add_dependencies (${H4H5_HDF_LIB_TARGET} JPEG)
    if (HDF4_FOUND AND HDF4_USE_EXTERNAL)
      add_dependencies (HDF4 JPEG)
    endif ()
  endif ()
  if (ZLIB_FOUND)
    add_dependencies (${H4H5_HDF_LIB_TARGET} ZLIB)
    if (HDF4_FOUND AND HDF4_USE_EXTERNAL)
      add_dependencies (HDF4 ZLIB)
    endif ()
    if (HDF5_FOUND AND HDF5_USE_EXTERNAL)
      add_dependencies (HDF5 ZLIB)
    endif ()
  endif ()
  if (SZIP_FOUND)
    add_dependencies (${H4H5_HDF_LIB_TARGET} SZIP)
    if (HDF4_FOUND AND HDF4_USE_EXTERNAL)
      add_dependencies (HDF4 SZIP)
    endif ()
    if (HDF5_FOUND AND HDF5_USE_EXTERNAL)
      add_dependencies (HDF5 SZIP)
    endif ()
  endif ()
  if (HDF4_FOUND AND HDF4_USE_EXTERNAL)
    add_dependencies (${H4H5_HDF_LIB_TARGET} HDF4)
  endif ()
  if (HDF5_FOUND AND HDF5_USE_EXTERNAL)
    add_dependencies (${H4H5_HDF5_LIB_TARGET} HDF5)
  endif ()
endif ()

set (LINK_LIBS ${LINK_LIBS} ${HDF5_LINK_LIBS} ${HDF4_LINK_LIBS})
set (LINK_SHLIBS ${LINK_SHLIBS} ${HDF5_LINK_SHLIBS} ${HDF4_LINK_SHLIBS})
