#ifndef H5TOH4APICOMPITABLE_H
#define H5TOH4APICOMPITABLE_H

#if (H5_VERS_MAJOR == 1 && H5_VERS_MINOR == 6) || defined H5_USE_16_API

  	#define H5GOPEN(fd, name) H5Gopen(fd, name)
    #define H5DOPEN(fd, name) H5Dopen(fd, name)
    #define H5TARRAY_CREATE(tid, rank, dims, perm) H5Tarray_create(tid, rank, dims, perm)
    #define H5EGET_AUTO(func, data) H5Eget_auto(func, data)
    #define H5ESET_AUTO(func, data) H5Eset_auto(func, data)
    #define H5AITERATE(loc_id, idx, op, op_data) H5Aiterate(loc_id, (unsigned *)idx, (H5A_operator_t)op, op_data)
    #define H5TGET_ARRAY_DIMS(tid, dims, perm) H5Tget_array_dims(tid, dims, perm)

#else


    #define H5GOPEN(fd, name) H5Gopen2(fd, name, H5P_DEFAULT)
    #define H5DOPEN(fd, name) H5Dopen2(fd, name, H5P_DEFAULT)
    #define H5TARRAY_CREATE(tid, rank, dims, perm) H5Tarray_create2(tid, rank, dims)
    #define H5EGET_AUTO(func, data) H5Eget_auto2(H5E_DEFAULT, func, data)
    #define H5ESET_AUTO(func, data) H5Eset_auto2(H5E_DEFAULT, func, data)
    #define H5AITERATE(loc_id, idx, op, op_data) H5Aiterate1(loc_id,  (unsigned *)idx, (H5A_operator1_t)op, op_data)
    #define H5TGET_ARRAY_DIMS(tid, dims, perm) H5Tget_array_dims2(tid, dims)

#endif

#endif

