/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by  The HDF Group (THG) and                                     *
 *               The Board of Trustees of the University of Illinois.        *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,      *
 * including terms governing use, modification, and redistribution, is       *
 * contained in the files COPYING and Copyright.html.  COPYING can be found  *
 * at the root of the source code distribution tree; Copyright.html can be   *
 * found at the root level of an installed copy of the electronic H4H5TOOLS  *
 * document set and is linked from the top-level documents page.  It can     *
 * also be found at http://www.hdfgroup.org/H4H5TOOLS/doc/Copyright.html.    *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "h4toh5.h"

/* There are 12 test cases for h4toh5 library.*/
/* h4h5apitestdefault,
   h4h5apitestname,
   h4h5apitestimage,
   h4h5apitestimageattr,
   h4h5apitestsds,
   h4h5apitestsdsattr,
   h4h5apitestvdata,
   h4h5apitestvdataattr,
   h4h5apitestadvgroup,
   h4h5apitestbasvgroup,
   h4h5apitestloneimage,
   h4h5apitestlonesds,
   h4h5apitestlonevdata
   
   This file is h4h5apitestsds:

   1) will test various settings of the h4toh5 library SDS API.
  
*/

/*-------------------------------------------------------------------------
 * Function:	main
 *
 * Purpose:    
 *-------------------------------------------------------------------------
 */	

 
int main() {

  hid_t         h4toh5id;/* h4toh5 identifier.*/
  int32         sd_id;/* SD interface ID. */
  int32         sds_id;/* SDS interface ID. */
  int32         status;  /*temporary variable to check status of HDF4 APIs */
  int           h4toh5status;  /*temporary variable to check status of H4toH5 APIs */

   
   /** open SD interface **/
  sd_id   = SDstart("sds_lib_test.hdf",DFACC_READ);
  if(sd_id == FAIL) {
    printf("cannot start SD interface.\n");
    return FAIL;
  }

  if((h4toh5id= H4toH5open("sds_lib_test.hdf","sds_lib_test.h5",H425_CLOBBER)) < 0) {
    printf("cannot open h4toh5 interface\n");
    SDend(sd_id);
    return FAIL;
  }

  sds_id = SDselect(sd_id,0);
  if(sds_id == FAIL) {
    printf("cannot obtain SDS id.\n");
    SDend(sd_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }
  if(H4toH5sds(h4toh5id,sds_id,"/group1",NULL,NULL,1,1)<0) {
    printf("SDS conversion test failed\n");
    H4toH5error_get(h4toh5id);
    SDend(sd_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }

  status = SDendaccess(sds_id);
  if(status == FAIL) {
    printf("cannot close SDS interface. \n");
    SDend(sd_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }

  /* testing SDS conversion with user-defined parameters.*/
  sds_id = SDselect(sd_id,3);
  if(sds_id == FAIL) {
    printf("cannot obtain SDS id.\n");
    SDend(sd_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }
  if(H4toH5sds(h4toh5id,sds_id,"/group1","mysds","/mydimg",1,0)<0){
    printf("SDS conversion test failed\n");
    H4toH5error_get(h4toh5id);
    SDend(sd_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }
  status = SDendaccess(sds_id);
  if(status == FAIL) {
    printf("cannot close SDS interface.\n");
    SDend(sd_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }
  status = SDend(sd_id);
  if(status == FAIL) {
    printf("cannot close SD interface.\n");
    H4toH5close(h4toh5id);
    return FAIL;
  }
  h4toh5status = H4toH5close(h4toh5id);
  if(h4toh5status == FAIL){
    printf("cannot close h4toh5 interface.\n");
    return FAIL;
  }

  return 0;
}



