@echo off
rem
rem Copyright by  The HDF Group (THG) and
rem               The Board of Trustees of the University of Illinois.
rem All rights reserved.
rem
rem This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
rem including terms governing use, modification, and redistribution, is
rem contained in the files COPYING and Copyright.html.  COPYING can be found
rem at the root of the source code distribution tree; Copyright.html can be
rem found at the root level of an installed copy of the electronic H4H5TOOLS
rem document set and is linked from the top-level documents page.  It can
rem also be found at http://www.hdfgroup.org/H4H5TOOLS/doc/Copyright.html.
rem If you do not have access to either file, you may request a copy from
rem help@hdfgroup.org.
rem
rem
rem  File Name: testexamples.bat
rem  This batch file is used to test H4H5Tools examples.
rem  There are 3 options for this batch file:
rem    1. testexamples                -- Tests all example configurations
rem    1. testexamples debug          -- Tests example debug configuration
rem    1. testexamples release        -- Tests example release configuration
rem  Created: Scott Wegner,      9/20/07
rem  Last Updated: 5/27/08

setlocal enabledelayedexpansion
pushd %~dp0\lib\examples

rem Parse which configurations to use
if "%1"=="" (
    set test_configs=release debug
) else (
    set test_configs=%1
)

set rm=del /f

rem This is set inside h4toh5example.c
set outfile= sds_lib_test.h5

set nerrors=0
set verbose=yes

goto main


rem Print a line-line message left justified in a field of 70 characters
rem beginning with the word "Testing".
rem
:testing
    set test_msg=Testing
    for %%a in (%*) do (
        if %%a neq PASSED (
        if %%a neq *FAILED* (
            set test_msg=!test_msg! %%a
        ) )
    )
    set test_msg=!test_msg!                                                                
    echo.%test_msg:~0,69% %1
    
    exit /b

    
rem Run a test and print PASS or *FAIL*.  If a test fails then increment
rem the `nerrors' global variable.  The actual output is not removed if 
rem %H4H5_NOCLEANUP% has a non-zero value.
rem
:test_example
    
    if not exist %1 (
        call :testing *FAILED* %1
        echo.   Could not find %1
        set /a nerrors=!nerrors!+1
    ) else (
    
        rem Run our test
        %CD%\%1
        
        if !errorlevel! equ 0 (
            call :testing PASSED %1
        ) else (
            call :testing *FAILED* %1
            set /a nerrors=!nerrors!+1
        )
        
        rem Cleanup our output
        if not defined h4h5_nocleanup (
            %rm% %outfile% > nul
        )
    )
    exit /b

    
rem ############################################################################
rem #                       T H E   T E S T S                                ###
rem ############################################################################
rem ############################################################################

:main

    for %%a in (%test_configs%) do (
        call :test_example %%a\h4toh5example
    )
    
    
    if "%nerrors%"=="0" (
        echo.All h4toh5 example tests passed.
    )
    
    
:end
    popd
    endlocal & exit /b %nerrors%
    
