@echo off
rem
rem Copyright by  The HDF Group (THG) and
rem               The Board of Trustees of the University of Illinois.
rem All rights reserved.
rem
rem This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
rem including terms governing use, modification, and redistribution, is
rem contained in the files COPYING and Copyright.html.  COPYING can be found
rem at the root of the source code distribution tree; Copyright.html can be
rem found at the root level of an installed copy of the electronic H4H5TOOLS
rem document set and is linked from the top-level documents page.  It can
rem also be found at http://www.hdfgroup.org/H4H5TOOLS/doc/Copyright.html.
rem If you do not have access to either file, you may request a copy from
rem help@hdfgroup.org.
rem
rem
rem  File Name: h4h5check.bat
rem  This batch file is used to test H4H5Tools Libraries and Tools.
rem  There are 2 options for this batch file:
rem    h4h5check                -- Tests h4h5 library and tools
rem    h4h5check enableeos      -- Tests h4h5 library and tools with hdfeos support
rem              nodebug        -- can be added to not test debug versions

setlocal enabledelayedexpansion
pushd %~dp0
set chkdebug=debug
set chkrelease=release
set h4h5_eos_conditional=

rem Clean any variables starting with "H4H5_TEST_", as we use these for our
rem tests.  Also clear "H4H5_TEST_TESTS", as we will be addding all of our tests
rem to this variable.
rem Set at least one variable in set beforehand to avoid error message.
rem --SJW 9/5/07
set h4h5_test_=foo
for /f "tokens=1 delims==" %%a in ('set h4h5_test_') do set %%a=
set h4h5_test_tests=

rem See if we should test with eos support
if "%1"=="/?" (
    goto help
) else if "%1"=="enableeos" (
    set h4h5_eos_conditional=true
) else if /i "%1" equ "nodebug" (
    set chkdebug=
) else if not "%1"=="" (
    call :help
    exit /b 1
)

if /i "%2" equ "nodebug" (
    set chkdebug=
)

set nerrors=0

goto main


rem Print a help message, then exist
:help
    echo.h4h5check [enableeos or nodebug]
    echo.h4h5check                -- Tests h4h5 library and tools
    echo.h4h5check enableeos      -- Tests h4h5 library and tools with hdfeos support
    echo.          nodebug        -- can be added to not test debug versions
    exit /b 0


rem Function to add a test to the test suite.  
rem Expects the following parameters:
rem     %1 - Name of the test being tested
rem     %2 - Relative path of script
:add_test

    set h4h5_test_tests=%h4h5_test_tests% %1
    set h4h5_test_%1_test=%CD%\%2\%1

    exit /b
    

rem Run all of the tests that have been added to the suite.  Print a header
rem at the beginning of each one.  Short-circuit if a test fails.
rem Expects the following parameters:
rem     %1 - release or debug version
:run_tests
    for %%a in (%h4h5_test_tests%) do (
        echo.
        echo.************************************
        echo.  Testing %%a ^(%1^)
        echo.************************************
        
        rem Only add our parameters for batch scripts.
        call !h4h5_test_%%a_test:.bat= %1!
        rem Exit early if test fails.
        if !errorlevel! neq 0 exit /b
    )
    
    rem If we get here, that means all of our tests passed.
    echo.All H4H5 %* tests passed.

    exit /b


rem This is where we add tests to the suite, and run them all at the end.
rem Also make sure to add *.bat to batch scripts, as the above functions rely
rem on it for sending parameters.  --SJW 9/6/07
:main

    rem Library tests
    call :add_test testh4toh5.bat .\lib\test
    
    rem Util tests
    call :add_test testh4toh5.bat .\utils\h4toh5
    call :add_test testh5toh4.bat .\utils\h5toh4

    
    rem Note: we don't build dll versions of h4h5, so we don't need to iterate
    rem over them.
    for %%a in (%chkdebug% %chkrelease%) do (
        call :run_tests %%a
        if !errorlevel! neq 0 (
            set /a nerrors=!nerrors!+1
        )
    )
    
    if %nerrors% equ 0 (
        echo.All H4H5 Tests passed!
    )
    
    popd
    endlocal & exit /b %nerrors%
    
