rem
rem  Copyright by The HDF Group (THG).
rem  All rights reserved.
rem 
rem  This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
rem  including terms governing use, modification, and redistribution, is
rem  contained in the files COPYING and Copyright.html. COPYING can be
rem  found at the root of the source code distribution tree; Copyright.html
rem  can be found at the root level of an installed copy of the electronic
rem  H4H5TOOLS document set and is linked from the top-level documents page.
rem  It can also be found at
rem  http://www.hdfgroup.org/H4H5TOOLS/doc/Copyright.html. If you do not have
rem  access to either file, you may request a copy from help@hdfgroup.org.
rem

@echo off
setlocal enabledelayedexpansion

set VERIFY=h:\svn\h4h5tools\windows\proj\debug\verifier.exe

set SRCDIR=H:\svn\h4h5tools\utils\testfiles
set OUTDIR=H:\svn\h4h5tools\utils\testfiles\Expected

set /a nerrors=0

goto main

:convert
  set infiles=%2
  set outfiles=%3
  set verify_opt=-p -v
rem  set verify_opt=-v

  if "%1"=="-e" (
    %VERIFY% %verify_opt% %SRCDIR%\%infiles% %OUTDIR%\%outfiles%
    if !errorlevel! neq 0 (
      echo. FAILED
      set /a nerrors=!nerrors!+1
    ) else (
      echo. PASSED
    )
  ) else if "%1"=="-f" (
    echo. SKIP
  ) else if "%1"=="-g" (
    echo. SKIP
  )
  exit /b

:verify_one
  call :convert -e grid/grid_geo_timexy.hdf grid/grid_geo_timexy.h5
  exit /b

:verify_grid
  call :convert -e grid/generic_type_grid.hdf grid/generic_type_grid.h5
  call :convert -e grid/grid_badname.hdf grid/grid_badname.h5
  call :convert -e grid/grid_geo_xy.hdf grid/grid_geo_xy.h5
  call :convert -e grid/grid_geo_yx.hdf grid/grid_geo_yx.h5
  call :convert -e grid/grid_geo_timexy.hdf grid/grid_geo_timexy.h5
  call :convert -e grid/grid_geo_timeyx.hdf grid/grid_geo_timeyx.h5
  call :convert -e grid/grid_utm_xy.hdf grid/grid_utm_xy.h5
  call :convert -e grid/grid_utm_yx.hdf grid/grid_utm_yx.h5
  call :convert -e grid/grid_utm_timexy.hdf grid/grid_utm_timexy.h5
  call :convert -e grid/grid_utm_timeyx.hdf grid/grid_utm_timeyx.h5
  call :convert -e grid/grid_geo_xyxy.hdf grid/grid_geo_xyxy.h5
  call :convert -e grid/grid_geo_yxyx.hdf grid/grid_geo_yxyx.h5
  call :convert -f grid/grid_geo_xyyx.hdf grid/grid_geo_xyyx.h5
  call :convert -g grid/grid_geo_nil.hdf grid/grid_geo_nil.h5
  call :convert -e grid/grid_utm_xyxy.hdf grid/grid_utm_xyxy.h5
  call :convert -e grid/grid_utm_yxyx.hdf grid/grid_utm_yxyx.h5
  call :convert -f grid/grid_utm_xyyx.hdf grid/grid_utm_xyyx.h5
  call :convert -g grid/grid_utm_nil.hdf grid/grid_utm_nil.h5
  exit /b

:verify_swath
  call :convert -e swath/generic_type_swath.hdf swath/generic_type_swath.h5
  call :convert -e swath/swath_badname.hdf swath/swath_badname.h5
  call :convert -e swath/swath_basic.hdf swath/swath_basic.h5
  call :convert -e swath/swath_0101.hdf swath/swath_0101.h5
  call :convert -e swath/swath_1111.hdf swath/swath_1111.h5
  call :convert -e swath/swath_2121.hdf swath/swath_2121.h5
  call :convert -e swath/swath_n11n11.hdf swath/swath_n11n11.h5
  call :convert -e swath/swath_n11n11_tight.hdf swath/swath_n11n11_tight.h5
  call :convert -e swath/swath_n21n21.hdf swath/swath_n21n21.h5
  call :convert -e swath/swath_0202.hdf swath/swath_0202.h5
  call :convert -e swath/swath_1212.hdf swath/swath_1212.h5
  call :convert -e swath/swath_2222.hdf swath/swath_2222.h5
  call :convert -e swath/swath_n12n12.hdf swath/swath_n12n12.h5
  call :convert -e swath/swath_n22n22.hdf swath/swath_n22n22.h5
  call :convert -e swath/swath_0n20n2.hdf swath/swath_0n20n2.h5
  call :convert -e swath/swath_1n21n2.hdf swath/swath_1n21n2.h5
  call :convert -e swath/swath_2n22n2.hdf swath/swath_2n22n2.h5
  call :convert -e swath/swath_n1n2n1n2.hdf swath/swath_n1n2n1n2.h5
  call :convert -e swath/swath_n2n2n2n2.hdf swath/swath_n2n2n2n2.h5
  call :convert -e swath/swath_qdd.hdf swath/swath_qdd.h5
  call :convert -e swath/swath_dqd.hdf swath/swath_dqd.h5
  call :convert -e swath/swath_ddq.hdf swath/swath_ddq.h5
  call :convert -e swath/swath_qgg.hdf swath/swath_qgg.h5
  call :convert -e swath/swath_gqg.hdf swath/swath_gqg.h5
  call :convert -e swath/swath_ggq.hdf swath/swath_ggq.h5
  call :convert -e swath/swath_tll.hdf swath/swath_tll.h5
  call :convert -e swath/swath_tll02.hdf swath/swath_tll02.h5
  exit /b

:main
  call :verify_grid
  call :verify_swath

  if "%nerrors%"=="0" (
    echo.All h4toh5 tests passed
  ) else (
    echo.FAILED %nerrors%
  )

rem vim:ts=8:sts=2:sw=2:et
