#!/bin/bash
#
#  Copyright by The HDF Group (THG).
#  All rights reserved.
# 
#  This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
#  including terms governing use, modification, and redistribution, is
#  contained in the files COPYING and Copyright.html. COPYING can be
#  found at the root of the source code distribution tree; Copyright.html
#  can be found at the root level of an installed copy of the electronic
#  H4H5TOOLS document set and is linked from the top-level documents page.
#  It can also be found at
#  http://www.hdfgroup.org/H4H5TOOLS/doc/Copyright.html. If you do not have
#  access to either file, you may request a copy from help@hdfgroup.org.
#


H4TOH5=h4toh5
H4TOH5_BIN=/mnt/scr1/clee83/sysdep/jam/h4h5tools/utils/h4toh5/$H4TOH5

# The build (current) directory might be different than the source directory.
if test -z "$srcdir"; then
  srcdir=.
fi

SRCDIR=/mnt/web/internal/ESDIS_files/datapool/abridged
OUTDIR=/mnt/web/internal/ESDIS_files/converted/abridged

nerrors=0

convert() {
  partialpath=`dirname "$3"`

  inputfilename=`basename "$3"`
  inputdir=$SRCDIR/$partialpath
  inpath=$inputdir/$inputfilename

  outputfilename=${inputfilename}.h5
  outputdir=$2/$partialpath
  outpath=$outputdir/$outputfilename

  test -d "$outputdir" || mkdir -p "$outputdir"

  h4toh5option="$1"
  if 'time' $H4TOH5_BIN $h4toh5option "$inpath" "$outpath" ; then
    echo "PASSED $h4toh5option, $inpath -> $outpath"
  else
    echo "FAILED $h4toh5option, $inpath -> $outpath"
    nerrors="`expr $nerrors + 1`"
  fi
}

CONVERT_DEFAULT() {
  convert "" $OUTDIR/default "$1"
}
CONVERT_LATEST() {
  convert "-latest" $OUTDIR/latest "$1"
}

convert_files_default() {
  CONVERT_DEFAULT HDF4/GES-DISC/AIRG2SSD/AIRS.2002.08.31.L2G.Precip_Est.v1.0.1.0.G07289211402.hdf
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_1B51_DARW/1B51.971201.1.DARW.1.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_2A53_CSI_DARW/2A53_CSI.971128.13.DARW.1.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_2A54_CSI_GUAM/2A54_CSI.971208.10.GUAM.3.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_2A55_CSI_HSTN/2A55_CSI.971128.10.HSTN.1.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_3A53_KWAJ/3A53.971101.KWAJ.1.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_3A54_MELB/3A54.971101.MELB.1.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_1B01_CSI_ADLD/1B01_CSI.971221.375.ADLD.6.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_1B11/1B11.971208.160.6.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_1B21_CSI_ADLD/1B21_CSI.971208.162.ADLD.6.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_1C21_CSI_ADLD/1C21_CSI.971208.162.ADLD.6.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_2A12/2A12.971208.160.6.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_2A21/2A21.971208.160.6.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_2A23/2A23.971208.160.6.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_2A25/2A25.971208.160.6.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_2B31/2B31.971208.160.6.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_3A46/3A46.980101.2.HDF
  CONVERT_DEFAULT HDF4/GES-DISC/TRMM_3B42/3B42.980101.0.6.HDF
  CONVERT_DEFAULT HDF4/GHRC/UNKNOWN/f14_clwa_06118_dayAD.hdf
  CONVERT_DEFAULT HDF4/GHRC/UNKNOWN/f14_owsa_06118_28D.hdf
  CONVERT_DEFAULT HDF4/GHRC/UNKNOWN/f14_Tb_06118_28D.hdf
  CONVERT_DEFAULT HDF4/GHRC/UNKNOWN/f15_iwva_07030_28A.hdf
  CONVERT_DEFAULT HDF4/GHRC/UNKNOWN/f15_owsa_07030_28A.hdf
  CONVERT_DEFAULT HDF4/GES-DISC/MODVI/MODVI.200002.005.hdf
  CONVERT_DEFAULT HDF4/GES-DISC/MYDVI/MYDVI.200207.005.hdf
  CONVERT_DEFAULT HDF4/PODAAC/UNKNOWN/am08mi87.305_mon.L3Pfndr.hdf
  CONVERT_DEFAULT HDF4/PODAAC/UNKNOWN/S1701254.HDF
  CONVERT_DEFAULT HDF4/PODAAC/UNKNOWN/atlas.ssmi.ver10.level3.0.sep1987.hdf
  CONVERT_DEFAULT HDF4/PODAAC/UNKNOWN/ws08mi87.336_browse.hdf
  CONVERT_DEFAULT HDF4/PODAAC/UNKNOWN/200046h09ea-adm.hdf
  CONVERT_DEFAULT HDF4/LP-DAAC/MYD14/MYD14.A2002185.0000.005.2007160111316.hdf
  CONVERT_DEFAULT HDF4/LaRC/ACR3L2DM/ACR3L2DM000405_20050408.HDF
}

#convert_files_latest() {
#}

convert_files_default
#convert_files_latest

if test $nerrors -eq 0 ; then
  echo "All files were generated."
else
  echo "FAILED: # failures " $nerrors
fi
exit $nerrors

# vim:ts=8:sts=2:sw=2:et
