#!/bin/bash
#
#  Copyright by The HDF Group (THG).
#  All rights reserved.
# 
#  This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
#  including terms governing use, modification, and redistribution, is
#  contained in the files COPYING and Copyright.html. COPYING can be
#  found at the root of the source code distribution tree; Copyright.html
#  can be found at the root level of an installed copy of the electronic
#  H4H5TOOLS document set and is linked from the top-level documents page.
#  It can also be found at
#  http://www.hdfgroup.org/H4H5TOOLS/doc/Copyright.html. If you do not have
#  access to either file, you may request a copy from help@hdfgroup.org.
#


H4TOH5=h4toh5
H4TOH5_BIN=/mnt/scr1/clee83/sysdep/jam/h4h5tools/utils/h4toh5/$H4TOH5

# The build (current) directory might be different than the source directory.
if test -z "$srcdir"; then
  srcdir=.
fi

SRCDIR=/mnt/web/internal/ESDIS_files/datapool/abridged
OUTDIR=/mnt/web/internal/ESDIS_files/converted/abridged

nerrors=0

convert() {
  partialpath=`dirname "$3"`

  inputfilename=`basename "$3"`
  inputdir=$SRCDIR/$partialpath
  inpath=$inputdir/$inputfilename

  outputfilename=${inputfilename}.h5
  outputdir=$2/$partialpath
  outpath=$outputdir/$outputfilename

  test -d "$outputdir" || mkdir -p "$outputdir"

  h4toh5option="$1"
  if 'time' $H4TOH5_BIN $h4toh5option "$inpath" "$outpath" ; then
    echo "PASSED $h4toh5option, $inpath -> $outpath"
  else
    echo "FAILED $h4toh5option, $inpath -> $outpath"
    nerrors="`expr $nerrors + 1`"
  fi
}

CONVERT_STRICT() {
  convert "-eos -nc4strict" $OUTDIR/strict "$1"
}
CONVERT_FAKEDIM() {
  convert "-eos -nc4strict -nc4fakedim" $OUTDIR/fakedim "$1"
}

CONVERT_DEFAULT() {
  convert "" $OUTDIR/default "$1"
}

convert_files() {
  CONVERT_STRICT "HDFEOS2/GES-DISC/AIRH3ST8/AIRS.2002.08.24.L3.RetStd_H008.v4.0.21.0.G06104133343.hdf"
  CONVERT_STRICT "HDFEOS2/GES-DISC/AIRS3ST8/AIRS.2007.06.03.L3.RetStd_IR008.v5.0.14.0.G07261123909.hdf"
  CONVERT_STRICT "HDFEOS2/GES-DISC/OMUVBL3/OMI-Aura_L3-OMUVBL3_2004m0817_v002.HDF"
  CONVERT_STRICT "HDFEOS2/GES-DISC/AIRABRAD/AIRS.2002.12.31.240.L1B.AMSU_Rad.v5.0.0.0.G07073103215.hdf"
  CONVERT_STRICT "HDFEOS2/GES-DISC/AIRHBRAD/AIRS.2002.12.31.240.L1B.HSB_Rad.v5.0.0.0.G07073103225.hdf"
# This following file causes buffer overrun.
##  CONVERT_STRICT "HDFEOS2/GES-DISC/MAC021S0/MAC021S0.A2006153.0000.002.2007098161727.hdf"
#  CONVERT_STRICT "HDFEOS2/GES-DISC/MAC03S0/MAC03S0.A2006153.0000.002.2007098161727.hdf"
#  CONVERT_STRICT "HDFEOS2/GES-DISC/MAC05S0/MAC05S0.A2006153.0000.002.2007098162108.hdf"
  CONVERT_STRICT "HDFEOS2/GHRC/NOAA-15 AMSU/amsua15_1999.152_05465_2244_0027_WI.eos"
  CONVERT_STRICT "HDFEOS2/GHRC/NOAA-16 AMSU/amsua16_2001.147_03505_2246_0033_GC.eos"
  CONVERT_STRICT "HDFEOS2/GHRC/NOAA-17 AMSU/amsua17_2003.007_02805_2302_0046_GC.eos"
  CONVERT_STRICT "HDFEOS2/GHRC/UNKNOWN/tmi_L2c_2006.259_50360_v04.eos"
#  CONVERT_STRICT "HDFEOS2/LP-DAAC/AST_L1B/AST_L1B_00305292006080906_20060604094034_7323.hdf"
#  CONVERT_STRICT "HDFEOS2/LP-DAAC/MYD09A1/MYD09A1.A2002185.h00v08.005.2007175015530.hdf"
  CONVERT_STRICT "HDFEOS2/LP-DAAC/MYD09GQ/MYD09GQ.A2008064.h11v10.005.2008067095716.hdf"
  CONVERT_STRICT "HDFEOS2/LP-DAAC/MYD11A1/MYD11A1.A2003184.h00v08.005.2007333141053.hdf"
  CONVERT_STRICT "HDFEOS2/LP-DAAC/MYD13A1/MYD13A1.A2002185.h00v08.005.2007178164946.hdf"
  CONVERT_STRICT "HDFEOS2/LP-DAAC/MYD15A2/MYD15A2.A2002185.h00v08.005.2007175021713.hdf"
  CONVERT_STRICT "HDFEOS2/LP-DAAC/MYD17A2/MYD17A2.A2002185.h00v08.005.2007182013352.hdf"
  CONVERT_STRICT "HDFEOS2/LP-DAAC/MOD15A2/MOD15A2.A2000049.h00v08.005.2006268222954.hdf"
  CONVERT_STRICT "HDFEOS2/LP-DAAC/MOD17A2/MOD17A2.A2000049.h00v08.005.2006333231256.hdf"
  CONVERT_STRICT "HDFEOS2/LP-DAAC/MCD43A1/MCD43A1.A2000049.h00v08.005.2006269203518.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/ATSM2LSF/MISR_LAND_FIRSTLOOK_P068_O044103_F07_0022_ATS_b32-38.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/ATSMIGEO/MISR_GMP_P068_O044103_F03_0013_ATS_b32-38.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/CMRMIGEO/MISR_GMP_P190_O025325_F03_0012_CMR_b62.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/GOMI2LS/MISR_LAND_P024_O035188_F06_0019_GOM_b64-72.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/GOMIB2E/MISR_ELLIPSOID_GM_P024_O035188_AA_F03_0024_GOM_b64-72.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/CARMIAAE/MISR_AEROSOL_P026_O005102_F07_0015_ICARTT_b47-57.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/IXBMI2AE/MISR_AEROSOL_P016_O032974_F09_0019_IXB_b64-77.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/IXBMIB2E/MISR_ELLIPSOID_GM_P016_O032974_AA_F03_0024_IXB_b64-77.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MB2LME/MISR_AM1_GRP_ELLIPSOID_LM_P025_O001039_DA_SITE_TROUTLAKE_F03_0024.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MI1B2E/MISR_AM1_GRP_ELLIPSOID_GM_P023_O002932_AA_F03_0023.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MI1B2E/MISR_AM1_GRP_ELLIPSOID_GM_P052_O000997_AA_F03_0024.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MI1B2T/MISR_AM1_GRP_TERRAIN_GM_P060_O002978_CA_F03_0023.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MI1B2T/MISR_AM1_GRP_TERRAIN_GM_P052_O000997_AA_F03_0024.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MI3DAEF/MISR_AM1_CGAS_FIRSTLOOK_AUG_30_2007_F11_0027.hdf"
# The following file causes GDij2ll() failure
##  CONVERT_STRICT "HDFEOS2/LaRC/MI3DAER/MISR_AM1_CGAS_MAR_01_2006_SITE_INTEXB_F06_0021.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MIL2TCAL/MISR_AM1_TC_ALBEDO_P020_O000995_F05_0011.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MIL2TCCL/MISR_AM1_TC_CLASSIFIERS_P020_O000995_F06_0011.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MIL3DAE/MISR_AM1_CGAS_FEB_25_2000_F15_0031.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MIL3DAL/MISR_AM1_CGAL_FEB_25_2000_F06_0024.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MIL3DCLD/MISR_AM1_CGCL_FEB_25_2000_F02_0024.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MIL3DLS/MISR_AM1_CGLS_FEB_25_2000_F04_0031.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MIRCCM/MISR_AM1_GRP_RCCM_GM_P026_O014189_DA_F03_0022.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MIRCCM/MISR_AM1_GRP_RCCM_GM_P020_O000995_AA_F04_0025.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MIRCCMF/MISR_AM1_GRP_RCCM_FIRSTLOOK_GM_P191_O040339_AA_F04_0025.hdf"
  CONVERT_STRICT "HDFEOS2/LaRC/MOP02/MOP02-20000303-L2V5.7.1.val.hdf"
  CONVERT_STRICT "HDFEOS2/LaRC/MOP03/MOP03-20000303-L3V1.0.1.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/SAMMI2AE/MISR_AEROSOL_P200_O034034_F09_0019_SAM_b57-71.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/SAMMIB2E/MISR_ELLIPSOID_GM_P200_O034034_AA_F03_0024_SAM_b57-71.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/UAEM1LME/MISR_ELLIPSOID_LM_P160_O024595_AA_SITE_ALDHAFRA_F03_0022.conv.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/UAEMIB2E/MISR_ELLIPSOID_GM_P160_O024129_AA_F03_0024_UAE_b68-74.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/UAEMIRCM/MISR_RCCM_GM_P160_O024595_AA_F03_0022_UAE_b68-74.conv.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/UAEMITAL/MISR_ALBEDO_P160_O024129_F04_0008_UAE_b68-74.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/UAEMRDAE/MISR_AM1_CGAS_JUL_01_2004_SITE_UAE_F02_0012.hdf"
#  CONVERT_STRICT "HDFEOS2/LaRC/MI1B2E/MISR_AM1_GRP_ELLIPSOID_GM_P005_O005290_AN_F01_0008.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_5DSno/AMSR_E_L3_5DaySnow_B02_20040705.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_5DSno/AMSR_E_L3_5DaySnow_T08_20020620.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_DyOcn/AMSR_E_L3_DailyOcean_B02_20070706.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_DyOcn/AMSR_E_L3_DailyOcean_V03_20020619.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_DySno/AMSR_E_L3_DailySnow_B02_20020619.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_DySno/AMSR_E_L3_DailySnow_T08_20020619.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_L2A/AMSR_E_L2A_BrightnessTemperatures_V09_200206190029_D.hdf"
# The following two files are POINT files that the current h4toh5 cannot handle.
##  CONVERT_STRICT "HDFEOS2/NSIDC/AE_Land/AMSR_E_L2_Land_B04_200206182340_A.hdf"
##  CONVERT_STRICT "HDFEOS2/NSIDC/AE_Land/AMSR_E_L2_Land_T07_200206190029_D.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_Land3/AMSR_E_L3_DailyLand_B03_20020618.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_Land3/AMSR_E_L3_DailyLand_T05_20020619.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_MoOcn/AMSR_E_L3_MonthlyOcean_B02_200707.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_MoOcn/AMSR_E_L3_MonthlyOcean_V03_200206.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_MoSno/AMSR_E_L3_MonthlySnow_B07_200603.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_MoSno/AMSR_E_L3_MonthlySnow_T08_200206.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_Ocean/AMSR_E_L2_Ocean_B01_200206182340_A.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_Ocean/AMSR_E_L2_Ocean_V06_200206190029_D.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_Rain/AMSR_E_L2_Rain_B02_200206182340_A.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_Rain/AMSR_E_L2_Rain_V10_200206190029_D.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_RnGd/AMSR_E_L3_RainGrid_B05_200707.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_RnGd/AMSR_E_L3_RainGrid_V06_200206.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_SI12/AMSR_E_L3_SeaIce12km_B02_20020618.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_SI12/AMSR_E_L3_SeaIce12km_T08_20020619.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_WkOcn/AMSR_E_L3_WeeklyOcean_B02_20070701.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/AE_WkOcn/AMSR_E_L3_WeeklyOcean_V03_20020616.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MYD10A1/MYD10A1.A2006200.h10v08.004.2006210171342.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MYD10A1/MYD10A1.A2002185.h00v08.005.2007162002108.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MYD10_L2/MYD10_L2.A2006197.0315.004.2006206002033.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MYD29/MYD29.A2006197.0300.004.2006206001839.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MYD29/MYD29.A2002185.0000.005.2007160150627.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MYD29E1D/MYD29E1D.A2002185.005.2007161103323.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MYD29P1D/MYD29P1D.A2006202.h08v08.004.2006210172007.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MYD29P1D/MYD29P1D.A2002185.h03v08.005.2007161002144.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MOD10A1/MOD10A1.A2000055.h00v08.004.2002355191010.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MOD10A1/MOD10A1.A2000065.h00v08.005.2008237034422.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MOD10_L2/MOD10_L2.A2000136.0235.004.2003009030119.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MOD10_L2/MOD10_L2.A2000065.0040.005.2008235221207.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MOD29/MOD29.A2000136.0040.004.2003009030013.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MOD29E1D/MOD29E1D.A2000055.005.2006268025009.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/MOD29P1D/MOD29P1D.A2000131.h08v08.004.2003008210353.hdf"
  CONVERT_STRICT "HDFEOS2/NSIDC/NISE/NISE_SSMIF13_20000101.HDFEOS"
}
convert_files_with_fakedim() {
# The following file causes name clash while handling 'Scan Type'
##  CONVERT_FAKEDIM "HDFEOS2/GES-DISC/MAC03S0/MAC03S0.A2006153.0000.002.2007098161727.hdf"
  CONVERT_FAKEDIM "HDFEOS2/GES-DISC/MAC05S0/MAC05S0.A2006153.0000.002.2007098162108.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LP-DAAC/AST_L1B/AST_L1B_00305292006080906_20060604094034_7323.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LP-DAAC/MYD09A1/MYD09A1.A2002185.h00v08.005.2007175015530.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/ATSM2LSF/MISR_LAND_FIRSTLOOK_P068_O044103_F07_0022_ATS_b32-38.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/ATSMIGEO/MISR_GMP_P068_O044103_F03_0013_ATS_b32-38.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/CMRMIGEO/MISR_GMP_P190_O025325_F03_0012_CMR_b62.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/GOMI2LS/MISR_LAND_P024_O035188_F06_0019_GOM_b64-72.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/GOMIB2E/MISR_ELLIPSOID_GM_P024_O035188_AA_F03_0024_GOM_b64-72.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/CARMIAAE/MISR_AEROSOL_P026_O005102_F07_0015_ICARTT_b47-57.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/IXBMI2AE/MISR_AEROSOL_P016_O032974_F09_0019_IXB_b64-77.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/IXBMIB2E/MISR_ELLIPSOID_GM_P016_O032974_AA_F03_0024_IXB_b64-77.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MB2LME/MISR_AM1_GRP_ELLIPSOID_LM_P025_O001039_DA_SITE_TROUTLAKE_F03_0024.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MI1B2E/MISR_AM1_GRP_ELLIPSOID_GM_P023_O002932_AA_F03_0023.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MI1B2E/MISR_AM1_GRP_ELLIPSOID_GM_P052_O000997_AA_F03_0024.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MI1B2T/MISR_AM1_GRP_TERRAIN_GM_P060_O002978_CA_F03_0023.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MI1B2T/MISR_AM1_GRP_TERRAIN_GM_P052_O000997_AA_F03_0024.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MI3DAEF/MISR_AM1_CGAS_FIRSTLOOK_AUG_30_2007_F11_0027.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MIL2TCAL/MISR_AM1_TC_ALBEDO_P020_O000995_F05_0011.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MIL2TCCL/MISR_AM1_TC_CLASSIFIERS_P020_O000995_F06_0011.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MIL3DAE/MISR_AM1_CGAS_FEB_25_2000_F15_0031.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MIL3DAL/MISR_AM1_CGAL_FEB_25_2000_F06_0024.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MIL3DCLD/MISR_AM1_CGCL_FEB_25_2000_F02_0024.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MIL3DLS/MISR_AM1_CGLS_FEB_25_2000_F04_0031.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MIRCCM/MISR_AM1_GRP_RCCM_GM_P026_O014189_DA_F03_0022.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MIRCCM/MISR_AM1_GRP_RCCM_GM_P020_O000995_AA_F04_0025.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MIRCCMF/MISR_AM1_GRP_RCCM_FIRSTLOOK_GM_P191_O040339_AA_F04_0025.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/SAMMI2AE/MISR_AEROSOL_P200_O034034_F09_0019_SAM_b57-71.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/SAMMIB2E/MISR_ELLIPSOID_GM_P200_O034034_AA_F03_0024_SAM_b57-71.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/UAEM1LME/MISR_ELLIPSOID_LM_P160_O024595_AA_SITE_ALDHAFRA_F03_0022.conv.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/UAEMIB2E/MISR_ELLIPSOID_GM_P160_O024129_AA_F03_0024_UAE_b68-74.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/UAEMIRCM/MISR_RCCM_GM_P160_O024595_AA_F03_0022_UAE_b68-74.conv.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/UAEMITAL/MISR_ALBEDO_P160_O024129_F04_0008_UAE_b68-74.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/UAEMRDAE/MISR_AM1_CGAS_JUL_01_2004_SITE_UAE_F02_0012.hdf"
  CONVERT_FAKEDIM "HDFEOS2/LaRC/MI1B2E/MISR_AM1_GRP_ELLIPSOID_GM_P005_O005290_AN_F01_0008.hdf"
}

convert_files_default() {
  CONVERT_DEFAULT "HDFEOS2/GES-DISC/AIRH3ST8/AIRS.2002.08.24.L3.RetStd_H008.v4.0.21.0.G06104133343.hdf"
  CONVERT_DEFAULT "HDFEOS2/GES-DISC/AIRS3ST8/AIRS.2007.06.03.L3.RetStd_IR008.v5.0.14.0.G07261123909.hdf"
  CONVERT_DEFAULT "HDFEOS2/GES-DISC/OMUVBL3/OMI-Aura_L3-OMUVBL3_2004m0817_v002.HDF"
  CONVERT_DEFAULT "HDFEOS2/GES-DISC/AIRABRAD/AIRS.2002.12.31.240.L1B.AMSU_Rad.v5.0.0.0.G07073103215.hdf"
  CONVERT_DEFAULT "HDFEOS2/GES-DISC/AIRHBRAD/AIRS.2002.12.31.240.L1B.HSB_Rad.v5.0.0.0.G07073103225.hdf"
  CONVERT_DEFAULT "HDFEOS2/GES-DISC/MAC021S0/MAC021S0.A2006153.0000.002.2007098161727.hdf"
  CONVERT_DEFAULT "HDFEOS2/GES-DISC/MAC03S0/MAC03S0.A2006153.0000.002.2007098161727.hdf"
  CONVERT_DEFAULT "HDFEOS2/GES-DISC/MAC05S0/MAC05S0.A2006153.0000.002.2007098162108.hdf"
  CONVERT_DEFAULT "HDFEOS2/GHRC/NOAA-15 AMSU/amsua15_1999.152_05465_2244_0027_WI.eos"
  CONVERT_DEFAULT "HDFEOS2/GHRC/NOAA-16 AMSU/amsua16_2001.147_03505_2246_0033_GC.eos"
  CONVERT_DEFAULT "HDFEOS2/GHRC/NOAA-17 AMSU/amsua17_2003.007_02805_2302_0046_GC.eos"
  CONVERT_DEFAULT "HDFEOS2/GHRC/UNKNOWN/tmi_L2c_2006.259_50360_v04.eos"
  CONVERT_DEFAULT "HDFEOS2/LP-DAAC/AST_L1B/AST_L1B_00305292006080906_20060604094034_7323.hdf"
  CONVERT_DEFAULT "HDFEOS2/LP-DAAC/MYD09A1/MYD09A1.A2002185.h00v08.005.2007175015530.hdf"
  CONVERT_DEFAULT "HDFEOS2/LP-DAAC/MYD09GQ/MYD09GQ.A2008064.h11v10.005.2008067095716.hdf"
  CONVERT_DEFAULT "HDFEOS2/LP-DAAC/MYD11A1/MYD11A1.A2003184.h00v08.005.2007333141053.hdf"
  CONVERT_DEFAULT "HDFEOS2/LP-DAAC/MYD13A1/MYD13A1.A2002185.h00v08.005.2007178164946.hdf"
  CONVERT_DEFAULT "HDFEOS2/LP-DAAC/MYD15A2/MYD15A2.A2002185.h00v08.005.2007175021713.hdf"
  CONVERT_DEFAULT "HDFEOS2/LP-DAAC/MYD17A2/MYD17A2.A2002185.h00v08.005.2007182013352.hdf"
  CONVERT_DEFAULT "HDFEOS2/LP-DAAC/MOD15A2/MOD15A2.A2000049.h00v08.005.2006268222954.hdf"
  CONVERT_DEFAULT "HDFEOS2/LP-DAAC/MOD17A2/MOD17A2.A2000049.h00v08.005.2006333231256.hdf"
  CONVERT_DEFAULT "HDFEOS2/LP-DAAC/MCD43A1/MCD43A1.A2000049.h00v08.005.2006269203518.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/ATSM2LSF/MISR_LAND_FIRSTLOOK_P068_O044103_F07_0022_ATS_b32-38.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/ATSMIGEO/MISR_GMP_P068_O044103_F03_0013_ATS_b32-38.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/CMRMIGEO/MISR_GMP_P190_O025325_F03_0012_CMR_b62.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/GOMI2LS/MISR_LAND_P024_O035188_F06_0019_GOM_b64-72.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/GOMIB2E/MISR_ELLIPSOID_GM_P024_O035188_AA_F03_0024_GOM_b64-72.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/CARMIAAE/MISR_AEROSOL_P026_O005102_F07_0015_ICARTT_b47-57.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/IXBMI2AE/MISR_AEROSOL_P016_O032974_F09_0019_IXB_b64-77.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/IXBMIB2E/MISR_ELLIPSOID_GM_P016_O032974_AA_F03_0024_IXB_b64-77.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MB2LME/MISR_AM1_GRP_ELLIPSOID_LM_P025_O001039_DA_SITE_TROUTLAKE_F03_0024.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MI1B2E/MISR_AM1_GRP_ELLIPSOID_GM_P023_O002932_AA_F03_0023.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MI1B2E/MISR_AM1_GRP_ELLIPSOID_GM_P052_O000997_AA_F03_0024.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MI1B2T/MISR_AM1_GRP_TERRAIN_GM_P060_O002978_CA_F03_0023.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MI1B2T/MISR_AM1_GRP_TERRAIN_GM_P052_O000997_AA_F03_0024.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MI3DAEF/MISR_AM1_CGAS_FIRSTLOOK_AUG_30_2007_F11_0027.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MI3DAER/MISR_AM1_CGAS_MAR_01_2006_SITE_INTEXB_F06_0021.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MIL2TCAL/MISR_AM1_TC_ALBEDO_P020_O000995_F05_0011.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MIL2TCCL/MISR_AM1_TC_CLASSIFIERS_P020_O000995_F06_0011.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MIL3DAE/MISR_AM1_CGAS_FEB_25_2000_F15_0031.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MIL3DAL/MISR_AM1_CGAL_FEB_25_2000_F06_0024.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MIL3DCLD/MISR_AM1_CGCL_FEB_25_2000_F02_0024.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MIL3DLS/MISR_AM1_CGLS_FEB_25_2000_F04_0031.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MIRCCM/MISR_AM1_GRP_RCCM_GM_P026_O014189_DA_F03_0022.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MIRCCM/MISR_AM1_GRP_RCCM_GM_P020_O000995_AA_F04_0025.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MIRCCMF/MISR_AM1_GRP_RCCM_FIRSTLOOK_GM_P191_O040339_AA_F04_0025.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MOP02/MOP02-20000303-L2V5.7.1.val.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MOP03/MOP03-20000303-L3V1.0.1.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/SAMMI2AE/MISR_AEROSOL_P200_O034034_F09_0019_SAM_b57-71.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/SAMMIB2E/MISR_ELLIPSOID_GM_P200_O034034_AA_F03_0024_SAM_b57-71.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/UAEM1LME/MISR_ELLIPSOID_LM_P160_O024595_AA_SITE_ALDHAFRA_F03_0022.conv.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/UAEMIB2E/MISR_ELLIPSOID_GM_P160_O024129_AA_F03_0024_UAE_b68-74.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/UAEMIRCM/MISR_RCCM_GM_P160_O024595_AA_F03_0022_UAE_b68-74.conv.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/UAEMITAL/MISR_ALBEDO_P160_O024129_F04_0008_UAE_b68-74.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/UAEMRDAE/MISR_AM1_CGAS_JUL_01_2004_SITE_UAE_F02_0012.hdf"
  CONVERT_DEFAULT "HDFEOS2/LaRC/MI1B2E/MISR_AM1_GRP_ELLIPSOID_GM_P005_O005290_AN_F01_0008.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_5DSno/AMSR_E_L3_5DaySnow_B02_20040705.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_5DSno/AMSR_E_L3_5DaySnow_T08_20020620.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_DyOcn/AMSR_E_L3_DailyOcean_B02_20070706.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_DyOcn/AMSR_E_L3_DailyOcean_V03_20020619.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_DySno/AMSR_E_L3_DailySnow_B02_20020619.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_DySno/AMSR_E_L3_DailySnow_T08_20020619.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_L2A/AMSR_E_L2A_BrightnessTemperatures_V09_200206190029_D.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_Land/AMSR_E_L2_Land_B04_200206182340_A.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_Land/AMSR_E_L2_Land_T07_200206190029_D.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_Land3/AMSR_E_L3_DailyLand_B03_20020618.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_Land3/AMSR_E_L3_DailyLand_T05_20020619.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_MoOcn/AMSR_E_L3_MonthlyOcean_B02_200707.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_MoOcn/AMSR_E_L3_MonthlyOcean_V03_200206.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_MoSno/AMSR_E_L3_MonthlySnow_B07_200603.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_MoSno/AMSR_E_L3_MonthlySnow_T08_200206.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_Ocean/AMSR_E_L2_Ocean_B01_200206182340_A.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_Ocean/AMSR_E_L2_Ocean_V06_200206190029_D.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_Rain/AMSR_E_L2_Rain_B02_200206182340_A.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_Rain/AMSR_E_L2_Rain_V10_200206190029_D.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_RnGd/AMSR_E_L3_RainGrid_B05_200707.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_RnGd/AMSR_E_L3_RainGrid_V06_200206.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_SI12/AMSR_E_L3_SeaIce12km_B02_20020618.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_SI12/AMSR_E_L3_SeaIce12km_T08_20020619.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_WkOcn/AMSR_E_L3_WeeklyOcean_B02_20070701.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/AE_WkOcn/AMSR_E_L3_WeeklyOcean_V03_20020616.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MYD10A1/MYD10A1.A2006200.h10v08.004.2006210171342.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MYD10A1/MYD10A1.A2002185.h00v08.005.2007162002108.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MYD10_L2/MYD10_L2.A2006197.0315.004.2006206002033.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MYD29/MYD29.A2006197.0300.004.2006206001839.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MYD29/MYD29.A2002185.0000.005.2007160150627.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MYD29E1D/MYD29E1D.A2002185.005.2007161103323.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MYD29P1D/MYD29P1D.A2006202.h08v08.004.2006210172007.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MYD29P1D/MYD29P1D.A2002185.h03v08.005.2007161002144.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MOD10A1/MOD10A1.A2000055.h00v08.004.2002355191010.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MOD10A1/MOD10A1.A2000065.h00v08.005.2008237034422.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MOD10_L2/MOD10_L2.A2000136.0235.004.2003009030119.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MOD10_L2/MOD10_L2.A2000065.0040.005.2008235221207.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MOD29/MOD29.A2000136.0040.004.2003009030013.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MOD29E1D/MOD29E1D.A2000055.005.2006268025009.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/MOD29P1D/MOD29P1D.A2000131.h08v08.004.2003008210353.hdf"
  CONVERT_DEFAULT "HDFEOS2/NSIDC/NISE/NISE_SSMIF13_20000101.HDFEOS"
}

convert_files
convert_files_with_fakedim
convert_files_default

if test $nerrors -eq 0 ; then
  echo "All files were generated."
else
  echo "FAILED: # failures " $nerrors
fi
exit $nerrors

# vim:ts=8:sts=2:sw=2:et
