/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by  The HDF Group (THG) and                                     *
 *               The Board of Trustees of the University of Illinois.        *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,      *
 * including terms governing use, modification, and redistribution, is       *
 * contained in the files COPYING and Copyright.html.  COPYING can be found  *
 * at the root of the source code distribution tree; Copyright.html can be   *
 * found at the root level of an installed copy of the electronic H4H5TOOLS  *
 * document set and is linked from the top-level documents page.  It can     *
 * also be found at http://www.hdfgroup.org/H4H5TOOLS/doc/Copyright.html.    *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "h4toh5.h"

/* There are 12 test cases for h4toh5 library.*/
/* h4h5apitestdefault,
   h4h5apitestname,
   h4h5apitestimage,
   h4h5apitestimageattr,
   h4h5apitestsds,
   h4h5apitestsdsattr,
   h4h5apitestvdata,
   h4h5apitestvdataattr,
   h4h5apitestadvgroup,
   h4h5apitestbasvgroup,
   h4h5apitestloneimage,
   h4h5apitestlonesds,
   h4h5apitestlonevdata
   
   This file is h4h5apitestsdsattr:
   
   will test SDS attribute conversion
  
*/

/*-------------------------------------------------------------------------
 * Function:	main
 *
 * Purpose:    
 *-------------------------------------------------------------------------
 */	

 
int main() {

  hid_t         h4toh5id;/* h4toh5 id*/
  int32         sd_id;/* SD interface id */
  int32         sds_id;/* SDS id */
  int32         status;/* temporary variable to check the status of HDF4 APIs*/
  int           h4toh5status; /*temporary variable to check the status of h4toh5 APIs. */
   
   /** open SD interface **/
  sd_id   = SDstart("sds_lib_test.hdf",DFACC_READ);
  if(sd_id == FAIL) {
    printf("cannot start SD interface.\n");
    SDend(sd_id);
    return FAIL;
  }

  if((h4toh5id= H4toH5open("sds_lib_test.hdf","sds_lib_testattr.h5",H425_CLOBBER)) < 0) {
    printf(" cannot open h4toh5 interface\n");
    SDend(sd_id);
    return FAIL;
  }

  sds_id = SDselect(sd_id,0);
  if(sds_id == FAIL) {
    printf("cannot start SDS interface.\n");
    SDend(sd_id);
    return FAIL;
  }

  /* convert the first SDS */
  if(H4toH5sds(h4toh5id,sds_id,"/group1",NULL,NULL,0,0)<0) {
    printf("SDS conversion test fails\n");
    H4toH5error_get(h4toh5id);
    SDendaccess(sds_id);
    SDend(sd_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }

  /* convert SDS attribute by index. */
  if(H4toH5sds_attr_index(h4toh5id,sds_id,"/group1",NULL,0)<0){
    printf("SDS attribute conversion test (by index) fails \n");
    SDendaccess(sds_id);
    SDend(sd_id);
    H4toH5error_get(h4toh5id);
    H4toH5close(h4toh5id);
    return FAIL;
  }

  status = SDendaccess(sds_id);
  if(status == FAIL) {
    printf("cannot close SDS interface.\n");
    SDend(sd_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }
    
  
  /* convert the second SDS object to test SDS attribute conversion by name*/

  sds_id = SDselect(sd_id,3);
  if(sds_id == FAIL) {
    printf("cannot start the second SDS interface. \n");
    SDend(sd_id);                                                                  H4toH5close(h4toh5id);
    return FAIL;
  }

  if(H4toH5sds(h4toh5id,sds_id,"/group1","mysds","/mydimg",0,0)<0){
    printf("the second SDS conversion test fails\n");
    H4toH5error_get(h4toh5id);
    SDendaccess(sds_id);
    SDend(sd_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }
 
  /* convert SDS attribute sorted by name */
  if(H4toH5sds_attr_name(h4toh5id,sds_id,"/group1","mysds","sds.attr")<0){
    printf("the SDS attribute sorted by name fails\n");
    H4toH5error_get(h4toh5id);
    SDendaccess(sds_id);
    SDend(sd_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }

  /* close all interfaces. */
  status = SDendaccess(sds_id);
  if(status == FAIL) {
    printf("cannot close the SDS interface.\n");
    SDend(sd_id);
    H4toH5close(h4toh5id);
    return FAIL;
   } 
  status = SDend(sd_id);
  if(status == FAIL) {
    printf("cannot close the SD interface.\n");
    H4toH5close(h4toh5id);
    return FAIL;
  }
    
  h4toh5status = H4toH5close(h4toh5id);
  if(h4toh5status == FAIL) {
    printf("cannot close h4toh5 interface. \n");
    return FAIL;
  }

  return 0;
}



