/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by  The HDF Group (THG) and                                     *
 *               The Board of Trustees of the University of Illinois.        *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,      *
 * including terms governing use, modification, and redistribution, is       *
 * contained in the files COPYING and Copyright.html.  COPYING can be found  *
 * at the root of the source code distribution tree; Copyright.html can be   *
 * found at the root level of an installed copy of the electronic H4H5TOOLS  *
 * document set and is linked from the top-level documents page.  It can     *
 * also be found at http://www.hdfgroup.org/H4H5TOOLS/doc/Copyright.html.    *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "h4toh5.h"

/* There are 12 test cases for h4toh5 library.*/
/* h4h5apitestdefault,
   h4h5apitestname,
   h4h5apitestimage,
   h4h5apitestimageattr,
   h4h5apitestsds,
   h4h5apitestsdsattr,
   h4h5apitestvdata,
   h4h5apitestvdataattr,
   h4h5apitestadvgroup,
   h4h5apitestbasvgroup,
   h4h5apitestloneimage,
   h4h5apitestlonesds,
   h4h5apitestlonevdata
   
   This file is h4h5apitestimageattr.c.

   1) will test h4toh5 image attribute routine.

*/

/*-------------------------------------------------------------------------
 * Function:	main
 *
 * Purpose:    
 *-------------------------------------------------------------------------
 */	

 
int main() {

  hid_t         h4toh5id; /*h4toh5 id*/
  int32         file_id; /* HDF4 file id */
  int32         gr_id; /* HDF4 GR interface id */
  int32         ri_id; /* HDF4 raster image id */
  int32         status;  /*temporary variable to check status of HDF4 APIs */
   
   /** open GR interface **/
  file_id = Hopen("image_lib_test.hdf",DFACC_READ,0);
  if(file_id == FAIL) {
    printf("cannot open H interface. \n");
    return FAIL;
  }

  gr_id   = GRstart(file_id);
  if(gr_id == FAIL) {
    printf("cannot start GR interface.\n");
    Hclose(file_id);
    return FAIL;
  }

  if((h4toh5id= H4toH5open("image_lib_test.hdf","image_lib_testattr.h5",H425_CLOBBER)) < 0) {
    printf("cannot start h4toh5 interface\n");
    Hclose(file_id);
    return FAIL;
  }
  
  ri_id = GRselect(gr_id,0);

  if(ri_id == FAIL) {
    printf("cannot obtain raster image id.\n");
    GRend(file_id);
    Hclose(file_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }

  /* do the image conversion. */
  if(H4toH5image(h4toh5id,ri_id,"/group1",NULL,NULL,NULL,0,0)<0) {
    printf("The first image conversion failed\n");
    H4toH5error_get(h4toh5id);
    GRendaccess(ri_id);
    GRend(file_id);
    Hclose(file_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }

  /* do the image attribute(sorted by index) conversion */
  if(H4toH5image_attr_index(h4toh5id,ri_id,"/group1",NULL,0)<0){
    printf("image attribute(sorted by index) conversion failed\n");
    H4toH5error_get(h4toh5id);
    GRendaccess(ri_id);
    GRend(file_id);
    Hclose(file_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }

  status = GRendaccess(ri_id);
  if(status == FAIL) {
    printf("cannot close raster image interface.\n");
    GRend(file_id);
    Hclose(file_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }

  /* convert another image to test H4toH5imageattrname. */
  ri_id = GRselect(gr_id,1);
  if(ri_id == FAIL) {
    printf("cannot obtain raster image id.\n");
    GRend(file_id);
    Hclose(file_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }

  /* do the image conversion. */
  if(H4toH5image(h4toh5id,ri_id,"/group1","myimage","/mypalg","mypal",0,0)<0){
    printf("the second image conversion failed\n");
    H4toH5error_get(h4toh5id);
    GRend(file_id);
    Hclose(file_id);
    H4toH5close(h4toh5id);
    return FAIL;
  }

  /* do the image attribute conversion sorted by attribute name. */
  if(H4toH5image_attr_name(h4toh5id,ri_id,"/group1","myimage","Image Attribute2")<0){
    printf("the image attribute (sorted by attribute name)conversion failed\n");
    H4toH5error_get(h4toh5id);
    H4toH5close(h4toh5id);
    return FAIL;
  }
  GRendaccess(ri_id);
  H4toH5close(h4toh5id);
  GRend(gr_id);
  Hclose(file_id);
  return 0;
}
