/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by  The HDF Group and                                           *
 *               The Board of Trustees of the University of Illinois.        *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,      *
 * including terms governing use, modification, and redistribution, is       *
 * contained in the files COPYING and Copyright.html.  COPYING can be found  *
 * at the root of the source code distribution tree; Copyright.html can be   *
 * found at the root level of an installed copy of the electronic H4H5TOOLS  *
 * document set, is linked from the top-level documents page, and can be     *
 * found at http://www.hdfgroup.org/h4toh5/Copyright.html.  If you do not    *
 * have access to either file, you may request a copy from help@hdfgroup.org.*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/******************************************************************************

Description: 

1. converter

See HDF4 to HDF5 mapping specification at
(http://hdf.ncsa.uiuc.edu/HDF5/papers/h4toh5) for the default mapping 
from HDF4 object to HDF5 object.
 
The whole converter includes 10 files, h4toh5util.h, h4toh5main.h, h4toh5util.c, h4toh5main.c, h4toh5sds.c, h4toh5image.c,h4toh5vdata.c,h4toh5vgroup.c,h4toh5pal.c and h4toh5anno.c.

2. this file 

including declarations of subroutines of all .c files excluding h4toh5util.c.

Author:  Kent Yang(ymuqun@ncsa.uiuc.edu)
 

*****************************************************************************/


#ifndef H4TOH5MAIN_H
#define H4TOH5MAIN_H

/*#include "H4TOH5Iprivate.h"*/
#include "h4toh5util.h"

#endif

/* For windows support.*/
#ifdef WIN32
typedef unsigned int mode_t;
#endif

#ifndef S_ISDIR
#define S_ISDIR(mode) (((mode)&0xF000) == S_IFDIR)
#endif

/* subroutines for converting netcdf file */
int check_filetype(char* filename);

/* subroutines to check initial settings and inputting parameters.
Adapted from h5toh4 tools and used for h4toh5open  */
int test_file(const char *filename,int oflag,mode_t mode);
int test_dir(const char *);
char *BuildFilename(char *filename, char *ext);


/*subroutines for h4toh5vgroup.c*/
int convert_vgroup(hid_t,int32,char*,int);
int convert_vdata(hid_t,int32,char*,int);
int convert_sds(hid_t,int32,char*,int);
int convert_image(hid_t,int32,char*,int);
int convert_vgroupobjects(hid_t,char*,int32,int,int);
int vg_transattrs(hid_t,int32,hid_t,int);

/*subroutines for h4toh5vdata.c*/
int vdata_transattrs(hid_t,int32,hid_t,int,int,char*);
int gen_h5comptype(hid_t,int32,int32,size_t *,size_t*,hid_t*,hid_t*,hid_t,hid_t);

/* subroutines for h4toh5sds.c*/
int sds_transattrs(hid_t,int32, hid_t,int,int);
int H4toH5_sds(hid_t,int32,char*,char*,char*,int,int);
int H4toH5_sdscdf(hid_t,int32,char*,char*,char*,int,int);
int H4toH5all_dimscalecdf(hid_t,int32,char*,char*,char*,int,int);
int sds_transattrscdf(hid_t,int32,hid_t,int,int);
hid_t get_dimchunking_plistid(hid_t,int32,int32,int,int32);
hid_t get_chunking_plistid(hid_t,int32);
hid_t get_image_chunking_plistid(hid_t,int32);
int store_objref(hid_t,int,char[],hid_t,hid_t,int[]);
int store_attrname(hid_t,int,char[],hid_t);
int convert_sdsfillvalue(hid_t,int32,hid_t,char*,char*,char*,char*,int,int);
int convert_sdszerounlimit(hid_t,int32,hid_t,char*,char*,char*,int);
uint16 get_SDref(int32,uint16,int32);
int write_dimscale_attribute(hid_t did, hid_t h4toh5id, int count_h5objref, const char h5sdsdim_allname[], hid_t sh5_dimgroup, int dimempty[]);
int write_dimscaledataset_ref_attribute(hid_t did, hid_t dsid, hid_t h4toh5id, hobj_ref_t dref, int dindex);
int write_dimscaledataset_attribute(hid_t dsid, hid_t h4toh5id, const char *attrname, const char *attrvalue);
int attach_allscales(hid_t h4toh5id, hid_t did, int count_h5objref, const char h5sdsdim_allname[], hid_t sh5_dimgroup, const char *h5sdsname, hid_t h5_dgroup, int dimempty[]);

/*subroutines for h4toh5image.c*/
int gr_tranattrs(hid_t,int32, hid_t,int,int);
uint16 get_RIref(int32,uint16,int32);

/*subroutines for h4toh5anno.c*/
char* trans_tag_name(int32,ann_type);

/*subroutines for h4toh5pal.c*/
int create_pal_objref(hid_t,hid_t,hid_t,char *);
int store_palattrname(hid_t,char*,hid_t);






