//////////////////////////////////////////////////////////////////////////////
//    Copyright 2004-2014, SenseGraphics AB
//
//    This file is part of MedX3D.
//
//    MedX3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    MedX3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with MedX3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//    A commercial license is also available. Please contact us at 
//    www.sensegraphics.com for more information.
//
//
/// \file MedX3DDemoEdgeEnhancementVolumeStyleOptions.h
/// \brief Header file for MedX3DDemoEdgeEnhancementVolumeStyleOptions.
/// Subclass of EdgeEnhancementVolumeStyleOptions, which is generated by
/// wxFormBuilder.
///
//
//
//////////////////////////////////////////////////////////////////////////////
#ifndef __MedX3DDemoEdgeEnhancementVolumeStyleOptions__
#define __MedX3DDemoEdgeEnhancementVolumeStyleOptions__

#include <H3D/MedX3D/EdgeEnhancementVolumeStyle.h>

#include "MedX3DDemo.h"

/** Implementing EdgeEnhancementVolumeStyleOptions */
class MedX3DDemoEdgeEnhancementVolumeStyleOptions : public EdgeEnhancementVolumeStyleOptions
{
protected:
  // Handlers for EdgeEnhancementVolumeStyleOptions events.
  void OnEdgeColorChanged( wxColourPickerEvent& event );
  void OnGradientThresholdScroll( wxScrollEvent& event );
  
  H3DUtil::AutoRef< H3D::EdgeEnhancementVolumeStyle > edge_enhancement_style;

public:
  /** Constructor */
  MedX3DDemoEdgeEnhancementVolumeStyleOptions( wxWindow* parent,
                                               H3D::EdgeEnhancementVolumeStyle *style );
};

#endif // __MedX3DDemoEdgeEnhancementVolumeStyleOptions__
