/* GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <config.h>
#ifdef CATALOG2
#include "folder.h"
#include "loadcat.h"

typedef struct
{
  unsigned char type;
  unsigned long int taille;
  unsigned long int date;
  unsigned char categorie;
  unsigned short int description;
}
old_fileFormat;

#define OLDCAT_CATEGORY       0
#define OLDCAT_DESCRIPTION    1
#define OLDCAT_DIRECTORY      2
#define OLDCAT_FILE           3
#define OLDCAT_STARTCAT      10
#define OLDCAT_ENDDIRECTORY  12

#define OLDCAT_LINK           4

FILE_DATA *
make_link (gchar * dest_name, FILE_DATA * parent)
{
  FILE_DATA *file_data;
  char tmp_string[2048];

  /* New file_data */
  file_data = g_new (FILE_DATA, 1);

  /* Store the filename */
  snprintf (tmp_string, 2047, "%s -> %s", parent->name->str, dest_name);

  file_data->name = g_string_new (parent->name->str);


  /* Convert the data (Difficult, huh ?) */
  file_data->taille = 0;
  file_data->categorie = parent->categorie;
  file_data->description = parent->description;
  file_data->type = IS_LINK;
  file_data->mime = NULL;
  file_data->date = parent->date;
  file_data->information = NULL;
  return (file_data);
}

FILE_DATA *
read_oldfiledata (gzFile file_stream)
{
  int filename_cr;
  unsigned long i;
  gchar filename[256];
  gchar *information;
  FILE_DATA *file_data;
  old_fileFormat old_file_data;

  /* New file_data */
  file_data = g_new (FILE_DATA, 1);

  /* Read a Filename */
  gzgets (file_stream, filename, 255);

  /* Remove a carriage return */
  filename_cr = strlen (filename);
  if (filename[filename_cr - 1] == 0xa)
    filename[filename_cr - 1] = 0;

  /* Store the filename */
  file_data->name = g_string_new (filename);

  /* Read the remaining data */
  gzread (file_stream, &old_file_data, sizeof (old_fileFormat));

  /* Convert the data (Difficult, huh ?) */
  file_data->taille = old_file_data.taille;
  file_data->categorie = old_file_data.categorie;
  file_data->description = old_file_data.description;
  file_data->type = old_file_data.type;
  file_data->mime = NULL;
  file_data->date = old_file_data.date;

  /* Read the informations if there are some */
  if ((old_file_data.type >> 7) == 1)
    {
      /* Correct the filetype */
      file_data->type = file_data->type - 128;

      /* Read the data size */
      gzread (file_stream, &i, sizeof (unsigned long));
      information = g_new (gchar, i + 1);

      /* Read this data */
      gzread (file_stream, information, i * sizeof (char));
      file_data->information = g_string_new (information);
      g_free (information);
    }
  else
    file_data->information = NULL;

  return file_data;
}


int
load_oldfolder_tree (FOLDER * racine, gzFile gzcatalog, gboolean all)
{
  int id;
  gint current_level = 0;
  GNode *prev_node;
  FILE_DATA *file_data, *file_data2;
  guint tmp_string_cr;
  int fin = 0;
  gchar tmp_string[500];

  gzgetc (gzcatalog);

  while (fin == 0)
    {
      id = gzgetc (gzcatalog);
      switch (id)
	{
	case OLDCAT_CATEGORY:
	  gzgets (gzcatalog, tmp_string, 255);
	  tmp_string[strlen (tmp_string) - 1] = '\0';
	  g_ptr_array_add (racine->categories, g_string_new (tmp_string));
	  break;
	case OLDCAT_DESCRIPTION:
	  gzgets (gzcatalog, tmp_string, 255);
	  tmp_string[strlen (tmp_string) - 1] = '\0';
	  g_ptr_array_add (racine->descriptions, g_string_new (tmp_string));
	  break;
	case OLDCAT_STARTCAT:
	  fin = 1;
	  break;
	}
    }
  if (all == FALSE)
    return (0);

  prev_node = racine->tree;

  file_data = read_oldfiledata (gzcatalog);

  while ((id = gzgetc (gzcatalog)) != -1)
    {
      switch (id)
	{
	case OLDCAT_DIRECTORY:

	  file_data = read_oldfiledata (gzcatalog);

	  /* FIXME: Link Handling  */
	  if (file_data->type == OLDCAT_LINK)
	    {
	      gzgets (gzcatalog, tmp_string, 255);

	      file_data->type = IS_LINK;
	      file_data->node = g_node_append_data (prev_node, file_data);
	      g_ptr_array_add (racine->datas, file_data);
	      file_data2 = make_link (tmp_string, file_data);
	      g_node_append_data (file_data->node, file_data2);
	      g_ptr_array_add (racine->datas, file_data2);

	    }
	  else
	    {
	      /* Inc the level */
	      current_level++;

	      /* Add the node */
	      prev_node = g_node_append_data (prev_node, file_data);
	      file_data->node = prev_node;
	      g_ptr_array_add (racine->datas, file_data);
	    }
	  break;

	case OLDCAT_FILE:

	  file_data = read_oldfiledata (gzcatalog);

	  /* Add the node to the directory */
	  file_data->node = g_node_append_data (prev_node, file_data);
	  g_ptr_array_add (racine->datas, file_data);

	  break;
	case OLDCAT_ENDDIRECTORY:
	  /* Dec the level */
	  current_level--;

	  gzgets (gzcatalog, tmp_string, 255);

	  /* Remove a carriage return */
	  tmp_string_cr = strlen (tmp_string);
	  if (tmp_string[tmp_string_cr - 1] == 0xa)
	    tmp_string[tmp_string_cr - 1] = 0;

	  prev_node = prev_node->parent;
	  break;
	default:
	  printf ("%s %d: Reading error (id=%d), exiting.\n", __FILE__,
		  __LINE__, id);
	  return (-1);
	}
    }

  if (current_level != 0)
    {
      printf ("%s %d: Current level != 0 (%d)\n", __FILE__, __LINE__,
	      current_level);
      return (-1);
    }

  return (0);
}
#endif
