/*
 * nodoka_types.h
 * This file is part of gtk-nodoka-engine
 *
 * Copyright (C) 2007, 2008 - Martin Sourada, Daniel Geiger
 *
 * gtk-nodoka-engine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gtk-nodoka-engine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gtk-nodoka-engine; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */ 

#ifndef NODOKA_TYPES_H
#define NODOKA_TYPES_H

#include <gtk/gtk.h>
#include <gdk/gdk.h>

typedef unsigned char boolean;
typedef unsigned char uint8;

typedef enum
{
	NDK_STATE_NORMAL,
	NDK_STATE_ACTIVE,
	NDK_STATE_PRELIGHT,
	NDK_STATE_SELECTED,
	NDK_STATE_INSENSITIVE
} NodokaStateType;

typedef enum
{
	NDK_CORNER_NONE = 0,
	NDK_CORNER_TOPLEFT = 1,
	NDK_CORNER_TOPRIGHT = 2,
	NDK_CORNER_BOTTOMLEFT = 4,
	NDK_CORNER_BOTTOMRIGHT = 8,
	NDK_CORNER_ALL = 15
} NodokaCorners;

typedef enum
{
	NDK_JUNCTION_NONE = 0,
	NDK_JUNCTION_BEGIN = 1,
	NDK_JUNCTION_END = 2
} NodokaJunction;

typedef enum
{
	NDK_STEPPER_UNKNOWN = 0,
	NDK_STEPPER_A = 1,
	NDK_STEPPER_B = 2,
	NDK_STEPPER_C = 4,
	NDK_STEPPER_D = 8
} NodokaStepper;

typedef enum
{
	NDK_ORDER_FIRST,
	NDK_ORDER_MIDDLE,
	NDK_ORDER_LAST
} NodokaOrder;

typedef enum
{
	NDK_ORIENTATION_LEFT_TO_RIGHT,
	NDK_ORIENTATION_RIGHT_TO_LEFT,
	NDK_ORIENTATION_BOTTOM_TO_TOP,
	NDK_ORIENTATION_TOP_TO_BOTTOM
} NodokaOrientation;

typedef enum
{
	NDK_GAP_LEFT,
	NDK_GAP_RIGHT,
	NDK_GAP_TOP,
	NDK_GAP_BOTTOM
} NodokaGapSide;

typedef enum
{
	NDK_SHADOW_NONE,
	NDK_SHADOW_IN,
	NDK_SHADOW_OUT,
	NDK_SHADOW_ETCHED_IN,
	NDK_SHADOW_ETCHED_OUT,
	NDK_SHADOW_FLAT
} NodokaShadowType;

typedef enum
{
	NDK_HANDLE_TOOLBAR,
	NDK_HANDLE_SPLITTER
} NodokaHandleType;

typedef enum
{
	NDK_ARROW_NORMAL,
	NDK_ARROW_COMBO,
	NDK_ARROW_SCROLL,
	NDK_ARROW_SPINBUTTON
} NodokaArrowType;

typedef enum
{
	NDK_DIRECTION_UP,
	NDK_DIRECTION_DOWN,
	NDK_DIRECTION_LEFT,
	NDK_DIRECTION_RIGHT
} NodokaDirection;

typedef enum
{
	NDK_PROGRESSBAR_CONTINUOUS,
	NDK_PROGRESSBAR_DISCRETE
} NodokaProgressBarStyle;

typedef enum
{
	NDK_WINDOW_EDGE_NORTH_WEST,
	NDK_WINDOW_EDGE_NORTH,
	NDK_WINDOW_EDGE_NORTH_EAST,
	NDK_WINDOW_EDGE_WEST,
	NDK_WINDOW_EDGE_EAST,
	NDK_WINDOW_EDGE_SOUTH_WEST,
	NDK_WINDOW_EDGE_SOUTH,
	NDK_WINDOW_EDGE_SOUTH_EAST
} NodokaWindowEdge;

typedef struct
{
	double r;
	double g;
	double b;
} NodokaRGB;

typedef struct
{
	double x;
	double y;
	double width;
	double height;
} NodokaRectangle;

typedef struct
{
	NodokaRGB bg[5];
	NodokaRGB base[5];
	NodokaRGB text[5];

	NodokaRGB shade[9];
	NodokaRGB spot[3];
} NodokaColors;

typedef struct
{
	boolean active;
	boolean prelight;
	boolean disabled;
	boolean focus;
	boolean is_default;
	boolean ltr;

	NodokaStateType state_type;

	int roundness;
	double hilight_ratio;
	boolean gradients;

	uint8 corners;
	uint8 xthickness;
	uint8 ythickness;

	NodokaRGB parentbg;
} WidgetParameters;

typedef struct
{
	boolean inner;
	boolean fill;
} FocusParameters;

typedef struct
{
	boolean lower;
	boolean horizontal;
	boolean fill_level; 
	FocusParameters focus;
} SliderParameters;

typedef struct
{
	NodokaOrientation orientation;
	NodokaProgressBarStyle style;
	int offset;
	boolean stripes;
} ProgressBarParameters;

typedef struct
{
	int linepos;
	FocusParameters focus;
} OptionMenuParameters;

typedef struct
{
	boolean inconsistent;
	boolean draw_bullet;
	NodokaRGB bullet_color;
} OptionParameters;


typedef struct
{
	NodokaShadowType shadow;
	NodokaGapSide gap_side;
	int gap_x;
	int gap_width;
	NodokaRGB *border;
	boolean draw_fill;
} FrameParameters;

typedef struct
{
	NodokaGapSide gap_side;
} TabParameters;

typedef struct
{
	NodokaCorners corners;
	NodokaShadowType shadow;
} ShadowParameters;

typedef struct
{
	boolean horizontal;
} SeparatorParameters;

typedef struct
{
	NodokaOrder order;
	boolean resizable;
	int style;
} ListViewHeaderParameters;

typedef struct
{
	NodokaRGB color;
	NodokaJunction junction;	/* On which sides the slider junctions */
	NodokaStepper steppers;		/* The visible steppers */
	boolean horizontal;
	boolean has_color;
	int style;
} ScrollBarParameters;

typedef struct
{
	boolean horizontal;
	boolean shadows;
	FocusParameters focus;
} ButtonParameters;

typedef struct
{
	int style;
} MenuBarParameters;

typedef struct
{
	int style;
	boolean horizontal;
} ToolbarParameters;

typedef struct
{
	FocusParameters focus;
} EntryParameters;

typedef struct
{
	/* The maximum size of the fill. Calculated from the entries allocation,
	 * and other information. Relative to the drawn position.
	 */
	GdkRectangle max_size;
	gboolean max_size_known;
	/* The border around the bar. This can be used for radius calculations.
	 */
	GtkBorder border;
} EntryProgressParameters;

typedef struct
{
	NodokaHandleType type;
	boolean horizontal;
} HandleParameters;

typedef struct
{
	NodokaStepper stepper;		/* Which stepper to draw */
} ScrollBarStepperParameters;

typedef struct
{
	NodokaArrowType type;
	NodokaDirection direction;
} ArrowParameters;

typedef struct
{
	NodokaWindowEdge edge;
} ResizeGripParameters;

#define NODOKA_RECTANGLE_SET(rect, _x, _y, _w, _h) rect.x      = _x; \
                                                   rect.y      = _y; \
                                                   rect.width  = _w; \
                                                   rect.height = _h;

#endif /* NODOKA_TYPES_H */
