/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.testng.collections.CollectionUtils;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.IWeaveXml;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlDefine;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.testng.xml.XmlUtils;

class DefaultXmlWeaver
implements IWeaveXml {
    private static final String TESTNG_DTD = "testng-1.0.dtd";
    private static final String HTTPS_TESTNG_DTD_URL = "https://testng.org/testng-1.0.dtd";
    private final String defaultComment;

    DefaultXmlWeaver() {
        this(null);
    }

    DefaultXmlWeaver(String defaultComment) {
        this.defaultComment = defaultComment;
    }

    @Override
    public String asXml(XmlSuite xmlSuite) {
        XmlSuite.ParallelMode parallel;
        XMLStringBuffer xsb = new XMLStringBuffer();
        xsb.setDefaultComment(this.defaultComment);
        xsb.setDocType("suite SYSTEM \"https://testng.org/testng-1.0.dtd\"");
        Properties p = new Properties();
        p.setProperty("name", xmlSuite.getName());
        if (xmlSuite.getVerbose() != null) {
            XmlUtils.setProperty(p, "verbose", xmlSuite.getVerbose().toString(), XmlSuite.DEFAULT_VERBOSE.toString());
        }
        if ((parallel = xmlSuite.getParallel()) != null && !XmlSuite.DEFAULT_PARALLEL.equals((Object)parallel)) {
            p.setProperty("parallel", parallel.toString());
        }
        XmlUtils.setProperty(p, "group-by-instances", String.valueOf(xmlSuite.getGroupByInstances()), XmlSuite.DEFAULT_GROUP_BY_INSTANCES.toString());
        XmlUtils.setProperty(p, "configfailurepolicy", xmlSuite.getConfigFailurePolicy().toString(), XmlSuite.DEFAULT_CONFIG_FAILURE_POLICY.toString());
        XmlUtils.setProperty(p, "thread-count", String.valueOf(xmlSuite.getThreadCount()), XmlSuite.DEFAULT_THREAD_COUNT.toString());
        XmlUtils.setProperty(p, "data-provider-thread-count", String.valueOf(xmlSuite.getDataProviderThreadCount()), XmlSuite.DEFAULT_DATA_PROVIDER_THREAD_COUNT.toString());
        if (Utils.isStringNotEmpty(xmlSuite.getTimeOut())) {
            p.setProperty("time-out", xmlSuite.getTimeOut());
        }
        if (!XmlSuite.DEFAULT_JUNIT.equals(xmlSuite.isJUnit())) {
            p.setProperty("junit", xmlSuite.isJUnit() != null ? xmlSuite.isJUnit().toString() : "false");
        }
        XmlUtils.setProperty(p, "skipfailedinvocationcounts", xmlSuite.skipFailedInvocationCounts().toString(), XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS.toString());
        if (null != xmlSuite.getObjectFactoryClass()) {
            p.setProperty("object-factory", xmlSuite.getObjectFactoryClass().getName());
        }
        if (Utils.isStringNotEmpty(xmlSuite.getParentModule())) {
            p.setProperty("parent-module", xmlSuite.getParentModule());
        }
        if (Utils.isStringNotEmpty(xmlSuite.getGuiceStage())) {
            p.setProperty("guice-stage", xmlSuite.getGuiceStage());
        }
        XmlUtils.setProperty(p, "allow-return-values", String.valueOf(xmlSuite.getAllowReturnValues()), XmlSuite.DEFAULT_ALLOW_RETURN_VALUES.toString());
        xsb.push("suite", p);
        List<String> included = xmlSuite.getIncludedGroups();
        List<String> excluded = xmlSuite.getExcludedGroups();
        if (CollectionUtils.hasElements(included) || CollectionUtils.hasElements(excluded)) {
            xsb.push("groups");
            xsb.push("run");
            for (String g : included) {
                xsb.addEmptyElement("include", "name", g);
            }
            for (String g : excluded) {
                xsb.addEmptyElement("exclude", "name", g);
            }
            xsb.pop("run");
            xsb.pop("groups");
        }
        if (xmlSuite.getGroups() != null) {
            xsb.getStringBuffer().append(xmlSuite.getGroups().toXml("  "));
        }
        XmlUtils.dumpParameters(xsb, xmlSuite.getParameters());
        if (CollectionUtils.hasElements(xmlSuite.getListeners())) {
            xsb.push("listeners");
            for (String listenerName : xmlSuite.getLocalListeners()) {
                Properties listenerProps = new Properties();
                listenerProps.setProperty("class-name", listenerName);
                xsb.addEmptyElement("listener", listenerProps);
            }
            xsb.pop("listeners");
        }
        if (CollectionUtils.hasElements(xmlSuite.getXmlPackages())) {
            xsb.push("packages");
            for (XmlPackage pack : xmlSuite.getXmlPackages()) {
                xsb.getStringBuffer().append(pack.toXml("    "));
            }
            xsb.pop("packages");
        }
        if (xmlSuite.getXmlMethodSelectors() != null) {
            xsb.getStringBuffer().append(xmlSuite.getXmlMethodSelectors().toXml("  "));
        } else if (CollectionUtils.hasElements(xmlSuite.getMethodSelectors())) {
            xsb.push("method-selectors");
            for (XmlMethodSelector selector : xmlSuite.getMethodSelectors()) {
                xsb.getStringBuffer().append(selector.toXml("  "));
            }
            xsb.pop("method-selectors");
        }
        List<String> suiteFiles = xmlSuite.getSuiteFiles();
        if (!suiteFiles.isEmpty()) {
            xsb.push("suite-files");
            for (String sf : suiteFiles) {
                Properties prop = new Properties();
                prop.setProperty("path", sf);
                xsb.addEmptyElement("suite-file", prop);
            }
            xsb.pop("suite-files");
        }
        for (XmlTest test : xmlSuite.getTests()) {
            xsb.getStringBuffer().append(test.toXml("  "));
        }
        xsb.pop("suite");
        return xsb.toXML();
    }

    @Override
    public String asXml(XmlTest xmlTest, String indent) {
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        xsb.setDefaultComment(this.defaultComment);
        Properties p = new Properties();
        p.setProperty("name", xmlTest.getName());
        XmlUtils.setProperty(p, "junit", Boolean.toString(xmlTest.isJUnit()), XmlSuite.DEFAULT_JUNIT.toString());
        XmlUtils.setProperty(p, "parallel", xmlTest.getParallel().toString(), XmlSuite.DEFAULT_PARALLEL.toString());
        XmlUtils.setProperty(p, "verbose", Integer.toString(xmlTest.getVerbose()), XmlSuite.DEFAULT_VERBOSE.toString());
        if (null != xmlTest.getTimeOut()) {
            p.setProperty("time-out", xmlTest.getTimeOut());
        }
        if (xmlTest.getPreserveOrder() != null && !XmlSuite.DEFAULT_PRESERVE_ORDER.equals(xmlTest.getPreserveOrder())) {
            p.setProperty("preserve-order", xmlTest.getPreserveOrder().toString());
        }
        if (xmlTest.getThreadCount() != -1) {
            p.setProperty("thread-count", Integer.toString(xmlTest.getThreadCount()));
        }
        XmlUtils.setProperty(p, "group-by-instances", String.valueOf(xmlTest.getGroupByInstances()), XmlSuite.DEFAULT_GROUP_BY_INSTANCES.toString());
        xsb.push("test", p);
        if (null != xmlTest.getMethodSelectors() && !xmlTest.getMethodSelectors().isEmpty()) {
            xsb.push("method-selectors");
            for (XmlMethodSelector xmlMethodSelector : xmlTest.getMethodSelectors()) {
                xsb.getStringBuffer().append(xmlMethodSelector.toXml(indent + "    "));
            }
            xsb.pop("method-selectors");
        }
        XmlUtils.dumpParameters(xsb, xmlTest.getLocalParameters());
        if (!((xmlTest.getXmlGroups() == null || xmlTest.getXmlGroups().getDefines().isEmpty() && (xmlTest.getXmlGroups().getRun() == null || xmlTest.getXmlGroups().getRun().getIncludes().isEmpty() && xmlTest.getXmlGroups().getRun().getExcludes().isEmpty())) && xmlTest.getXmlDependencyGroups().isEmpty())) {
            xsb.push("groups");
            if (xmlTest.getXmlGroups() != null) {
                for (XmlDefine xmlDefine : xmlTest.getXmlGroups().getDefines()) {
                    Properties metaGroupProp = new Properties();
                    metaGroupProp.setProperty("name", xmlDefine.getName());
                    xsb.push("define", metaGroupProp);
                    for (String groupName : xmlDefine.getIncludes()) {
                        Properties includeProps = new Properties();
                        includeProps.setProperty("name", groupName);
                        xsb.addEmptyElement("include", includeProps);
                    }
                    xsb.pop("define");
                }
            }
            if (!(xmlTest.getXmlGroups() == null || xmlTest.getXmlGroups().getRun() == null || xmlTest.getXmlGroups().getRun().getIncludes().isEmpty() && xmlTest.getXmlGroups().getRun().getExcludes().isEmpty())) {
                xsb.push("run");
                for (String string : xmlTest.getXmlGroups().getRun().getIncludes()) {
                    Properties includeProps = new Properties();
                    includeProps.setProperty("name", string);
                    xsb.addEmptyElement("include", includeProps);
                }
                for (String string : xmlTest.getXmlGroups().getRun().getExcludes()) {
                    Properties excludeProps = new Properties();
                    excludeProps.setProperty("name", string);
                    xsb.addEmptyElement("exclude", excludeProps);
                }
                xsb.pop("run");
            }
            if (xmlTest.getXmlDependencyGroups() != null && !xmlTest.getXmlDependencyGroups().isEmpty()) {
                xsb.push("dependencies");
                for (Map.Entry entry : xmlTest.getXmlDependencyGroups().entrySet()) {
                    xsb.addEmptyElement("group", "name", (String)entry.getKey(), "depends-on", (String)entry.getValue());
                }
                xsb.pop("dependencies");
            }
            xsb.pop("groups");
        }
        if (null != xmlTest.getXmlPackages() && !xmlTest.getXmlPackages().isEmpty()) {
            xsb.push("packages");
            for (XmlPackage xmlPackage : xmlTest.getXmlPackages()) {
                xsb.getStringBuffer().append(xmlPackage.toXml("      "));
            }
            xsb.pop("packages");
        }
        if (null != xmlTest.getXmlClasses() && !xmlTest.getXmlClasses().isEmpty()) {
            xsb.push("classes");
            for (XmlClass xmlClass : xmlTest.getXmlClasses()) {
                xsb.getStringBuffer().append(xmlClass.toXml(indent + "    "));
            }
            xsb.pop("classes");
        }
        xsb.pop("test");
        return xsb.toXML();
    }
}

