/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.internal.thread.ExecutorAdapter;
import org.testng.internal.thread.IExecutor;
import org.testng.internal.thread.IThreadFactory;
import org.testng.internal.thread.TestNGThread;

public class ThreadUtil {
    private static final String THREAD_NAME = "TestNG";

    public static boolean isTestNGThread() {
        return Thread.currentThread().getName().contains(THREAD_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void execute(List<? extends Runnable> tasks, int threadPoolSize, long timeout, boolean triggerAtOnce) {
        CountDownLatch startGate = new CountDownLatch(1);
        CountDownLatch endGate = new CountDownLatch(tasks.size());
        Utils.log("ThreadUtil", 2, "Starting executor timeOut:" + timeout + "ms" + " workers:" + tasks.size() + " threadPoolSize:" + threadPoolSize);
        ThreadPoolExecutor pooledExecutor = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, timeout, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread result = new Thread(r);
                result.setName(ThreadUtil.THREAD_NAME);
                return result;
            }
        });
        List callables = Lists.newArrayList();
        for (final Runnable runnable : tasks) {
            callables.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    runnable.run();
                    return null;
                }
            });
        }
        try {
            if (timeout != 0L) {
                pooledExecutor.invokeAll(callables, timeout, TimeUnit.MILLISECONDS);
            } else {
                pooledExecutor.invokeAll(callables);
            }
        }
        catch (InterruptedException handled) {
            handled.printStackTrace();
            Thread.currentThread().interrupt();
        }
        finally {
            pooledExecutor.shutdown();
        }
    }

    public static final String currentThreadInfo() {
        Thread thread = Thread.currentThread();
        return String.valueOf(thread.getName() + "@" + thread.hashCode());
    }

    public static final IExecutor createExecutor(int threadCount, String threadFactoryName) {
        return new ExecutorAdapter(threadCount, ThreadUtil.createFactory(threadFactoryName));
    }

    private static final IThreadFactory createFactory(String name) {
        return new ThreadFactoryImpl(name);
    }

    private static void log(int level, String msg) {
        Utils.log("ThreadUtil:" + ThreadUtil.currentThreadInfo(), level, msg);
    }

    public static class ThreadFactoryImpl
    implements IThreadFactory,
    ThreadFactory {
        private String m_methodName;
        private List<Thread> m_threads = Lists.newArrayList();

        public ThreadFactoryImpl(String name) {
            this.m_methodName = name;
        }

        @Override
        public Thread newThread(Runnable run) {
            TestNGThread result = new TestNGThread(run, this.m_methodName);
            this.m_threads.add(result);
            return result;
        }

        @Override
        public Object getThreadFactory() {
            return this;
        }

        @Override
        public List<Thread> getThreads() {
            return this.m_threads;
        }
    }
}

