/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.util.logging;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.radeox.util.logging.LogHandler;
import org.radeox.util.logging.SystemErrLogger;

public class Logger {
    private static LogHandler handler = new SystemErrLogger();
    public static final boolean PRINT_STACKTRACE = true;
    public static final DateFormat format = new SimpleDateFormat("hh:mm:ss.SSS");
    public static final int ALL = -1;
    public static final int NONE = 4;
    public static final int PERF = 0;
    public static final int DEBUG = 1;
    public static final int WARN = 2;
    public static final int FATAL = 3;
    public static final int LEVEL = -1;
    public static final String[] levels = new String[]{"PERF  ", "DEBUG ", "WARN  ", "FATAL "};

    public static void log(String string) {
        Logger.log(1, string);
    }

    public static void perf(String string) {
        Logger.log(0, string);
    }

    public static void debug(String string) {
        Logger.log(1, string);
    }

    public static void warn(String string) {
        Logger.log(2, string);
    }

    public static void warn(String string, Throwable throwable) {
        Logger.log(2, string, throwable);
    }

    public static void fatal(String string) {
        Logger.log(2, string);
    }

    public static void fatal(String string, Exception exception) {
        Logger.log(2, string, exception);
    }

    public static void log(String string, Exception exception) {
        Logger.log(1, string, exception);
    }

    public static void log(int n, String string) {
        handler.log(format.format(new Date()) + " " + levels[n] + " - " + string);
    }

    public static void log(int n, String string, Throwable throwable) {
        handler.log(format.format(new Date()) + " " + levels[n] + " - " + string + ": " + throwable.getMessage(), throwable);
    }

    public static void setHandler(LogHandler logHandler) {
        handler = logHandler;
    }
}

