/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.util;

import java.io.IOException;
import java.io.Writer;

public class StringBufferWriter
extends Writer {
    private StringBuffer buffer;

    public StringBufferWriter(StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
        this.lock = stringBuffer;
    }

    public StringBufferWriter() {
        this.buffer = new StringBuffer();
        this.lock = this.buffer;
    }

    public StringBufferWriter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.buffer = new StringBuffer(n);
        this.lock = this.buffer;
    }

    @Override
    public void write(int n) {
        this.buffer.append((char)n);
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.buffer.append(cArray, n, n2);
    }

    @Override
    public void write(String string) {
        this.buffer.append(string);
    }

    @Override
    public void write(String string, int n, int n2) {
        this.buffer.append(string.substring(n, n + n2));
    }

    public String toString() {
        return this.buffer.toString();
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }
}

