/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter.interwiki;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.util.Encoder;

public class InterWiki {
    private static Log log = LogFactory.getLog(InterWiki.class);
    private static InterWiki instance;
    private Map interWiki;

    public static synchronized InterWiki getInstance() {
        if (null == instance) {
            instance = new InterWiki();
        }
        return instance;
    }

    public InterWiki(InputStream inputStream) {
        try {
            this.init(inputStream);
        }
        catch (IOException iOException) {
            log.warn((Object)"Unable to initialize from stream.", (Throwable)iOException);
        }
    }

    public InterWiki() {
        try {
            this.init(new FileInputStream("conf/intermap.txt"));
        }
        catch (IOException iOException) {
            log.warn((Object)"Unable to read conf/intermap.txt", (Throwable)iOException);
        }
    }

    public void init(InputStream inputStream) throws IOException {
        String string;
        this.interWiki = new HashMap();
        this.interWiki.put("LCOM", "http://www.langreiter.com/space/");
        this.interWiki.put("ESA", "http://earl.strain.at/space/");
        this.interWiki.put("C2", "http://www.c2.com/cgi/wiki?");
        this.interWiki.put("WeblogKitchen", "http://www.weblogkitchen.com/wiki.cgi?");
        this.interWiki.put("Meatball", "http://www.usemod.com/cgi-bin/mb.pl?");
        this.interWiki.put("SnipSnap", "http://snipsnap.org/space/");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf(" ");
            this.interWiki.put(string.substring(0, n), Encoder.escape(string.substring(n + 1)));
        }
    }

    public Writer appendTo(Writer writer) throws IOException {
        Iterator iterator = this.interWiki.entrySet().iterator();
        writer.write("{table}\n");
        writer.write("Wiki|Url\n");
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            writer.write((String)entry.getKey());
            writer.write("|");
            writer.write((String)entry.getValue());
            writer.write("\n");
        }
        writer.write("{table}");
        return writer;
    }

    public boolean contains(String string) {
        return this.interWiki.containsKey(string);
    }

    public String getWikiUrl(String string, String string2) {
        return (String)this.interWiki.get(string) + string2;
    }

    public Writer expand(Writer writer, String string, String string2, String string3, String string4) throws IOException {
        writer.write("<a href=\"");
        writer.write((String)this.interWiki.get(string));
        writer.write(string2);
        if (!"".equals(string4)) {
            writer.write("#");
            writer.write(string4);
        }
        writer.write("\">");
        writer.write(string3);
        writer.write("</a>");
        return writer;
    }

    public Writer expand(Writer writer, String string, String string2, String string3) throws IOException {
        return this.expand(writer, string, string2, string3, "");
    }
}

