/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter;

import java.text.MessageFormat;
import org.radeox.api.engine.ImageRenderEngine;
import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.filter.CacheFilter;
import org.radeox.filter.context.FilterContext;
import org.radeox.filter.regex.LocaleRegexTokenFilter;
import org.radeox.regex.MatchResult;
import org.radeox.util.Encoder;

public class UrlFilter
extends LocaleRegexTokenFilter
implements CacheFilter {
    private MessageFormat formatter;

    @Override
    protected String getLocaleKey() {
        return "filter.url";
    }

    @Override
    public void setInitialContext(InitialRenderContext initialRenderContext) {
        super.setInitialContext(initialRenderContext);
        String string = this.outputMessages.getString(this.getLocaleKey() + ".print");
        this.formatter = new MessageFormat("");
        this.formatter.applyPattern(string);
    }

    @Override
    public void handleMatch(StringBuffer stringBuffer, MatchResult matchResult, FilterContext filterContext) {
        stringBuffer.append(matchResult.group(1));
        RenderEngine renderEngine = filterContext.getRenderContext().getRenderEngine();
        String string = "";
        if (renderEngine instanceof ImageRenderEngine) {
            stringBuffer.append(((ImageRenderEngine)((Object)renderEngine)).getExternalImageLink());
        }
        stringBuffer.append(this.formatter.format(new Object[]{string, Encoder.escape(matchResult.group(2)), Encoder.toEntity(matchResult.group(2).charAt(0)) + matchResult.group(2).substring(1)}));
    }
}

