/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.api.engine.IncludeRenderEngine;
import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.filter.context.FilterContext;
import org.radeox.filter.regex.RegexTokenFilter;
import org.radeox.macro.Macro;
import org.radeox.macro.MacroRepository;
import org.radeox.macro.Repository;
import org.radeox.macro.parameter.MacroParameter;
import org.radeox.regex.MatchResult;
import org.radeox.util.StringBufferWriter;

public class MacroFilter
extends RegexTokenFilter {
    private static Log log = LogFactory.getLog(MacroFilter.class);
    private MacroRepository macros;

    public MacroFilter() {
        super("\\{([^:}]+)(?::([^\\}]*))?\\}(.*?)\\{\\1\\}", false);
        this.addRegex("\\{([^:}]+)(?::([^\\}]*))?\\}", "", false);
    }

    @Override
    public void setInitialContext(InitialRenderContext initialRenderContext) {
        this.macros = MacroRepository.getInstance();
        this.macros.setInitialContext(initialRenderContext);
    }

    protected Repository getMacroRepository() {
        return this.macros;
    }

    @Override
    public void handleMatch(StringBuffer stringBuffer, MatchResult matchResult, FilterContext filterContext) {
        String string = matchResult.group(1);
        if (string != null) {
            if (!string.startsWith("$")) {
                MacroParameter macroParameter = filterContext.getMacroParameter();
                switch (matchResult.groups()) {
                    case 3: {
                        macroParameter.setContent(matchResult.group(3));
                        macroParameter.setContentStart(matchResult.beginOffset(3));
                        macroParameter.setContentEnd(matchResult.endOffset(3));
                    }
                    case 2: {
                        macroParameter.setParams(matchResult.group(2));
                    }
                }
                macroParameter.setStart(matchResult.beginOffset(0));
                macroParameter.setEnd(matchResult.endOffset(0));
                try {
                    Macro macro;
                    if (this.getMacroRepository().containsKey(string)) {
                        macro = (Macro)this.getMacroRepository().get(string);
                        if (null != macroParameter.getContent()) {
                            macroParameter.setContent(this.filter(macroParameter.getContent(), filterContext));
                        }
                    } else {
                        if (string.startsWith("!")) {
                            RenderEngine renderEngine = filterContext.getRenderContext().getRenderEngine();
                            if (renderEngine instanceof IncludeRenderEngine) {
                                String string2 = ((IncludeRenderEngine)((Object)renderEngine)).include(string.substring(1));
                                if (null != string2) {
                                    stringBuffer.append(string2);
                                } else {
                                    stringBuffer.append(string.substring(1) + " not found.");
                                }
                            }
                            return;
                        }
                        stringBuffer.append(matchResult.group(0));
                        return;
                    }
                    StringBufferWriter stringBufferWriter = new StringBufferWriter(stringBuffer);
                    macro.execute(stringBufferWriter, macroParameter);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    stringBuffer.append("<div class=\"error\">" + string + ": " + illegalArgumentException.getMessage() + "</div>");
                }
                catch (Throwable throwable) {
                    log.warn((Object)("MacroFilter: unable to format macro: " + matchResult.group(1)), throwable);
                    stringBuffer.append("<div class=\"error\">" + string + ": " + throwable.getMessage() + "</div>");
                    return;
                }
            } else {
                stringBuffer.append("<");
                stringBuffer.append(string.substring(1));
                stringBuffer.append(">");
            }
        } else {
            stringBuffer.append(matchResult.group(0));
        }
    }
}

