/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter;

import java.text.MessageFormat;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.filter.CacheFilter;
import org.radeox.filter.context.FilterContext;
import org.radeox.filter.regex.LocaleRegexTokenFilter;
import org.radeox.regex.MatchResult;

public class HeadingFilter
extends LocaleRegexTokenFilter
implements CacheFilter {
    private MessageFormat formatter;

    @Override
    protected String getLocaleKey() {
        return "filter.heading";
    }

    @Override
    public void handleMatch(StringBuffer stringBuffer, MatchResult matchResult, FilterContext filterContext) {
        stringBuffer.append(this.handleMatch(matchResult, filterContext));
    }

    @Override
    public void setInitialContext(InitialRenderContext initialRenderContext) {
        super.setInitialContext(initialRenderContext);
        String string = this.outputMessages.getString(this.getLocaleKey() + ".print");
        this.formatter = new MessageFormat("");
        this.formatter.applyPattern(string);
    }

    public String handleMatch(MatchResult matchResult, FilterContext filterContext) {
        String string = matchResult.group(1);
        string = string.replaceAll("\\.", "");
        string = string.replaceAll(".", "1-");
        string = string.substring(0, string.length() - 1);
        return this.formatter.format(new Object[]{string, matchResult.group(3)});
    }
}

