/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.util;

import griffon.core.ArtifactHandler;
import griffon.core.EventRouter;
import griffon.core.GriffonApplication;
import griffon.core.GriffonArtifact;
import griffon.core.GriffonClass;
import griffon.core.GriffonController;
import griffon.core.LifecycleHandler;
import griffon.core.MVCGroup;
import griffon.core.MVCGroupConfiguration;
import griffon.core.UIThreadManager;
import griffon.core.controller.GriffonControllerAction;
import griffon.core.controller.GriffonControllerActionManager;
import griffon.core.factories.AddonManagerFactory;
import griffon.core.factories.ArtifactManagerFactory;
import griffon.core.factories.EventRouterFactory;
import griffon.core.factories.GriffonControllerActionManagerFactory;
import griffon.core.factories.LogManagerFactory;
import griffon.core.factories.MVCGroupManagerFactory;
import griffon.core.factories.MessageSourceFactory;
import griffon.core.factories.ResourceResolverFactory;
import griffon.core.factories.ResourcesInjectorFactory;
import griffon.core.resources.ResourcesInjector;
import griffon.exceptions.GriffonException;
import griffon.util.ApplicationClassLoader;
import griffon.util.CollectionUtils;
import griffon.util.ConfigReader;
import griffon.util.ConfigUtils;
import griffon.util.GriffonApplicationUtils;
import griffon.util.GriffonExceptionHandler;
import griffon.util.GriffonNameUtils;
import griffon.util.Metadata;
import griffon.util.PlatformHandler;
import griffon.util.RunnableWithArgs;
import griffon.util.RunnableWithArgsClosure;
import griffon.util.logging.LogManager;
import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.ExpandoMetaClassCreationHandle;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovy.util.ConfigObject;
import groovy.util.FactoryBuilderSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.codehaus.griffon.runtime.core.ControllerArtifactHandler;
import org.codehaus.griffon.runtime.core.ModelArtifactHandler;
import org.codehaus.griffon.runtime.core.ServiceArtifactHandler;
import org.codehaus.griffon.runtime.core.ViewArtifactHandler;
import org.codehaus.griffon.runtime.core.controller.NoopGriffonControllerActionManager;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GriffonApplicationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(GriffonApplicationHelper.class);
    private static final Map<String, String> DEFAULT_PLATFORM_HANDLERS = CollectionUtils.map().e("linux", "org.codehaus.griffon.runtime.util.DefaultLinuxPlatformHandler").e("linux64", "org.codehaus.griffon.runtime.util.DefaultLinuxPlatformHandler").e("macosx", "org.codehaus.griffon.runtime.util.DefaultMacOSXPlatformHandler").e("macosx64", "org.codehaus.griffon.runtime.util.DefaultMacOSXPlatformHandler").e("solaris", "org.codehaus.griffon.runtime.util.DefaultSolarisPlatformHandler").e("windows", "org.codehaus.griffon.runtime.util.DefaultWindowsPlatformHandler").e("windows64", "org.codehaus.griffon.runtime.util.DefaultWindowsPlatformHandler");
    private static final String LOCATION_CLASSPATH = "classpath:";
    private static final String LOCATION_FILE = "file:";
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String GROOVY_SUFFIX = ".groovy";
    private static final String KEY_MESSAGE_SOURCE_FACTORY = "app.messageSource.factory";
    private static final String KEY_RESOURCES_INJECTOR_FACTORY = "app.resourceInjector.factory";
    private static final String KEY_EVENT_ROUTER_FACTORY = "app.eventRouter.factory";
    private static final String KEY_ADDON_MANAGER_FACTORY = "app.addonManager.factory";
    private static final String KEY_ARTIFACT_MANAGER_FACTORY = "app.artifactManager.factory";
    private static final String KEY_ACTION_MANAGER_FACTORY = "app.actionManager.factory";
    private static final String KEY_MVCGROUP_MANAGER_FACTORY = "app.mvcGroupManager.factory";
    private static final String KEY_RESOURCE_RESOLVER_FACTORY = "app.resourceResolver.factory";
    private static final String KEY_LOG_MANAGER_FACTORY = "app.logManager.factory";
    private static final String KEY_APP_LIFECYCLE_HANDLER_DISABLE = "app.lifecycle.handler.disable";
    private static final String KEY_GRIFFON_ACTION_MANAGER_DISABLE = "griffon.action.manager.disable";
    private static final String DEFAULT_MESSAGE_SOURCE_FACTORY = "org.codehaus.griffon.runtime.core.factories.DefaultMessageSourceFactory";
    private static final String DEFAULT_RESOURCES_INJECTOR_FACTORY = "org.codehaus.griffon.runtime.core.factories.DefaultResourcesInjectorFactory";
    private static final String DEFAULT_EVENT_ROUTER_FACTORY = "org.codehaus.griffon.runtime.core.factories.DefaultEventRouterFactory";
    private static final String DEFAULT_ADDON_MANAGER_FACTORY = "org.codehaus.griffon.runtime.core.factories.DefaultAddonManagerFactory";
    private static final String DEFAULT_ARTIFACT_MANAGER_FACTORY = "org.codehaus.griffon.runtime.core.factories.DefaultArtifactManagerFactory";
    private static final String DEFAULT_MVCGROUP_MANAGER_FACTORY = "org.codehaus.griffon.runtime.core.factories.DefaultMVCGroupManagerFactory";
    private static final String DEFAULT_RESOURCE_RESOLVER_FACTORY = "org.codehaus.griffon.runtime.core.factories.DefaultResourceResolverFactory";
    private static final String DEFAULT_LOG_MANAGER_FACTORY = "org.codehaus.griffon.runtime.core.factories.DefaultLogManagerFactory";

    public static MetaClass expandoMetaClassFor(Class clazz) {
        MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(clazz);
        if (!(mc instanceof ExpandoMetaClass)) {
            mc = new ExpandoMetaClass(clazz, true, true);
            mc.initialize();
            GroovySystem.getMetaClassRegistry().setMetaClass(clazz, mc);
        }
        return mc;
    }

    public static void prepare(GriffonApplication app) {
        app.getBindings().setVariable("app", (Object)app);
        Metadata.getCurrent().getGriffonStartDir();
        Metadata.getCurrent().getGriffonWorkingDir();
        GriffonApplicationHelper.readAndSetConfiguration(app);
        app.event(GriffonApplication.Event.BOOTSTRAP_START.getName(), Arrays.asList(app));
        GriffonApplicationHelper.initializeMessageSource(app);
        GriffonApplicationHelper.initializeResourceResolver(app);
        GriffonApplicationHelper.initializeResourcesInjector(app);
        GriffonApplicationHelper.initializePropertyEditors(app);
        GriffonApplicationHelper.applyPlatformTweaks(app);
        GriffonApplicationHelper.runLifecycleHandler(GriffonApplication.Lifecycle.INITIALIZE.getName(), app);
        GriffonApplicationHelper.initializeArtifactManager(app);
        GriffonApplicationHelper.initializeMvcManager(app);
        GriffonApplicationHelper.initializeAddonManager(app);
        GriffonApplicationHelper.initializeActionManager(app);
        app.event(GriffonApplication.Event.BOOTSTRAP_END.getName(), Arrays.asList(app));
    }

    private static ConfigObject doLoadConfig(ConfigReader configReader, Class configClass, String configFileName) {
        if (configClass != null) {
            configFileName = configClass.getSimpleName();
        }
        return ConfigUtils.loadConfig(configReader, configClass, configFileName);
    }

    private static ConfigObject doLoadConfigWithI18n(Locale locale, ConfigReader configReader, Class configClass, String configFileName) {
        if (configClass != null) {
            configFileName = configClass.getSimpleName();
        }
        return ConfigUtils.loadConfigWithI18n(locale, configReader, configClass, configFileName);
    }

    private static void readAndSetConfiguration(GriffonApplication app) {
        ConfigReader configReader = ConfigUtils.createConfigReader();
        ConfigObject appConfig = GriffonApplicationHelper.doLoadConfig(configReader, app.getAppConfigClass(), GriffonApplication.Configuration.APPLICATION.getName());
        GriffonApplicationHelper.setApplicationLocale(app, ConfigUtils.getConfigValue((Map)appConfig, "application.locale", Locale.getDefault()));
        appConfig = GriffonApplicationHelper.doLoadConfigWithI18n(app.getLocale(), configReader, app.getAppConfigClass(), GriffonApplication.Configuration.APPLICATION.getName());
        app.setConfig(appConfig);
        app.getConfig().merge(GriffonApplicationHelper.doLoadConfigWithI18n(app.getLocale(), configReader, app.getConfigClass(), GriffonApplication.Configuration.CONFIG.getName()));
        GriffonApplicationHelper.initializeLogManager(app);
        GriffonApplicationHelper.loadExternalConfig(app, configReader);
        GriffonExceptionHandler.configure(app.getConfig().flatten(new LinkedHashMap()));
        app.setBuilderConfig(GriffonApplicationHelper.doLoadConfigWithI18n(app.getLocale(), configReader, app.getBuilderClass(), GriffonApplication.Configuration.BUILDER.getName()));
        GriffonApplicationHelper.initializeEventRouter(app);
        Object events = GriffonApplicationHelper.safeNewInstance(app.getEventsClass(), false);
        if (events != null) {
            app.setEventsConfig(events);
            app.addApplicationEventListener(app.getEventsConfig());
        }
    }

    private static void loadExternalConfig(GriffonApplication app, ConfigReader configReader) {
        List locations = (List)ConfigUtils.getConfigValue((Map)app.getConfig(), "griffon.config.locations", Collections.emptyList());
        for (String location : locations) {
            boolean groovyScriptAllowed = false;
            String parsedLocation = location;
            if (location.startsWith(LOCATION_CLASSPATH)) {
                parsedLocation = location.substring(LOCATION_CLASSPATH.length()).trim();
            } else if (location.startsWith(LOCATION_FILE)) {
                parsedLocation = location.substring(LOCATION_FILE.length()).trim();
            } else {
                groovyScriptAllowed = true;
            }
            if (groovyScriptAllowed) {
                Class<?> locationScriptClass = GriffonApplicationHelper.safeLoadClass(parsedLocation);
                if (locationScriptClass != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Loading external configuration location '" + location + "'.");
                    }
                    app.getConfig().merge(ConfigUtils.loadConfigWithI18n(app.getLocale(), configReader, locationScriptClass, null));
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Skipping invalid external configuration location '" + location + "'.");
                continue;
            }
            if (parsedLocation.endsWith(PROPERTIES_SUFFIX) || parsedLocation.endsWith(GROOVY_SUFFIX)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Loading external configuration location '" + location + "'.");
                }
                app.getConfig().merge(ConfigUtils.loadConfigWithI18n(app.getLocale(), configReader, null, parsedLocation));
                continue;
            }
            if (!LOG.isWarnEnabled()) continue;
            LOG.warn("Skipping invalid external configuration location '" + location + "'.");
        }
    }

    private static void initializeLogManager(GriffonApplication app) {
        String className = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), KEY_LOG_MANAGER_FACTORY, DEFAULT_LOG_MANAGER_FACTORY);
        LogManagerFactory factory = (LogManagerFactory)GriffonApplicationHelper.safeNewInstance(className);
        LogManager logManager = factory.create(app);
        logManager.configure(app.getConfig());
    }

    private static void initializeMessageSource(GriffonApplication app) {
        String className = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), KEY_MESSAGE_SOURCE_FACTORY, DEFAULT_MESSAGE_SOURCE_FACTORY);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using " + className + " as MessageSourceFactory");
        }
        MessageSourceFactory factory = (MessageSourceFactory)GriffonApplicationHelper.safeNewInstance(className);
        InvokerHelper.setProperty((Object)app, (String)"messageSource", (Object)factory.create(app));
    }

    private static void initializeResourceResolver(GriffonApplication app) {
        String className = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), KEY_RESOURCE_RESOLVER_FACTORY, DEFAULT_RESOURCE_RESOLVER_FACTORY);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using " + className + " as ResourceResolverFactory");
        }
        ResourceResolverFactory factory = (ResourceResolverFactory)GriffonApplicationHelper.safeNewInstance(className);
        InvokerHelper.setProperty((Object)app, (String)"resourceResolver", (Object)factory.create(app));
    }

    private static void initializeResourcesInjector(GriffonApplication app) {
        String className = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), KEY_RESOURCES_INJECTOR_FACTORY, DEFAULT_RESOURCES_INJECTOR_FACTORY);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using " + className + " as ResourcesInjectorFactory");
        }
        ResourcesInjectorFactory factory = (ResourcesInjectorFactory)GriffonApplicationHelper.safeNewInstance(className);
        final ResourcesInjector injector = factory.create(app);
        app.addApplicationEventListener(GriffonApplication.Event.NEW_INSTANCE.getName(), new RunnableWithArgs(){

            public void run(Object[] args) {
                Object instance = args[2];
                injector.injectResources(instance);
            }
        });
    }

    private static void initializePropertyEditors(GriffonApplication app) {
        Enumeration<URL> urls = null;
        try {
            urls = ApplicationClassLoader.get().getResources("META-INF/services/" + PropertyEditor.class.getName());
        }
        catch (IOException ioe) {
            return;
        }
        if (urls == null) {
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading " + PropertyEditor.class.getName() + " definitions from " + url);
            }
            try {
                ResourceGroovyMethods.eachLine((URL)url, (Closure)new RunnableWithArgsClosure(new RunnableWithArgs(){

                    public void run(Object[] args) {
                        block4: {
                            String line = (String)args[0];
                            if (line.startsWith("#") || GriffonNameUtils.isBlank(line)) {
                                return;
                            }
                            try {
                                String[] parts = line.trim().split("=");
                                Class<?> targetType = GriffonApplicationHelper.loadClass(parts[0].trim());
                                Class<?> editorClass = GriffonApplicationHelper.loadClass(parts[1].trim());
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Registering " + editorClass.getName() + " as editor for " + targetType.getName());
                                }
                                PropertyEditorManager.registerEditor(targetType, editorClass);
                            }
                            catch (Exception e) {
                                if (!LOG.isWarnEnabled()) break block4;
                                LOG.warn("Could not load PropertyEditor with " + line, GriffonExceptionHandler.sanitize(e));
                            }
                        }
                    }
                }));
            }
            catch (IOException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Could not load PropertyEditor definitions from " + url, GriffonExceptionHandler.sanitize(e));
            }
        }
    }

    private static void initializeEventRouter(GriffonApplication app) {
        InvokerHelper.setProperty((Object)app, (String)"eventRouter", (Object)GriffonApplicationHelper.createEventRouter(app));
    }

    public static EventRouter createEventRouter(GriffonApplication app) {
        String className = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), KEY_EVENT_ROUTER_FACTORY, DEFAULT_EVENT_ROUTER_FACTORY);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using " + className + " as EventRouterFactory");
        }
        EventRouterFactory factory = (EventRouterFactory)GriffonApplicationHelper.safeNewInstance(className);
        return factory.create(app);
    }

    private static void setApplicationLocale(GriffonApplication app, Object localeValue) {
        if (localeValue instanceof Locale) {
            app.setLocale((Locale)localeValue);
        } else if (localeValue instanceof CharSequence) {
            app.setLocale(GriffonApplicationHelper.parseLocale(String.valueOf(localeValue)));
        }
    }

    public static Locale parseLocale(String locale) {
        if (GriffonNameUtils.isBlank(locale)) {
            return Locale.getDefault();
        }
        String[] parts = locale.split("_");
        switch (parts.length) {
            case 1: {
                return new Locale(parts[0]);
            }
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
            case 3: {
                return new Locale(parts[0], parts[1], parts[2]);
            }
        }
        return Locale.getDefault();
    }

    public static void applyPlatformTweaks(GriffonApplication app) {
        String platform = GriffonApplicationUtils.platform;
        String handlerClassName = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), "platform.handler." + platform, DEFAULT_PLATFORM_HANDLERS.get(platform));
        PlatformHandler platformHandler = (PlatformHandler)GriffonApplicationHelper.safeNewInstance(handlerClassName);
        platformHandler.handle(app);
    }

    private static void initializeArtifactManager(GriffonApplication app) {
        if (app.getArtifactManager() == null) {
            String className = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), KEY_ARTIFACT_MANAGER_FACTORY, DEFAULT_ARTIFACT_MANAGER_FACTORY);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using " + className + " as ArtifactManagerFactory");
            }
            ArtifactManagerFactory factory = (ArtifactManagerFactory)GriffonApplicationHelper.safeNewInstance(className);
            InvokerHelper.setProperty((Object)app, (String)"artifactManager", (Object)factory.create(app));
        }
        app.getArtifactManager().registerArtifactHandler(new ModelArtifactHandler(app));
        app.getArtifactManager().registerArtifactHandler(new ViewArtifactHandler(app));
        app.getArtifactManager().registerArtifactHandler(new ControllerArtifactHandler(app));
        if (!ServiceArtifactHandler.isBasicInjectionDisabled()) {
            app.getArtifactManager().registerArtifactHandler(new ServiceArtifactHandler(app));
        }
        GriffonApplicationHelper.loadArtifactHandlers(app);
        app.getArtifactManager().loadArtifactMetadata();
    }

    private static void initializeAddonManager(GriffonApplication app) {
        if (app.getAddonManager() == null) {
            String className = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), KEY_ADDON_MANAGER_FACTORY, DEFAULT_ADDON_MANAGER_FACTORY);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using " + className + " as AddonManagerFactory");
            }
            AddonManagerFactory factory = (AddonManagerFactory)GriffonApplicationHelper.safeNewInstance(className);
            InvokerHelper.setProperty((Object)app, (String)"addonManager", (Object)factory.create(app));
        }
        app.getAddonManager().initialize();
    }

    private static void initializeActionManager(GriffonApplication app) {
        String className;
        block10: {
            InvokerHelper.setProperty((Object)app, (String)"actionManager", (Object)new NoopGriffonControllerActionManager(app));
            boolean disableActionManager = ConfigUtils.getConfigValueAsBoolean((Map)app.getConfig(), KEY_GRIFFON_ACTION_MANAGER_DISABLE, false);
            if (disableActionManager) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("GriffonControllerActionManager is disabled.");
                }
                return;
            }
            className = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), KEY_ACTION_MANAGER_FACTORY, null);
            if (GriffonNameUtils.isBlank(className) || "null".equals(className)) {
                URL url = ApplicationClassLoader.get().getResource("META-INF/services/" + GriffonControllerActionManagerFactory.class.getName());
                if (null == url) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("GriffonControllerActionManager is disabled.");
                    }
                    return;
                }
                try {
                    className = DefaultGroovyMethods.getText((URL)url).trim();
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block10;
                    LOG.debug("Cannot read GriffonControllerActionManager definition from " + url, GriffonExceptionHandler.sanitize(e));
                    className = null;
                }
            }
        }
        if (GriffonNameUtils.isBlank(className)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("GriffonControllerActionManager is disabled.");
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using " + className + " as GriffonControllerActionManagerFactory");
        }
        GriffonControllerActionManagerFactory factory = (GriffonControllerActionManagerFactory)GriffonApplicationHelper.safeNewInstance(className);
        final GriffonControllerActionManager actionManager = factory.create(app);
        InvokerHelper.setProperty((Object)app, (String)"actionManager", (Object)actionManager);
        app.addApplicationEventListener(GriffonApplication.Event.NEW_INSTANCE.getName(), new RunnableWithArgs(){

            public void run(Object[] args) {
                String type = (String)args[1];
                if ("controller".equals(type)) {
                    GriffonController controller = (GriffonController)args[2];
                    actionManager.createActions(controller);
                }
            }
        });
        app.addApplicationEventListener(GriffonApplication.Event.INITIALIZE_MVC_GROUP.getName(), new RunnableWithArgs(){

            public void run(Object[] args) {
                MVCGroupConfiguration groupConfig = (MVCGroupConfiguration)args[0];
                MVCGroup group = (MVCGroup)args[1];
                GriffonController controller = group.getController();
                if (controller == null) {
                    return;
                }
                FactoryBuilderSupport builder = group.getBuilder();
                Map<String, GriffonControllerAction> actions = actionManager.actionsFor(controller);
                for (Map.Entry<String, GriffonControllerAction> action : actions.entrySet()) {
                    String actionKey = actionManager.normalizeName(action.getKey()) + "Action";
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Adding action " + actionKey + " to " + groupConfig.getMvcType() + ":" + group.getMvcId() + ":builder");
                    }
                    builder.setVariable(actionKey, action.getValue().getToolkitAction());
                }
            }
        });
    }

    private static void initializeMvcManager(GriffonApplication app) {
        if (app.getMvcGroupManager() == null) {
            String className = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), KEY_MVCGROUP_MANAGER_FACTORY, DEFAULT_MVCGROUP_MANAGER_FACTORY);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using " + className + " as MVCGroupManagerFactory");
            }
            MVCGroupManagerFactory factory = (MVCGroupManagerFactory)GriffonApplicationHelper.safeNewInstance(className);
            InvokerHelper.setProperty((Object)app, (String)"mvcGroupManager", (Object)factory.create(app));
        }
        LinkedHashMap<String, MVCGroupConfiguration> configurations = new LinkedHashMap<String, MVCGroupConfiguration>();
        Map mvcGroups = (Map)app.getConfig().get((Object)"mvcGroups");
        if (mvcGroups != null) {
            for (Map.Entry groupEntry : mvcGroups.entrySet()) {
                String type = (String)groupEntry.getKey();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding MVC group " + type);
                }
                Map members = (Map)groupEntry.getValue();
                Map<String, Object> configMap = new LinkedHashMap<String, Object>();
                LinkedHashMap<String, String> membersCopy = new LinkedHashMap<String, String>();
                for (Map.Entry o : members.entrySet()) {
                    Map.Entry entry = o;
                    String key = String.valueOf(entry.getKey());
                    if ("config".equals(key) && entry.getValue() instanceof Map) {
                        configMap = (Map)entry.getValue();
                        continue;
                    }
                    membersCopy.put(key, String.valueOf(entry.getValue()));
                }
                configurations.put(type, app.getMvcGroupManager().newMVCGroupConfiguration(type, membersCopy, configMap));
            }
        }
        app.getMvcGroupManager().initialize(configurations);
    }

    private static void loadArtifactHandlers(final GriffonApplication app) {
        Enumeration<URL> urls = null;
        try {
            urls = ApplicationClassLoader.get().getResources("META-INF/services/" + ArtifactHandler.class.getName());
        }
        catch (IOException ioe) {
            return;
        }
        if (urls == null) {
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading " + ArtifactHandler.class.getName() + " definitions from " + url);
            }
            try {
                ResourceGroovyMethods.eachLine((URL)url, (Closure)new RunnableWithArgsClosure(new RunnableWithArgs(){

                    public void run(Object[] args) {
                        block3: {
                            String line = (String)args[0];
                            if (line.startsWith("#") || GriffonNameUtils.isBlank(line)) {
                                return;
                            }
                            try {
                                Class<?> artifactHandlerClass = GriffonApplicationHelper.loadClass(line);
                                Constructor<?> ctor = artifactHandlerClass.getDeclaredConstructor(GriffonApplication.class);
                                ArtifactHandler handler = null;
                                handler = ctor != null ? (ArtifactHandler)ctor.newInstance(app) : (ArtifactHandler)GriffonApplicationHelper.safeNewInstance(artifactHandlerClass);
                                app.getArtifactManager().registerArtifactHandler(handler);
                            }
                            catch (Exception e) {
                                if (!LOG.isWarnEnabled()) break block3;
                                LOG.warn("Could not load ArtifactHandler with " + line, GriffonExceptionHandler.sanitize(e));
                            }
                        }
                    }
                }));
            }
            catch (IOException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Could not load ArtifactHandler from " + url, GriffonExceptionHandler.sanitize(e));
            }
        }
    }

    public static void runLifecycleHandler(String handlerName, GriffonApplication app) {
        boolean skipHandler = ConfigUtils.getConfigValueAsBoolean((Map)app.getConfig(), KEY_APP_LIFECYCLE_HANDLER_DISABLE, false);
        if (skipHandler) {
            if (LOG.isDebugEnabled()) {
                LOG.info("Lifecycle handler '" + handlerName + "' has been disabled. SKIPPING.");
            }
            return;
        }
        Class<?> handlerClass = null;
        try {
            handlerClass = GriffonApplicationHelper.loadConfigurationalClass(handlerName);
        }
        catch (ClassNotFoundException cnfe) {
            if (cnfe.getMessage().equals(handlerName)) {
                return;
            }
            throw new GriffonException(cnfe);
        }
        if (Script.class.isAssignableFrom(handlerClass)) {
            GriffonApplicationHelper.doRunScript(handlerName, handlerClass, app);
        } else if (LifecycleHandler.class.isAssignableFrom(handlerClass)) {
            GriffonApplicationHelper.doRunLifecycleHandler(handlerName, handlerClass, app);
        }
    }

    private static void doRunScript(String scriptName, Class handlerClass, GriffonApplication app) {
        Script script = (Script)GriffonApplicationHelper.safeNewInstance(handlerClass);
        script.setBinding(app.getBindings());
        UIThreadManager.enhance(script);
        if (LOG.isInfoEnabled()) {
            LOG.info("Running lifecycle handler (script) '" + scriptName + "'");
        }
        UIThreadManager.getInstance().executeSync(script);
    }

    private static void doRunLifecycleHandler(String handlerName, Class handlerClass, GriffonApplication app) {
        LifecycleHandler handler = (LifecycleHandler)GriffonApplicationHelper.safeNewInstance(handlerClass);
        if (LOG.isInfoEnabled()) {
            LOG.info("Running lifecycle handler (class) '" + handlerName + "'");
        }
        UIThreadManager.getInstance().executeSync(handler);
    }

    public static Object newInstance(GriffonApplication app, Class klass) {
        return GriffonApplicationHelper.newInstance(app, klass, "");
    }

    public static Object newInstance(GriffonApplication app, Class klass, String type) {
        if (GriffonNameUtils.isBlank(type)) {
            type = "";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Instantiating " + klass.getName() + " with type '" + type + "'");
        }
        Object instance = null;
        try {
            instance = klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new GriffonException(e);
        }
        catch (IllegalAccessException e) {
            throw new GriffonException(e);
        }
        if (instance != null) {
            GriffonClass griffonClass = app.getArtifactManager().findGriffonClass(klass);
            MetaClass mc = griffonClass != null ? griffonClass.getMetaClass() : GriffonApplicationHelper.expandoMetaClassFor(klass);
            GriffonApplicationHelper.enhance(app, klass, mc, instance);
            app.event(GriffonApplication.Event.NEW_INSTANCE.getName(), Arrays.asList(klass, type, instance));
        }
        return instance;
    }

    public static void enhance(GriffonApplication app, Class klass, MetaClass mc, Object instance) {
        block5: {
            try {
                InvokerHelper.invokeMethod((Object)instance, (String)"setApp", (Object)app);
            }
            catch (MissingMethodException mme) {
                try {
                    InvokerHelper.setProperty((Object)instance, (String)"app", (Object)app);
                }
                catch (MissingPropertyException mpe) {
                    if (!(mc instanceof ExpandoMetaClass)) break block5;
                    ((ExpandoMetaClass)mc).registerBeanProperty("app", (Object)app);
                }
            }
        }
        if (!GriffonArtifact.class.isAssignableFrom(klass)) {
            UIThreadManager.enhance(mc);
        }
    }

    public static Class<?> loadConfigurationalClass(String className) throws ClassNotFoundException {
        if (!className.contains(".")) {
            String fixedClassName = "config." + className;
            try {
                return GriffonApplicationHelper.loadClass(fixedClassName);
            }
            catch (ClassNotFoundException cnfe) {
                if (cnfe.getMessage().equals(fixedClassName)) {
                    return GriffonApplicationHelper.loadClass(className);
                }
                throw new GriffonException(cnfe);
            }
        }
        return GriffonApplicationHelper.loadClass(className);
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassNotFoundException cnfe = null;
        ClassLoader cl = GriffonApplicationHelper.class.getClassLoader();
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            cnfe = e;
            cl = ApplicationClassLoader.get();
            try {
                return cl.loadClass(className);
            }
            catch (ClassNotFoundException e2) {
                cnfe = e2;
                if (cnfe != null) {
                    throw cnfe;
                }
                return null;
            }
        }
    }

    public static Class<?> safeLoadClass(String className) {
        try {
            return GriffonApplicationHelper.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Object safeNewInstance(String className) {
        try {
            return GriffonApplicationHelper.loadClass(className).newInstance();
        }
        catch (Exception e) {
            GriffonExceptionHandler.handleThrowable(e);
            return null;
        }
    }

    public static Object safeNewInstance(Class<?> clazz) {
        return GriffonApplicationHelper.safeNewInstance(clazz, true);
    }

    public static Object safeNewInstance(Class<?> clazz, boolean logException) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            if (logException) {
                GriffonExceptionHandler.handleThrowable(e);
            }
            return null;
        }
    }

    static {
        ExpandoMetaClassCreationHandle.enable();
    }
}

