/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.util;

import griffon.core.GriffonApplication;
import griffon.util.ApplicationClassLoader;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import griffon.util.PlatformHandler;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.net.URL;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class DefaultMacOSXPlatformHandler
implements PlatformHandler {
    private static Object macOSXHandler = null;

    public void handle(GriffonApplication app) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        String title = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), "application.title", "Griffon");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", GriffonNameUtils.capitalize(title));
        if (macOSXHandler == null) {
            try {
                Binding bindings = new Binding();
                bindings.setVariable("app", (Object)app);
                bindings.setVariable("skipAbout", (Object)ConfigUtils.getConfigValueAsBoolean((Map)app.getConfig(), "osx.noabout", false));
                bindings.setVariable("skipPrefs", (Object)ConfigUtils.getConfigValueAsBoolean((Map)app.getConfig(), "osx.noprefs", false));
                bindings.setVariable("skipQuit", (Object)ConfigUtils.getConfigValueAsBoolean((Map)app.getConfig(), "osx.noquit", false));
                GroovyShell shell = new GroovyShell(ApplicationClassLoader.get(), bindings);
                String resourceName = "META-INF/" + DefaultMacOSXPlatformHandler.class.getName() + ".txt";
                URL scriptUrl = ApplicationClassLoader.get().getResource(resourceName);
                macOSXHandler = shell.evaluate(DefaultGroovyMethods.getText((URL)scriptUrl));
            }
            catch (Throwable t) {
                t.printStackTrace(System.out);
            }
        }
    }
}

