/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.util;

import griffon.util.ApplicationHolder;
import griffon.util.GriffonNameUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.codehaus.griffon.runtime.util.GroovyScriptResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeResourceBundle
extends ResourceBundle {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeResourceBundle.class);
    private final ResourceBundle[] bundles;
    private final List<String> keys = new ArrayList<String>();

    public static ResourceBundle create(String basename) {
        return CompositeResourceBundle.create(basename, Locale.getDefault());
    }

    public static ResourceBundle create(String basename, Locale locale) {
        if (GriffonNameUtils.isBlank(basename)) {
            throw new IllegalArgumentException("Cannot create CompositeResourceBundle with basename = '" + basename + "'");
        }
        String[] combinations = new String[]{locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant(), locale.getLanguage() + "_" + locale.getCountry(), locale.getLanguage()};
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        for (String suffix : combinations) {
            if (suffix.endsWith("_")) continue;
            bundles.addAll(CompositeResourceBundle.loadBundleFromProperties(basename + "_" + suffix));
            bundles.addAll(CompositeResourceBundle.loadBundleFromScript(basename + "_" + suffix));
        }
        bundles.addAll(CompositeResourceBundle.loadBundleFromProperties(basename));
        bundles.addAll(CompositeResourceBundle.loadBundleFromScript(basename));
        return new CompositeResourceBundle(bundles);
    }

    private static Collection<ResourceBundle> loadBundleFromProperties(String fileName) {
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        for (URL resource : ApplicationHolder.getApplication().getResources(fileName + ".properties")) {
            if (null == resource) continue;
            try {
                bundles.add(new PropertyResourceBundle(resource.openStream()));
            }
            catch (IOException e) {}
        }
        return bundles;
    }

    private static Collection<ResourceBundle> loadBundleFromScript(String fileName) {
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        for (URL resource : ApplicationHolder.getApplication().getResources(fileName + ".groovy")) {
            if (null == resource) continue;
            bundles.add(new GroovyScriptResourceBundle(resource));
        }
        return bundles;
    }

    public CompositeResourceBundle(List<ResourceBundle> bundles) {
        this(CompositeResourceBundle.toResourceBundleArray(bundles));
    }

    public CompositeResourceBundle(ResourceBundle[] bundles) {
        this.bundles = bundles;
        for (ResourceBundle bundle : bundles) {
            Enumeration<String> ks = bundle.getKeys();
            while (ks.hasMoreElements()) {
                String key = ks.nextElement();
                if (this.keys.contains(key)) continue;
                this.keys.add(key);
            }
        }
    }

    @Override
    protected Object handleGetObject(String key) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Searching key=" + key);
        }
        for (ResourceBundle bundle : this.bundles) {
            try {
                Object value = bundle.getObject(key);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Bundle " + bundle + "; key=" + key + "; value='" + value + "'");
                }
                if (value == null) continue;
                return value;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Enumeration<String> getKeys() {
        return new IteratorAsEnumeration<String>(this.keys.iterator());
    }

    private static ResourceBundle[] toResourceBundleArray(List<ResourceBundle> bundles) {
        if (null == bundles || bundles.isEmpty()) {
            return new ResourceBundle[0];
        }
        return bundles.toArray(new ResourceBundle[bundles.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IteratorAsEnumeration<E>
    implements Enumeration<E> {
        private final Iterator<E> iterator;

        public IteratorAsEnumeration(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public E nextElement() {
            return this.iterator.next();
        }
    }
}

