/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.logging;

import griffon.core.GriffonApplication;
import griffon.util.ApplicationHolder;
import java.util.Arrays;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class GriffonApplicationEventAppender
extends AppenderSkeleton {
    private static final String EVENT_NAME = "LogEvent";

    public GriffonApplicationEventAppender(Layout layout) {
        this.layout = layout;
    }

    protected void append(LoggingEvent event) {
        Throwable throwable = null;
        ThrowableInformation throwableInfo = event.getThrowableInformation();
        if (throwableInfo != null) {
            throwable = throwableInfo.getThrowable();
        }
        this.fireApplicationEvent(event.getLevel(), this.asString(event), throwable);
    }

    private String asString(LoggingEvent event) {
        String[] s;
        StringBuilder builder = new StringBuilder(this.layout.format(event));
        if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
            int len = s.length;
            for (int i = 0; i < len; ++i) {
                builder.append(s[i]);
                builder.append(Layout.LINE_SEP);
            }
        }
        return builder.toString();
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    private void fireApplicationEvent(Level level, String message, Throwable throwable) {
        GriffonApplication app = ApplicationHolder.getApplication();
        if (app != null) {
            app.eventAsync(EVENT_NAME, Arrays.asList(level.toString(), message, throwable));
        }
    }
}

