/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.resources;

import griffon.core.GriffonApplication;
import griffon.core.resources.InjectedResource;
import griffon.core.resources.ResourcesInjector;
import griffon.util.GriffonExceptionHandler;
import griffon.util.GriffonNameUtils;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourcesInjector
implements ResourcesInjector {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractResourcesInjector.class);
    private final GriffonApplication app;

    public AbstractResourcesInjector(GriffonApplication app) {
        this.app = app;
    }

    @Override
    public GriffonApplication getApp() {
        return this.app;
    }

    @Override
    public void injectResources(Object instance) {
        if (null == instance) {
            return;
        }
        Class<?> klass = instance.getClass();
        do {
            this.doResourceInjection(klass, instance);
        } while (null != (klass = klass.getSuperclass()));
    }

    protected boolean doResourceInjection(Class klass, Object instance) {
        boolean injected = false;
        for (Field field : klass.getDeclaredFields()) {
            InjectedResource annotation;
            if (field.isSynthetic() || null == (annotation = field.getAnnotation(InjectedResource.class))) continue;
            String fqFieldName = field.getDeclaringClass().getName().replace('$', '.') + "." + field.getName();
            String key = annotation.key();
            Object[] args = annotation.args();
            String defaultValue = annotation.defaultValue();
            if (GriffonNameUtils.isBlank(key)) {
                key = fqFieldName;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Field " + fqFieldName + " of instance " + instance + " [key='" + key + "', args='" + Arrays.toString(args) + "', defaultValue='" + defaultValue + "'] is marked for resource injection.");
            }
            Object value = null;
            value = GriffonNameUtils.isBlank(defaultValue) ? this.resolveResource(key, (String[])args) : this.resolveResource(key, (String[])args, defaultValue);
            if (null != value) {
                if (!field.getType().isAssignableFrom(value.getClass())) {
                    value = this.convertValue(field.getType(), value);
                }
                this.setFieldValue(instance, field, value, fqFieldName);
            }
            injected = true;
        }
        return injected;
    }

    protected abstract Object resolveResource(String var1, String[] var2);

    protected abstract Object resolveResource(String var1, String[] var2, String var3);

    protected Object convertValue(Class<?> type, Object value) {
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(type);
        if (null == propertyEditor) {
            return value;
        }
        if (value instanceof CharSequence) {
            propertyEditor.setAsText(String.valueOf(value));
        } else {
            propertyEditor.setValue(value);
        }
        return propertyEditor.getValue();
    }

    protected void setFieldValue(Object instance, Field field, Object value, String fqFieldName) {
        block2: {
            try {
                field.setAccessible(true);
                field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn("Cannot set value on field " + fqFieldName + " of instance " + instance, GriffonExceptionHandler.sanitize(e));
            }
        }
    }
}

