/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.resources;

import griffon.core.resources.NoSuchResourceException;
import griffon.core.resources.ResourceResolver;
import griffon.util.CallableWithArgs;
import groovy.lang.Closure;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceResolver
implements ResourceResolver {
    protected static final Object[] EMPTY_OBJECT_ARGS = new Object[0];

    @Override
    public Object resolveResource(String key) throws NoSuchResourceException {
        return this.resolveResource(key, EMPTY_OBJECT_ARGS, Locale.getDefault());
    }

    @Override
    public Object resolveResource(String key, Locale locale) throws NoSuchResourceException {
        return this.resolveResource(key, EMPTY_OBJECT_ARGS, locale);
    }

    @Override
    public Object resolveResource(String key, Object[] args) throws NoSuchResourceException {
        return this.resolveResource(key, args, Locale.getDefault());
    }

    @Override
    public Object resolveResource(String key, List args) throws NoSuchResourceException {
        return this.resolveResource(key, this.toObjectArray(args), Locale.getDefault());
    }

    @Override
    public Object resolveResource(String key, List args, Locale locale) throws NoSuchResourceException {
        return this.resolveResource(key, this.toObjectArray(args), locale);
    }

    @Override
    public Object resolveResource(String key, Object defaultValue) {
        return this.resolveResource(key, EMPTY_OBJECT_ARGS, defaultValue, Locale.getDefault());
    }

    @Override
    public Object resolveResource(String key, Object defaultValue, Locale locale) {
        return this.resolveResource(key, EMPTY_OBJECT_ARGS, defaultValue, locale);
    }

    @Override
    public Object resolveResource(String key, Object[] args, Object defaultValue) {
        return this.resolveResource(key, args, defaultValue, Locale.getDefault());
    }

    @Override
    public Object resolveResource(String key, Object[] args, Object defaultValue, Locale locale) {
        try {
            return this.resolveResource(key, args, locale);
        }
        catch (NoSuchResourceException nsme) {
            return defaultValue;
        }
    }

    @Override
    public Object resolveResource(String key, Map<String, Object> args) throws NoSuchResourceException {
        return this.resolveResource(key, args, Locale.getDefault());
    }

    @Override
    public Object resolveResource(String key, Map<String, Object> args, Object defaultValue) {
        return this.resolveResource(key, args, defaultValue, Locale.getDefault());
    }

    @Override
    public Object resolveResource(String key, Map<String, Object> args, Object defaultValue, Locale locale) {
        try {
            return this.resolveResource(key, args, locale);
        }
        catch (NoSuchResourceException nsme) {
            return defaultValue;
        }
    }

    @Override
    public Object resolveResource(String key, Map<String, Object> args, Locale locale) throws NoSuchResourceException {
        Object resource = this.resolveResourceInternal(key, locale);
        return this.evalResourceWithArguments(resource, args);
    }

    @Override
    public Object resolveResource(String key, List args, Object defaultValue) {
        return this.resolveResource(key, this.toObjectArray(args), defaultValue, Locale.getDefault());
    }

    @Override
    public Object resolveResource(String key, List args, Object defaultValue, Locale locale) {
        return this.resolveResource(key, this.toObjectArray(args), defaultValue, locale);
    }

    @Override
    public Object resolveResource(String key, Object[] args, Locale locale) throws NoSuchResourceException {
        if (null == args) {
            args = EMPTY_OBJECT_ARGS;
        }
        if (null == locale) {
            locale = Locale.getDefault();
        }
        try {
            Object resource = this.resolveResourceInternal(key, locale);
            return this.evalResourceWithArguments(resource, args);
        }
        catch (MissingResourceException e) {
            throw new NoSuchResourceException(key, locale);
        }
    }

    protected Object evalResourceWithArguments(Object resource, Object[] args) {
        if (resource instanceof Closure) {
            Closure closure = (Closure)resource;
            return closure.call(args);
        }
        if (resource instanceof CallableWithArgs) {
            CallableWithArgs callable = (CallableWithArgs)resource;
            return callable.call(args);
        }
        if (resource instanceof CharSequence) {
            return this.formatResource(String.valueOf(resource), args);
        }
        return resource;
    }

    protected Object evalResourceWithArguments(Object resource, Map<String, Object> args) {
        if (resource instanceof Closure) {
            Closure closure = (Closure)resource;
            return closure.call(args);
        }
        if (resource instanceof CallableWithArgs) {
            CallableWithArgs callable = (CallableWithArgs)resource;
            return callable.call(new Object[]{args});
        }
        if (resource instanceof CharSequence) {
            return this.formatResource(String.valueOf(resource), args);
        }
        return resource;
    }

    protected String formatResource(String resource, Object[] args) {
        return MessageFormat.format(resource, args);
    }

    protected String formatResource(String resource, Map<String, Object> args) {
        for (Map.Entry<String, Object> variable : args.entrySet()) {
            String var = variable.getKey();
            String value = variable.getValue() != null ? variable.getValue().toString() : null;
            if (value == null) continue;
            resource = resource.replace("{:" + var + "}", value);
        }
        return resource;
    }

    protected abstract Object resolveResourceInternal(String var1, Locale var2) throws NoSuchResourceException;

    protected Object[] toObjectArray(List args) {
        if (null == args || args.isEmpty()) {
            return EMPTY_OBJECT_ARGS;
        }
        return args.toArray(new Object[args.size()]);
    }
}

