/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPropertyFetcher {
    private final Class<?> clazz;
    final Map<String, PropertyFetcher> staticFetchers = new LinkedHashMap<String, PropertyFetcher>();
    final Map<String, PropertyFetcher> instanceFetchers = new LinkedHashMap<String, PropertyFetcher>();
    private final ReferenceInstanceCallback callback;
    private PropertyDescriptor[] propertyDescriptors;
    private String[] propertiesWithFields;
    private static Map<Class<?>, ClassPropertyFetcher> cachedClassPropertyFetchers = new ConcurrentHashMap();

    public static void clearClassPropertyFetcherCache() {
        cachedClassPropertyFetchers.clear();
    }

    public static ClassPropertyFetcher forClass(Class<?> c) {
        return ClassPropertyFetcher.forClass(c, null);
    }

    public static ClassPropertyFetcher forClass(final Class<?> c, ReferenceInstanceCallback callback) {
        ClassPropertyFetcher cpf = cachedClassPropertyFetchers.get(c);
        if (cpf == null) {
            if (callback == null) {
                callback = new ReferenceInstanceCallback(){
                    private Object o;

                    public Object getReferenceInstance() {
                        if (this.o == null) {
                            this.o = GriffonClassUtils.instantiateClass(c);
                        }
                        return this.o;
                    }
                };
            }
            cpf = new ClassPropertyFetcher(c, callback);
            cachedClassPropertyFetchers.put(c, cpf);
        }
        return cpf;
    }

    ClassPropertyFetcher(Class<?> clazz, ReferenceInstanceCallback callback) {
        this.clazz = clazz;
        this.callback = callback;
        this.init();
    }

    public Object getReference() {
        if (this.callback != null) {
            return this.callback.getReferenceInstance();
        }
        return null;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public boolean isReadableProperty(String name) {
        return this.staticFetchers.containsKey(name) || this.instanceFetchers.containsKey(name);
    }

    public String[] getPropertiesWithFields() {
        return this.propertiesWithFields;
    }

    private void init() {
        FieldCallback fieldCallback = new FieldCallback(){

            public void doWith(Field field) {
                if (field.isSynthetic()) {
                    return;
                }
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers)) {
                    return;
                }
                String name = field.getName();
                if (name.indexOf(36) == -1) {
                    boolean staticField = Modifier.isStatic(modifiers);
                    if (staticField) {
                        ClassPropertyFetcher.this.staticFetchers.put(name, new FieldReaderFetcher(field, staticField));
                    } else {
                        ClassPropertyFetcher.this.instanceFetchers.put(name, new FieldReaderFetcher(field, staticField));
                    }
                }
            }
        };
        MethodCallback methodCallback = new MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                String name;
                if (method.isSynthetic()) {
                    return;
                }
                if (!Modifier.isPublic(method.getModifiers())) {
                    return;
                }
                if (Modifier.isStatic(method.getModifiers()) && method.getReturnType() != Void.class && method.getParameterTypes().length == 0 && (name = method.getName()).indexOf(36) == -1) {
                    if (name.length() > 3 && name.startsWith("get") && Character.isUpperCase(name.charAt(3))) {
                        name = name.substring(3);
                    } else if (name.length() > 2 && name.startsWith("is") && Character.isUpperCase(name.charAt(2)) && (method.getReturnType() == Boolean.class || method.getReturnType() == Boolean.TYPE)) {
                        name = name.substring(2);
                    }
                    GetterPropertyFetcher fetcher = new GetterPropertyFetcher(method, true);
                    ClassPropertyFetcher.this.staticFetchers.put(name, fetcher);
                    ClassPropertyFetcher.this.staticFetchers.put(GriffonNameUtils.uncapitalize(name), fetcher);
                }
            }
        };
        List<Class<?>> allClasses = this.resolveAllClasses(this.clazz);
        for (Class<?> c : allClasses) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                try {
                    fieldCallback.doWith(field);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + field.getName() + "': " + ex);
                }
            }
            Method[] methods = c.getDeclaredMethods();
            for (Method method : methods) {
                try {
                    methodCallback.doWith(method);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access method '" + method.getName() + "': " + ex);
                }
            }
        }
        for (PropertyDescriptor desc : this.propertyDescriptors = GriffonClassUtils.getPropertyDescriptors(this.clazz)) {
            Method readMethod = desc.getReadMethod();
            if (readMethod == null) continue;
            boolean staticReadMethod = Modifier.isStatic(readMethod.getModifiers());
            if (staticReadMethod) {
                this.staticFetchers.put(desc.getName(), new GetterPropertyFetcher(readMethod, staticReadMethod));
                continue;
            }
            this.instanceFetchers.put(desc.getName(), new GetterPropertyFetcher(readMethod, staticReadMethod));
        }
        ArrayList<String> properties = new ArrayList<String>();
        for (Class<?> c : allClasses) {
            ArrayList<String> props = new ArrayList<String>();
            for (PropertyDescriptor p : GriffonClassUtils.getPropertyDescriptors(this.clazz)) {
                props.add(p.getName());
            }
            for (Field field : c.getDeclaredFields()) {
                String fieldName;
                int modifiers;
                if (field.isSynthetic() || !Modifier.isPrivate(modifiers = field.getModifiers()) || Modifier.isStatic(modifiers) || "class".equals(fieldName = field.getName()) || "metaClass".equals(fieldName) || fieldName.indexOf(36) != -1 || !props.contains(fieldName)) continue;
                properties.add(fieldName);
            }
        }
        this.propertiesWithFields = properties.toArray(new String[properties.size()]);
    }

    private List<Class<?>> resolveAllClasses(Class<?> c) {
        ArrayList list = new ArrayList();
        for (Class<?> currentClass = c; currentClass != null; currentClass = currentClass.getSuperclass()) {
            list.add(currentClass);
        }
        Collections.reverse(list);
        return list;
    }

    public Object getPropertyValue(String name) {
        return this.getPropertyValue(name, false);
    }

    public Object getPropertyValue(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = this.resolveFetcher(name, onlyInstanceProperties);
        return this.getPropertyValueWithFetcher(name, fetcher);
    }

    private Object getPropertyValueWithFetcher(String name, PropertyFetcher fetcher) {
        if (fetcher != null) {
            try {
                return fetcher.get(this.callback);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public <T> T getStaticPropertyValue(String name, Class<T> c) {
        PropertyFetcher fetcher = this.staticFetchers.get(name);
        if (fetcher != null) {
            Object v = this.getPropertyValueWithFetcher(name, fetcher);
            return this.returnOnlyIfInstanceOf(v, c);
        }
        return null;
    }

    public <T> T getPropertyValue(String name, Class<T> c) {
        return this.returnOnlyIfInstanceOf(this.getPropertyValue(name, false), c);
    }

    private <T> T returnOnlyIfInstanceOf(Object value, Class<T> type) {
        if (value != null && (type == Object.class || GriffonClassUtils.isGroovyAssignableFrom(type, value.getClass()))) {
            return (T)value;
        }
        return null;
    }

    private PropertyFetcher resolveFetcher(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = null;
        if (!onlyInstanceProperties) {
            fetcher = this.staticFetchers.get(name);
        }
        if (fetcher == null) {
            fetcher = this.instanceFetchers.get(name);
        }
        return fetcher;
    }

    public Class<?> getPropertyType(String name) {
        return this.getPropertyType(name, false);
    }

    public Class<?> getPropertyType(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = this.resolveFetcher(name, onlyInstanceProperties);
        if (fetcher != null) {
            return fetcher.getPropertyType(name);
        }
        return null;
    }

    private static void makeAccessible(AccessibleObject obj) {
        if (!obj.isAccessible()) {
            try {
                obj.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }

    static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FieldReaderFetcher
    implements PropertyFetcher {
        private final Field field;
        private final boolean staticField;

        public FieldReaderFetcher(Field field, boolean staticField) {
            this.field = field;
            this.staticField = staticField;
            ClassPropertyFetcher.makeAccessible(field);
        }

        @Override
        public Object get(ReferenceInstanceCallback callback) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.staticField) {
                return this.field.get(null);
            }
            if (callback != null) {
                return this.field.get(callback.getReferenceInstance());
            }
            return null;
        }

        @Override
        public Class<?> getPropertyType(String name) {
            return this.field.getType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GetterPropertyFetcher
    implements PropertyFetcher {
        private final Method readMethod;
        private final boolean staticMethod;

        GetterPropertyFetcher(Method readMethod, boolean staticMethod) {
            this.readMethod = readMethod;
            this.staticMethod = staticMethod;
            ClassPropertyFetcher.makeAccessible(readMethod);
        }

        @Override
        public Object get(ReferenceInstanceCallback callback) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.staticMethod) {
                return this.readMethod.invoke(null, new Object[0]);
            }
            if (callback != null) {
                return this.readMethod.invoke(callback.getReferenceInstance(), new Object[0]);
            }
            return null;
        }

        @Override
        public Class<?> getPropertyType(String name) {
            return this.readMethod.getReturnType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface PropertyFetcher {
        public Object get(ReferenceInstanceCallback var1) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

        public Class<?> getPropertyType(String var1);
    }

    public static interface ReferenceInstanceCallback {
        public Object getReferenceInstance();
    }
}

