/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.GriffonApplication;
import griffon.core.GriffonService;
import griffon.core.ServiceManager;
import griffon.core.ShutdownHandler;
import griffon.util.ConfigUtils;
import groovy.util.ConfigObject;
import java.util.Arrays;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceManager
implements ServiceManager {
    private final GriffonApplication app;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServiceManager.class);

    public AbstractServiceManager(GriffonApplication app) {
        this.app = app;
        app.addShutdownHandler(new ServiceManagerShutdownHandler());
    }

    public GriffonApplication getApp() {
        return this.app;
    }

    public GriffonService findService(String name) {
        GriffonService service;
        if (!name.endsWith("Service")) {
            name = name + "Service";
        }
        if (null == (service = this.doFindService(name))) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Instantiating service identified by '" + name + "'");
            }
            if (null != (service = this.doInstantiateService(name))) {
                InvokerHelper.setProperty((Object)service, (String)"app", (Object)this.getApp());
                this.doSetConfigProperties(name, service);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Initializing service identified by '" + name + "'");
                }
                service.serviceInit();
            }
        }
        return service;
    }

    protected void doSetConfigProperties(String name, GriffonService service) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Applying configuration to service identified by '" + name + "'");
        }
        name = name.substring(0, name.length() - "Service".length());
        ConfigObject config = (ConfigObject)ConfigUtils.getConfigValue((Map)this.getApp().getConfig(), "services." + name);
        if (config != null && !config.isEmpty()) {
            InvokerHelper.setProperties((Object)service, (Map)config);
        }
    }

    protected abstract GriffonService doFindService(String var1);

    protected abstract GriffonService doInstantiateService(String var1);

    private class ServiceManagerShutdownHandler
    implements ShutdownHandler {
        private ServiceManagerShutdownHandler() {
        }

        public boolean canShutdown(GriffonApplication application) {
            return true;
        }

        public void onShutdown(GriffonApplication application) {
            for (Map.Entry<String, GriffonService> entry : AbstractServiceManager.this.getServices().entrySet()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Destroying service identified by '" + entry.getKey() + "'");
                }
                GriffonService service = entry.getValue();
                application.removeApplicationEventListener(service);
                application.event(GriffonApplication.Event.DESTROY_INSTANCE.getName(), Arrays.asList(service.getClass(), service.getGriffonClass().getArtifactType(), service));
                service.serviceDestroy();
            }
        }
    }
}

