/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.cli.shell.command;

import griffon.util.BuildSettings;
import griffon.util.BuildSettingsHolder;
import java.io.File;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;
import org.codehaus.griffon.cli.shell.GriffonShellContext;
import org.fusesource.jansi.Ansi;

@Command(scope="shell", name="settings", description="Displays current Griffon settings")
public class SettingsCommand
extends AbstractAction {
    @Option(name="--reload", description="Reads all settings from config files again.")
    protected boolean reload;

    protected Object doExecute() throws Exception {
        BuildSettings settings = BuildSettingsHolder.getSettings();
        if (this.reload) {
            settings.resetConfig();
            GriffonShellContext.getGriffonScriptRunner().setLoggingOptions();
            GriffonShellContext.setGantBinding(null);
        }
        int maxNameLen = 25;
        System.out.println("Griffon");
        this.printValue("Griffon version", maxNameLen, settings.getGriffonVersion());
        this.printValue("Griffon home", maxNameLen, settings.getGriffonHome().getAbsolutePath());
        this.printValue("Groovy version", maxNameLen, settings.getGroovyVersion());
        this.printValue("Basedir", maxNameLen, settings.getBaseDir().getAbsolutePath());
        URL configFile = settings.getConfig().getConfigFile();
        String configHeader = "Config files";
        if (configFile != null) {
            this.printValue(configHeader, maxNameLen, configFile.getFile());
            configHeader = "";
        }
        this.printValue(configHeader, maxNameLen, new File(settings.getUserHome() + "/.griffon/settings.groovy").getAbsolutePath());
        this.printValue("", maxNameLen, new File(settings.getUserHome() + "/.griffon/ProxySettings.groovy").getAbsolutePath());
        System.out.println();
        Map map = settings.getConfig().flatten(new LinkedHashMap());
        TreeSet keys = new TreeSet();
        keys.addAll(map.keySet());
        System.out.println("Settings");
        for (String key : keys) {
            Object value = map.get(key);
            if (!this.isPrintableValue(value)) continue;
            this.printValue(key, value.toString());
        }
        System.out.println();
        return null;
    }

    private boolean isPrintableValue(Object value) {
        return value instanceof CharSequence || value instanceof Boolean || value instanceof Number || value instanceof File || value instanceof URL;
    }

    protected void printValue(String name, String value) {
        System.out.println(Ansi.ansi().a("  ").a(Ansi.Attribute.INTENSITY_BOLD).a(name).a(Ansi.Attribute.RESET).a(" = ").a(value).toString());
    }

    private void printValue(String name, int pad, String value) {
        if (value == null) {
            value = "<not set>";
        } else if (value.equals("")) {
            value = "<empty>";
        }
        System.out.println(Ansi.ansi().a("  ").a(Ansi.Attribute.INTENSITY_BOLD).a(name).a(this.spaces(pad - name.length())).a(Ansi.Attribute.RESET).a("   ").a(value).toString());
    }

    private String spaces(int nb) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nb; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

