/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.cli.shell.command;

import gant.Gant;
import griffon.util.BuildSettings;
import griffon.util.BuildSettingsHolder;
import griffon.util.Environment;
import griffon.util.GriffonExceptionHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.AbstractAction;
import org.codehaus.gant.GantBinding;
import org.codehaus.griffon.cli.GriffonScriptRunner;
import org.codehaus.griffon.cli.ScriptExitException;
import org.codehaus.griffon.cli.shell.GriffonShellContext;
import org.fusesource.jansi.Ansi;

@Command(scope="shell", name="resolve-dependencies", description="Resolves plugin dependencies")
public class ResolveDependenciesCommand
extends AbstractAction {
    public Object doExecute() throws Exception {
        ResolveDependenciesCommand.resolveDependencies(this.session);
        return null;
    }

    public static void resolveDependencies(CommandSession session) {
        block4: {
            GriffonScriptRunner runner = GriffonShellContext.getGriffonScriptRunner();
            GantBinding binding = GriffonShellContext.getGantBinding();
            if (binding == null) {
                binding = new GantBinding();
                GriffonShellContext.setGantBinding(binding);
            }
            String scriptName = "_GriffonResolveDependencies";
            BuildSettings settings = BuildSettingsHolder.getSettings();
            File scriptFile = new File(settings.getGriffonHome(), "scripts/" + scriptName + ".groovy");
            System.setProperty("griffon.env", Environment.DEVELOPMENT.getName());
            settings.setGriffonEnv(Environment.DEVELOPMENT.getName());
            binding.setVariable("scriptEnv", (Object)Environment.DEVELOPMENT.getName());
            binding.setVariable("scriptName", (Object)scriptName);
            binding.setVariable("scriptFile", (Object)scriptFile);
            binding.setVariable("argsMap", new LinkedHashMap());
            LinkedHashMap<String, String> sysProperties = new LinkedHashMap<String, String>();
            sysProperties.putAll(GriffonShellContext.getInitialSystemProperties());
            sysProperties.putAll(GriffonShellContext.getSystemProperties());
            binding.setVariable("sysProperties", sysProperties);
            binding.setVariable("runFrameworkDependencyResolution", (Object)Boolean.TRUE);
            binding.setVariable("runDependencyResolution", (Object)Boolean.TRUE);
            Gant gant = runner.createGantInstance(binding);
            ArrayList<String> targets = new ArrayList<String>();
            targets.add("resolveFrameworkDependencies");
            targets.add("resolveDependencies");
            try {
                runner.executeWithGantInstance(gant, binding, targets);
            }
            catch (ScriptExitException see) {
            }
            catch (RuntimeException e) {
                GriffonExceptionHandler.sanitize((Throwable)e);
                if (e instanceof ScriptExitException || e.getCause() instanceof ScriptExitException) break block4;
                session.getConsole().print(Ansi.ansi().fg(Ansi.Color.RED).toString());
                e.printStackTrace(session.getConsole());
                session.getConsole().print(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
            }
        }
    }
}

