/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.cli.shell;

import griffon.util.BuildSettings;
import griffon.util.BuildSettingsHolder;
import griffon.util.GriffonExceptionHandler;
import griffon.util.GriffonNameUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.Terminal;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.runtime.CommandProcessorImpl;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.jline.Console;
import org.codehaus.griffon.cli.GriffonScriptRunner;
import org.codehaus.griffon.cli.GriffonSetup;
import org.codehaus.griffon.cli.shell.GriffonShellContext;
import org.codehaus.griffon.cli.shell.KarafMain;
import org.codehaus.griffon.cli.shell.command.ReloadCommandsCommand;
import org.fusesource.jansi.Ansi;

@Command(scope="griffon", name="griffon", description="Executes the Griffon interactive shell")
public class GriffonShell
extends KarafMain
implements Action {
    private static final Pattern SYSTEM_PROPERTY_PATTERN = Pattern.compile("-D(.+?)=(['\"].+?['\"]|.+?)");
    private static final Map<String, String> SYSTEM_PROPERTIES = new LinkedHashMap<String, String>();
    @Argument(name="args", description="griffon command arguments", multiValued=true)
    private String[] args = new String[0];

    public static void main(String[] args) {
        Ansi.ansi();
        try {
            String[] transformedArgs = GriffonShell.processSystemArguments(args);
            new GriffonShell().run(transformedArgs);
        }
        catch (Exception e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
    }

    public GriffonShell() {
        this.setUser("me");
        this.setApplication("griffon");
        String griffonHome = System.getProperty("griffon.home");
        BuildSettings buildSettings = null;
        try {
            buildSettings = new BuildSettings(new File(griffonHome));
        }
        catch (Exception e) {
            System.err.println("An error occurred loading the griffon-app/conf/BuildConfig.groovy file: " + e.getMessage());
            System.exit(1);
        }
        File griffonHomeInSettings = buildSettings.getGriffonHome();
        if (griffonHomeInSettings == null || !griffonHomeInSettings.exists()) {
            GriffonShell.exitWithError("Griffon' installation directory not found: " + buildSettings.getGriffonHome());
        }
        System.setProperty("griffon.command.launcher", "griffonsh");
        System.setProperty("griffon.disable.exit", "true");
        GriffonScriptRunner runner = new GriffonScriptRunner(buildSettings);
        GriffonShellContext.setGriffonScriptRunner(runner);
        buildSettings.getSystemProperties().putAll(SYSTEM_PROPERTIES);
        runner.setup();
    }

    private static String[] processSystemArguments(String[] args) {
        ArrayList<String> transformedArgs = new ArrayList<String>();
        for (String arg : args) {
            Matcher m = SYSTEM_PROPERTY_PATTERN.matcher(arg);
            if (m.matches()) {
                String key = m.group(1).trim();
                String value = GriffonNameUtils.unquote((String)m.group(2).trim());
                SYSTEM_PROPERTIES.put(key, value);
                System.setProperty(key, value);
                continue;
            }
            transformedArgs.add(arg);
        }
        GriffonShellContext.setInitialSystemProperties(SYSTEM_PROPERTIES);
        GriffonShellContext.setSystemProperties(SYSTEM_PROPERTIES);
        return transformedArgs.toArray(new String[transformedArgs.size()]);
    }

    private static void exitWithError(String error) {
        System.out.println(error);
        System.exit(1);
    }

    public boolean isMultiScopeMode() {
        return true;
    }

    protected Console createConsole(CommandProcessorImpl commandProcessor, InputStream in, PrintStream out, PrintStream err, Terminal terminal) throws Exception {
        String bold = "\u001b[1m";
        String plain = "\u001b[0m";
        return new Console((CommandProcessor)commandProcessor, in, out, err, terminal, null){

            protected String getPrompt() {
                return "\u001b[1mgriffon> \u001b[0m";
            }

            protected void welcome() {
                BuildSettings buildSettings = BuildSettingsHolder.getSettings();
                File griffonHome = buildSettings.getGriffonHome();
                this.session.getConsole().println("Welcome to Griffon " + buildSettings.getGriffonVersion() + " - http://griffon-framework.org/" + '\n' + "Licensed under Apache Standard License 2.0" + '\n' + "Griffon home is " + (griffonHome == null ? "not set" : "set to: " + griffonHome) + '\n' + '\n' + "Type 'exit' or ^D to terminate this interactive shell" + '\n' + '\n');
                GriffonSetup.run();
            }

            protected void setSessionProperties() {
            }
        };
    }

    public String getDiscoveryResource() {
        return "META-INF/services/org.codehaus.griffon/commands.index";
    }

    public Object execute(CommandSession session) throws Exception {
        this.run(session, this.args);
        return null;
    }

    protected void discoverCommands(CommandProcessorImpl commandProcessor, ClassLoader cl) throws IOException, ClassNotFoundException {
        super.discoverCommands(commandProcessor, cl);
        ReloadCommandsCommand.reload();
    }
}

