/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitFlap
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "splitflap";
    private ObjectProperty<Color> color = new SimpleObjectProperty((Object)Color.rgb((int)56, (int)56, (int)56));
    private ObjectProperty<Color> characterColor = new SimpleObjectProperty((Object)Color.WHITE);
    private ObjectProperty<Type> type = new SimpleObjectProperty((Object)Type.NUMERIC);
    private IntegerProperty character;
    private LongProperty flipTimeInMs;
    private BooleanProperty countdownMode;
    private boolean keepAspect;

    public SplitFlap() {
        this("0");
    }

    public SplitFlap(String CHARACTER) {
        this.character = new SimpleIntegerProperty((int)CHARACTER.charAt(0));
        this.flipTimeInMs = new SimpleLongProperty(200000000L);
        this.countdownMode = new SimpleBooleanProperty(false);
        this.keepAspect = true;
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public final Color getColor() {
        return (Color)this.color.get();
    }

    public final void setColor(Color COLOR) {
        this.color.set((Object)COLOR);
    }

    public final ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public final Color getCharacterColor() {
        return (Color)this.characterColor.get();
    }

    public final void setCharacterColor(Color COLOR) {
        this.characterColor.set((Object)COLOR);
    }

    public final ObjectProperty<Color> characterColorProperty() {
        return this.characterColor;
    }

    public final Type getType() {
        return (Type)((Object)this.type.get());
    }

    public final void setType(Type TYPE) {
        this.type.set((Object)TYPE);
    }

    public final ObjectProperty<Type> typeProperty() {
        return this.type;
    }

    public final char getCharacter() {
        return (char)this.character.get();
    }

    public final void setCharacter(String CHARACTER) {
        if (!CHARACTER.isEmpty() || CHARACTER.charAt(0) >= ((Type)((Object)this.type.get())).LOWER_BOUND && CHARACTER.charAt(0) <= ((Type)((Object)this.type.get())).UPPER_BOUND) {
            this.character.set((int)CHARACTER.charAt(0));
        } else {
            this.character.set(32);
        }
    }

    public final IntegerProperty characterProperty() {
        return this.character;
    }

    public final long getFlipTimeInMs() {
        return this.flipTimeInMs.get();
    }

    public final void setFlipTimeInMs(long FLIP_TIME_IN_MS) {
        this.flipTimeInMs.set(FLIP_TIME_IN_MS < 16L ? 16L : (FLIP_TIME_IN_MS > 3000L ? 3000L : FLIP_TIME_IN_MS));
    }

    public final LongProperty flipTimeInMsProperty() {
        return this.flipTimeInMs;
    }

    public final boolean isCountdownMode() {
        return this.countdownMode.get();
    }

    public final void setCountdownMode(boolean COUNTDOWN_MODE) {
        this.countdownMode.set(COUNTDOWN_MODE);
    }

    public final BooleanProperty countdownModeProperty() {
        return this.countdownMode;
    }

    public void setPrefSize(double WIDTH, double HEIGHT) {
        double prefHeight = WIDTH < HEIGHT * 0.5925925925925926 ? WIDTH * 1.6875 : HEIGHT;
        double prefWidth = prefHeight * 0.5925925925925926;
        if (this.keepAspect) {
            super.setPrefSize(prefWidth, prefHeight);
        } else {
            super.setPrefSize(WIDTH, HEIGHT);
        }
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("extras.css").toExternalForm();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NUMERIC(48, 57),
        ALPHANUMERIC(32, 94),
        TIME(48, 53);

        public final int LOWER_BOUND;
        public final int UPPER_BOUND;

        private Type(int LOWER_BOUND, int UPPER_BOUND) {
            this.LOWER_BOUND = LOWER_BOUND;
            this.UPPER_BOUND = UPPER_BOUND;
        }
    }
}

